/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package mockitofactory;

import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import static org.junit.Assert.*;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;

/**
 *
 * @author amelie.cordier
 */
@RunWith(MockitoJUnitRunner.class)
public class DB_ConnectorTest {
    
    
    private String DURAND = "DURAND";
    
    @Spy
    private DB_Connector c2 = new DB_Connector ();

    public DB_ConnectorTest() {
    }
    
    @BeforeClass
    public static void setUpClass() {
    }
    
    @AfterClass
    public static void tearDownClass() {
    }
    
    @Before
    public void setUp() {
    }
    
    @After
    public void tearDown() {
    }

    @Test
    public void testgetClientName() {
        DB_Connector mockDB_connector = Mockito.mock(DB_Connector.class);
        Mockito.when(mockDB_connector.getClientName(Mockito.anyInt())).thenReturn("toto").thenReturn("tata").thenReturn("titi");
        
        // Spécification de plusieurs valeurs en utilisant le chaînage de when ... then ... then ... 
        
        
        String expectedReturn = "toto";
        //int iId = 8;
        String sRet = mockDB_connector.getClientName(1);
        
        assertEquals(expectedReturn, sRet);
        assertEquals("tata", mockDB_connector.getClientName(5));
        assertEquals("titi", mockDB_connector.getClientName(2));
        
        //vérifie appel de mockDB_connector.getClientName(15)
        Mockito.verify(mockDB_connector).getClientName(5);
        Mockito.verify(mockDB_connector, Mockito.atLeast(2)).getClientName(Mockito.anyInt());
        //vérifie non appel de mockDB_connector..getClientTest()
        Mockito.verify(mockDB_connector, Mockito.never()).getClientTest();
        //vérifie que mockDB_connector.getClientName(Mockito.anyInt()) a été appelé 2 fois
        Mockito.verify(mockDB_connector, Mockito.times(3)).getClientName(Mockito.anyInt());
                
        
    }
    
    @Test
    public void testUpdateFirstAndLastName()
    {
        //DB_Connector c = new DB_Connector ();
        //c = Mockito.spy(c);
        c2.updateFirstAndLastName(1, DURAND, "z");
        Mockito.verify(c2).updateFirstName(1, "z");
        Mockito.verify(c2).updateLastName(1, DURAND);
    }
    
     @Test(expected=RuntimeException.class)
    public void testStubbing()
    {
        List mockedList = mock(List.class);
        when(mockedList.get(0)).thenReturn("first");
        doThrow(new RuntimeException()).when(mockedList.get(1));
        System.out.println(mockedList.get(0));
        System.out.println(mockedList.get(1));
        System.out.println(mockedList.get(999));
        
    }
}
