/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package mockitodasib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import static org.junit.Assert.*;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import static org.mockito.Mockito.*;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;

/**
 *
 * @author amelie.cordier
 */
@RunWith(MockitoJUnitRunner.class)
public class MockitoDASIBTest {
    
    @Mock ArrayList<Integer> spy2;
    
    @Test
    public void test2()
    {
        spy2.add(1);
        verify(spy2).add(1);
    }
    
    @Test
    public void iterator_will_return_hello_world(){
            //arrange
            Iterator i=mock(Iterator.class);
            when(i.next()).thenReturn("Hello").thenReturn("World");
            //act
            String result=i.next()+" "+i.next();
            //assert
            assertEquals("Hello World", result);
    }
    
    @Test
    public void test_toto(){
        List mockedlist = mock(List.class);
        when(mockedlist.get(anyInt())).thenReturn("toto");
        assertEquals("toto",mockedlist.get(78));
    }
    
    @Test
    public void testAnyString(){
        List<String> mockedlist = mock(List.class);
        when(mockedlist.set(anyInt(),anyString())).thenReturn("okay");
        assertEquals("okay",mockedlist.set(1,"hello"));
    }
            
    
    //Utilisation des annotations (instructions compilateur) 
    // On évite deux ligne de codes avec des annotations
    // Dans des befores au début de la classe de test   
    @Spy
    List<Integer> spy = new ArrayList<>();
    
    @Test
    public void testSpyVerify(){
        //List<Integer> list = new ArrayList<>();
        //List spy = spy(list);
        
        when(spy.size()).thenReturn(100);
        
        spy.add(1);
        spy.add(2);
        
        System.out.println(spy.get(0));
        System.out.println(spy.size());
        
        
        
        /*verify(spy).add(1);
        verify(spy).add(2);*/
        
        /*Test vrai !*/
        //verify(spy, never()).add(3);
    }
    
    @Test(expected=NullPointerException.class)
    public void testException(){
        List myMockedList = mock(ArrayList.class);
       
        when(myMockedList.get(anyInt())).thenThrow(new NullPointerException());
        System.out.println(myMockedList.get(1));
    }
    
    @Test
    public void testUser()
    {
        User user = mock(User.class);
        System.out.println(user.getLogin()); // affiche null
        user.setLogin("bob");
        System.out.println(user.getLogin()); // affiche encore null !

        // on rétablit le getLogin()
        when(user.getLogin()).thenCallRealMethod();

        // affiche null mais cette fois car la variable login vaut vraiment null dans le mock
        System.out.println(user.getLogin());

        // on rétablit également le comportement de la méthode setLogin()
        doCallRealMethod().when(user).setLogin(anyString());

        user.setLogin("antho");
        System.out.println(user.getLogin()); // affiche enfin "antho" !
    }
}
