#!/bin/bash

test-absolute () {
    echo "$1" | grep -q '^/'
}

while [ $# -gt 0 ]
do
    if [ $# -gt 1 ]
    then
        if [ $1 = --bindir ]
        then 
            bindir=$2
        elif [ $1 = --prefix ]
        then 
            prefix=$2
        elif [ $1 = --tclpdir ]
        then 
            tclpdir=$2
        fi
        shift; shift
    else
        echo "Illegal argument: $1"
        echo "usage: ./install.sh [ --prefix <dir> ] [ --bindir <dir> ] [ --tclpdir <dir> ]"
        exit 1
    fi
done

if [ -z "$prefix" ] && [ -z "$bindir" -o -z "$tclpdir" ]
then
    defaultInstallDir=/usr/local
    echo -n 'Install TCLP in [/usr/local]: '
    read prefix
    if [ -z "$prefix" ]
    then prefix=$defaultInstallDir
    fi
fi
if [ -z "$bindir" ]
then bindir=$prefix/bin
fi
if [ -z "$tclpdir" ]
then tclpdir=$prefix/tclp
fi

([ -n "$prefix" ] && test-absolute $prefix ) || prefix=$PWD/$prefix
test-absolute $bindir || bindir=$PWD/$bindir
test-absolute $tclpdir || tclpdir=$PWD/$tclpdir

echo "creating $prefix $bindir $tclpdir"
mkdir -p $prefix $bindir $tclpdir
echo "copying tclp files into $tclpdir ..."
cp -R * $tclpdir
echo "symlink of tclp in $bindir"
ln -s $tclpdir/tclp $bindir
echo "tclp command:"
echo $bindir/tclp

