%% assoc.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/assoc.typ,v 1.5 2003/08/19 10:18:03 coquery Exp $

%% Types file for assoc module in Sicstus Prolog library

:- type assoc(A,B).
:- typeof assoc_to_list(assoc(A,B), list(pair(A,B))) is pred.
:- typeof empty_assoc(assoc(A,B)) is pred.
:- typeof del_assoc(A, assoc(A,B), B, assoc(A,B)) is pred.
:- typeof del_max_assoc(assoc(A,B), A, B, assoc(A,B)) is pred.
:- typeof del_min_assoc(assoc(A,B), A, B, assoc(A,B)) is pred.
:- typeof gen_assoc(A, assoc(A,B),B) is pred.
:- typeof get_assoc(A, assoc(A,B),B) is pred.
:- typeof get_assoc(A, assoc(A,B),B, assoc(A,B), B) is pred.
:- typeof get_next_assoc(A, assoc(A,B),A,B) is pred.
:- typeof get_prev_assoc(A, assoc(A,B),A,B) is pred.
:- typeof is_assoc(term) is pred.
:- typeof list_to_assoc(list(pair(A,B)), assoc(A,B)) is pred.
:- typeof map_assoc(atom, assoc(term,term)) is pred.
:- typeof map_assoc(atom, assoc(term,term), assoc(term,term)) is pred.
:- typeof max_assoc(assoc(A,B),A,B) is pred.
:- typeof min_assoc(assoc(A,B),A,B) is pred.
:- typeof ord_list_to_assoc(list(pair(A,B)), assoc(A,B)) is pred.
:- typeof put_assoc(A,assoc(A,B),B,assoc(A,B)) is pred.
