%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                                   TCLP                                    %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/chr.typ,v 1.3 2003/11/21 16:56:18 coquery Exp $

%% Types for the chr module in sicstus prolog

:- typeof operator(int, op_mode, term) is pred.

:- typeof (handler atom) is pred.
:- untyped constraints/1.

:- type chr_constraint.
:- order chr_constraint < pred.

:- type chr_id.

:- type chr_c_conj is
        [ (chr_c_conj, chr_c_conj) ].
:- order chr_constraint < chr_c_conj.
:- order chr_constraint_id < chr_c_conj.

:- type chr_constraint_id is [ (chr_constraint # chr_id) ].

:- type chr_head is [ ( chr_c_conj \ chr_c_conj ) ].
:- order chr_c_conj < chr_head.

:- type chr_body is [ ( guard | goal ) ].
:- order goal < chr_body.

:- type guard is [ (goal & goal) ].
:- order goal < guard.

:- type pragma is [ (pragma , pragma),
                    already_in_heads,
                    already_in_head(chr_id),
                    passive(chr_id) ].

:- typeof (atom @ A) is A.
:- typeof (chr_head <=> chr_body) is pred.
:- typeof (chr_c_conj ==> chr_body) is pred.
:- typeof pragma(pred,pragma) is pred.

:- type chr_option is [ check_guard_bindings,
                        debug_compile,
                        already_in_store,
                        already_in_heads ].

:- type onoff is [ on, off ].
:- typeof option(chr_option , onoff) is pred.

% built-in predicates
:- typeof current_handler(atom,atom) is pred.
:- typeof current_constraint(atom, functor) is pred.
:- typeof insert_constraint(chr_constraint, chr_id) is pred.
:- typeof insert_constraint(chr_constraint, chr_id, term) is pred.
:- typeof find_constraint(chr_constraint, chr_id) is pred.
:- typeof find_constraint(term, chr_constraint, chr_id) is pred.
:- typeof findall_constraints(chr_constraint,
                              list(chr_constraint_id)) is pred.
:- typeof findall_constraints(term, chr_constraint,
                              list(chr_constraint_id)) is pred.
:- typeof remove_constraint(chr_id) is pred.
:- typeof unconstrained(A) is pred.
:- typeof notify_constrained(A) is pred.

% defining constraints
:- tclp__load_prolog(tclplib('sicstus/chrcore.pl')).


:- tclp__define_clause((_ @ Rule), Location, Heads, Bodies,
                       (user:args_location(Location,[_,RuleLoc]),
                           chr__clause(Rule, RuleLoc, Heads, Bodies))).
:- tclp__define_clause(Rule, Location, Heads, Bodies,
                       (chr__clause(Rule, Location, Heads, Bodies))).
