%% clpb.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/clpb.typ,v 1.3 2002/04/24 12:22:10 coquery Exp $

%% Types for clpb Sicstus Library

:- op(300, fy, [~]).
:- op(500, yfx, [#]).

:- type boolean.
:- typeof 0 is boolean.
:- typeof 1 is boolean.
:- order boolean < int.
:- type boolean_expr is [ ~ boolean_expr,
                          boolean_expr * boolean_expr,
                          boolean_expr + boolean_expr,
                          boolean_expr # boolean_expr,
                          boolean ^ boolean_expr,
                          boolean_expr =:= boolean_expr,
                          boolean_expr =\= boolean_expr,
                          boolean_expr =< boolean_expr,
                          boolean_expr >= boolean_expr,
                          boolean_expr < boolean_expr,
                          boolean_expr > boolean_expr,
                          card(list(int), list(boolean_expr)) ].
:- order boolean < boolean_expr.

:- typeof sat(boolean_expr) is pred.
:- typeof taut(boolean_expr, boolean) is pred.
:- typeof labeling(list(boolean)) is pred.
