%% clpqr.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                                   TCLP                                    %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/clpqr.typ,v 1.2 2002/06/18 12:36:15 coquery Exp $
:- type constraint_r.

:- typeof ','(constraint_r,constraint_r) is constraint_r.
:- type clpqr_expr is [ +(clpqr_expr) ,
                        -(clpqr_expr) ,
                        clpqr_expr + clpqr_expr,
                        clpqr_expr - clpqr_expr,
                        clpqr_expr * clpqr_expr,
                        clpqr_expr / clpqr_expr,
                        abs(clpqr_expr),
                        sin(clpqr_expr),
                        cos(clpqr_expr),
                        tan(clpqr_expr),
                        asin(clpqr_expr),
                        acos(clpqr_expr),
                        atan(clpqr_expr),
                        pow(clpqr_expr,clpqr_expr),
                        exp(clpqr_expr,clpqr_expr),
                        log(clpqr_expr),
                        min(clpqr_expr,clpqr_expr),
                        max(clpqr_expr,clpqr_expr),
                        clpqr_expr^clpqr_expr,
                        #(atom)].
:- type clpqr_value is [ rat(clpqr_expr,clpqr_expr) ].
:- order int < clpqr_value.
:- order float < clpqr_value.
:- order clpqr_value < clpqr_expr.
        
:- typeof (clpqr_expr =:= clpqr_expr) is constraint_r.
:- typeof (clpqr_expr = clpqr_expr) is constraint_r.
:- typeof (clpqr_expr < clpqr_expr) is constraint_r.
:- typeof (clpqr_expr > clpqr_expr) is constraint_r.
:- typeof (clpqr_expr =< clpqr_expr) is constraint_r.
:- typeof (clpqr_expr >= clpqr_expr) is constraint_r.
:- typeof <=(clpqr_expr,clpqr_expr) is constraint_r.
:- typeof (clpqr_expr =\= clpqr_expr) is constraint_r.
:- typeof (constraint_r , constraint_r) is constraint_r.
:- typeof (constraint_r ; constraint_r) is constraint_r.

:- typeof '{}'(constraint_r) is pred.
:- typeof entailed(constraint_r) is pred.
:- typeof inf(clpqr_expr, clpqr_value) is pred.
:- typeof inf(clpqr_expr, clpqr_expr, list(clpqr_value), list(clpqr_value)) 
        is pred.
:- typeof sup(clpqr_expr, clpqr_value) is pred.
:- typeof sup(clpqr_expr, clpqr_expr, list(clpqr_value), list(clpqr_value)) 
        is pred.
:- typeof minimize(clpqr_expr) is pred.
:- typeof maximize(clpqr_expr) is pred.
:- typeof bb_inf(list(int), clpqr_expr, int) is pred.
:- typeof bb_inf(list(int), clpqr_expr, int, list(int), float) is pred.
:- typeof ordering(term) is pred.
:- typeof dump(list(clpqr_value), list(clpqr_value), list(constraint_r))
        is pred.
:- typeof projecting_assert(clause) is pred.
