%% corelib.typ
%% this is used to defined the layouts of the clauses and other low level
%% definitions
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                                   TCLP                                    %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/corelib.typ,v 1.6 2003/01/15 16:09:35 coquery Exp $

%% Note that definitions for clauses layout are asserted in first position.
%% This means that the lastest ones are considered before the first ones,
%% which  is the reverse order w.r.t. standard prolog approch.
%% This is intended to allow one to refine later a clause layout definition

% directives
:- tclp__define_clause((:- Body),Location,[],[Body-BodyLocation],
                       (user:args_location(Location,[BodyLocation]))).

% module stuff
:- tclp__define_clause((_:Head),Location,HeadDef,BodyDef,
                       (
                         user:args_location(Location,[_,HeadLoc]),
                         tclp__clause(Head,HeadLoc,HeadDef,BodyDef)
                       )).

% standard clauses
:- tclp__define_clause((Head :- Body),Location,
                       HeadDef,[Body-BodyLoc|BodyDef],
                       (
                         user:args_location(Location,[HeadLoc,BodyLoc]),
                         tclp__clause(Head,HeadLoc,HeadDef,BodyDef)
                       )).

% goal expansions
:- tclp__define_clause(goal_expansion(Head,Module,Expansion), Location,
                       [Head-HLoc-pred],[Expansion-BLoc],
                       user:args_location(Location,[HLoc,_,BLoc])).

%:- tclp__define_clause((goal_expansion(Head,Module,Expansion) :- Body),
%                       Location,
%                       [Head-HLoc-pred],[Expansion-ELoc,Body-BLoc],
%                       (
%                         user:args_location(Location,[GLoc,BLoc]),
%                         user:args_location(GLoc,[HLoc,_,ELoc])
%                       )).

%:- tclp__define_clause((M:goal_expansion(Head,Module,Expansion) :- Body),
%                       Location,
%                       [Head-HLoc-pred],[Expansion-ELoc,Body-BLoc],
%                       (
%                         user:args_location(Location,[GLoc,BLoc]),
%                         user:args_location(GLoc,[_,GLoc2]),
%                         user:args_location(GLoc2,[HLoc,_,ELoc])
%                       )).

% built-in executable goals

% treatement of ","
:- tclp__executable((A,B),(executable_goal(A),executable_goal(B))).
:- tclp__add_hook((A,B),Location,(HA,HB),
                  (
                    user:args_location(Location,[LA,LB]),
                    get_hook(A,LA,HA),
                    get_hook(B,LB,HB)
                  )).

% since op is already a directive, we just need to say it is executable,
% in order to parse the file
:- tclp__executable(op(_, _, _)).

% allow the user to load some prolog definitions for tclp
:- tclp__executable(tclp__load_prolog(_)).
:- tclp__add_hook(tclp__load_prolog(File),
                  (absolute_file_name(File,F),consult(F))).

