%% heaps.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/heaps.typ,v 1.2 2002/04/24 12:22:11 coquery Exp $

%% Types for module heap in sicstus prolog

:- type  heap(A,B).
:- typeof add_to_heap(heap(A,B), A, B, heap(A,B)) is pred.
:- typeof delete_from_heap(heap(A,B), A, B, heap(A,B)) is pred.
:- typeof get_from_heap(heap(A,B), A, B, heap(A,B)) is pred.
:- typeof empty_heap(heap(A,B)) is pred.
:- typeof heap_size(heap(A,B), int) is pred.
:- typeof heap_to_list(heap(A,B), list(pair(A,B))) is pred.
:- typeof is_heap(heap(A,B)) is pred.
:- typeof list_to_heap(list(pair(A,B)), heap(A,B)) is pred.
:- typeof min_of_heap(heap(A,B), A, B) is pred.
:- typeof min_of_heap(heap(A,B), A, B, A, B) is pred.
