%% jasper.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/jasper.typ,v 1.3 2002/04/24 12:22:11 coquery Exp $

%% types for Sicstus Module jasper

:- type jvm.
:- type jvm_flag_value is [ ok , fail, error ].
:- type jvm_option is [ classpath(term) ,
                         if_exists(jvm_flag_value),
                         if_not_exists(jvm_flag_value)
                       ].
:- order atom < jvm_option.
:- type jasper_object.
:- typeof jasper_initialize(jvm) is pred.
:- typeof jasper_initialize(list(jvm_option), jvm) is pred.
:- typeof jasper_deinitialize(jvm) is pred.
:- typeof jasper_new_object(jvm, atom, atom, list(term), jasper_object) is pred.
:- typeof jasper_call_static(jvm, atom, atom, atom, list(term), term) is pred.
:- typeof jasper_call_instance(jvm, jasper_object, atom, atom, list(term), term) is pred.
:- typeof jasper_create_global_ref(jvm, jasper_object, jasper_object) is pred.
:- typeof jasper_delete_global_ref(jvm, jasper_object) is pred.
:- typeof jasper_delete_local_ref(jvm, jasper_object) is pred.
:- typeof jasper_is_object(jvm, jasper_object) is pred.
:- typeof jasper_is_same_object(jvm, jasper_object, jasper_object) is pred.
:- typeof jasper_is_instance_of(jvm, jasper_object, atom) is pred.
