%% sockets.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                                   TCLP                                    %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/sockets.typ,v 1.5 2002/09/23 14:53:10 coquery Exp $
:- type buffering_option is [read,write].
:- type socket.
:- type socket_address is [ 'AF_INET'(atom, int), 'AF_UNIX'(atom) ].
%:- order int < socket.
:- type timeout is [ off, ':'(int, int) ].
:- type socket_domain is [ 'AF_INET', 'AF_UNIX' ].
:- typeof socket(socket_domain, socket) is pred.
:- typeof socket_close(socket) is pred.
:- typeof socket_bind(socket, socket_address) is pred.
:- typeof socket_connect(socket, socket_address, stream) is pred.
:- typeof socket_listen(socket, int) is pred.
:- typeof socket_accept(socket, stream) is pred.
:- typeof socket_accept(socket, atom, stream) is pred.
:- typeof socket_buffering(stream, buffering_option, stream, stream) is pred.
:- type socket_connection is [ connection(atom,stream) ].
:- typeof socket_select(term,
                        list(term),
                        timeout,
                        list(stream),
                        list(stream)) is pred.
:- typeof socket_select(term,
                        list(stream),
                        list(atom),
                        timeout,
                        list(stream),
                        list(stream)) is pred.
:- typeof current_host(atom) is pred.
:- typeof hostname_address(atom, atom) is pred.
