%% stdlib.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/stdlib.typ,v 1.13 2003/12/19 13:23:18 coquery Exp $

%% Standard Library, type definitions for Sicstus Prolog in TCLP

:- tclp__include('corelib.typ').

%% The type predicates are untyped
:- untyped [ type/1, untyped/1, typeof/1 , order/1 , subtype/1].


%% Necessary types, needed by the type checker
:- type term. %% already defined, added for coherence
:- type int.
:- type float.
:- type atom.
:- type pred. %% predicates
:- type goal.
:- order pred < goal.
:- type character.
:- type in_character.
:- order character < in_character.
:- order in_character < atom.
:- type in_byte.
:- type byte.
:- order in_byte < int.
:- order byte < in_byte.
:- type int_expr.
:- order int < int_expr.
:- type float_expr.
:- order float < float_expr.

%% Loading files
:- typeof [ atom | list(atom) ] is pred.

%% Usual types
:- type list(A) is [ [] , [ A | list(A) ] ].
:- type true_false is [ true , false ].
:- type error_or_fail is [ error, fail ].
:- type functor is [ atom/int ].
:- type pair(A,B).

%% declarations
:- untyped [ multifile/1 , dynamic/1, volatile/1, 
             discontiguous/1, block/1, meta_predicate/1,
             public/1, mode/1 ].

%% code loading
:- typeof consult(atom) is pred.
:- typeof consult(list(atom)) is pred.
:- typeof compile(atom) is pred.
:- typeof compile(list(atom)) is pred.
:- typeof fcompile(atom) is pred.
:- typeof fcompile(list(atom)) is pred.
:- typeof ensure_loaded(atom) is pred.
:- typeof ensure_loaded(list(atom)) is pred.
:- typeof load_files(atom) is pred.
:- typeof load_files(list(atom)) is pred.
:- type true_changed is [ true , changed ].
:- type when_option is [ always, compile_time ].
:- type import_option is [ all ].
:- type compilation_mode is [ compile , consult , assert_all ].
:- type load_option is [ if(true_changed) ,when(when_option),
                         imports(import_option), import(list(functor)) ,
                         compilation_mode(compilation_mode),
                         wcx(wcx_mode) ].
:- typeof load_file(atom,list(load_option)) is pred.
:- typeof load_files(list(atom),list(load_option)) is pred.
:- typeof source_file(atom) is pred.
:- typeof require(functor) is pred.
:- typeof require(list(functor)) is pred.

%% Term expansion
:- typeof expand_term(term,term) is pred.
:- typeof term_expansion(term,term) is pred.
:- typeof term_expansion(term,term,term,term) is pred.
:- typeof goal_expansion(goal,atom,goal) is pred.
:- typeof phrase(term,list(atom)) is pred.
:- typeof phrase(term,list(atom),list(atom)) is pred.
:- typeof 'C'(term,term,term) is pred.

%% WCX environment
:- type wcx_mode is [ iso_8859_1 , utf8 , euc ].

%% term IO
:- typeof read(stream_or_alias,term) is pred.
:- typeof read(term) is pred.
:- type equal_pair(A,B) is [ A=B ].
:- type read_term_option is [ syntax_errors(term),
                              variables(list(term)),
                              variable_names(list(equal_pair(atom,term))),
                              cycles(true_false),
                              layout(term),
                              consume_layout(true_false),
                              singletons(list(term)) ].
:- typeof read_term(term,list(read_term_option)) is pred.
:- typeof read_term(stream_or_alias,term,list(read_term_option)) is pred.
:- typeof char_conversion(character,character) is pred.
:- typeof current_char_conversion(character,character) is pred.
:- typeof write(stream_or_alias,term) is pred.
:- typeof write(term) is pred.
:- typeof display(term) is pred.
:- typeof writeq(term) is pred.
:- typeof writeq(stream_or_alias,term) is pred.
:- typeof write_canonical(term) is pred.
:- typeof write_canonical(stream_or_alias,term) is pred.
:- typeof print(term) is pred.
:- typeof print(stream_or_alias,term) is pred.
:- typeof portray(term) is pred.
:- typeof portray_clause(clause) is pred.
:- typeof portray_clause(stream_or_alias,clause) is pred.
:- type write_option is [ quoted(true_false),
                          ignore_ops(true_false),
                          numbervars(true_false),
                          portrayed(true_false),
                          cycles(true_false),
                          indented(true_false),
                          max_depth(int) ].
:- typeof write_term(stream_or_alias,term,list(write_option)) is pred.
:- typeof write_term(term,list(write_option)) is pred.
:- typeof format(stream_or_alias,list(int),term) is pred.
:- typeof format(stream_or_alias,atom,term) is pred.
:- typeof format(list(int),term) is pred.
:- typeof format(atom,term) is pred.

%% character io
:- typeof nl is pred.
:- typeof nl(stream_or_alias) is pred.
:- typeof get_code(stream_or_alias, int) is pred.
:- typeof get_code(int) is pred.
:- typeof get_char(stream_or_alias, in_character) is pred.
:- typeof get_char(in_character) is pred.
:- typeof get_byte(stream_or_alias, in_byte) is pred.
:- typeof get_byte(in_byte) is pred.
:- typeof peek_char(stream_or_alias, int) is pred.
:- typeof peek_char(int) is pred.
:- typeof peek_code(stream_or_alias, int) is pred.
:- typeof peek_code(int) is pred.
:- typeof peek_byte(stream_or_alias, in_byte) is pred.
:- typeof peek_byte(in_byte) is pred.
:- typeof skip_line is pred.
:- typeof skip_line(stream_or_alias) is pred.
:- typeof read_line(list(int)) is pred.
:- typeof read_line(stream_or_alias, list(int)) is pred.
:- typeof put_char(stream_or_alias, character) is pred.
:- typeof put_char(character) is pred.
:- typeof put_code(stream_or_alias, int) is pred.
:- typeof put_code(int) is pred.
:- typeof put_byte(stream_or_alias, byte) is pred.
:- typeof put_byte(byte) is pred.
:- typeof put(int) is pred. % Obsolescent
:- typeof put(stream_or_alias,int) is pred. % Obsolescent
:- typeof tab(int) is pred. %[Obsolescent]
:- typeof tab(stream_or_alias,int) is pred. %[Obsolescent] 


%% stream io
:- type filename is [system(filename), library(filename)].
:- order atom < filename.
:- type stream.
:- type stream_or_alias.
:- order stream < stream_or_alias.
:- order atom < stream_or_alias.
:- typeof absolute_file_name(filename,filename) is pred.
:- type file_type is [ text , source, object, ql, saved_state,
                       foreign_file, foreign_resource, directory ].
:- type access_mode is [ read , write , append , exists , none ].
:- type solution_spec is [ all , first ].
:- type absolute_file_name_option is [ ignore_underscores(true_false),
                                       extensions(list(atom)),
                                       file_type(file_type),
                                       access(access_mode),
                                       file_errors(error_or_fail),
                                       fileerrors(error_or_fail),
                                       solutions(solution_spec),
                                       relative_to(filename) ].
:- typeof absolute_file_name(filename,filename,
                             list(absolute_file_name_option)) is pred.
:- typeof file_search_path(filename,filename) is pred.
:- typeof library_directory(filename) is pred.
:- type open_mode is [ read , write , append ].
:- typeof open(filename, open_mode, stream) is pred.
:- type eof_action is [ error , eof_code, reset ].
:- typeof stream_code(stream,int) is pred.
:- type open_option is [  type(file_type),
                          reposition(goal),
                          alias(atom),
                          eof_action(eof_action),
                          wcx(term) ].
:- typeof open(filename, open_mode, stream, list(open_option)) is pred.
:- typeof close(stream) is pred.
:- type close_option is [ force(goal) ].
:- typeof close(stream, list(close_option)) is pred.
:- typeof current_input(stream) is pred.
:- typeof current_output(stream) is pred.
:- typeof current_stream(filename,open_mode,stream) is pred.
:- typeof set_input(stream_or_alias) is pred.
:- typeof set_output(stream_or_alias) is pred.
:- typeof flush_output is pred.
:- typeof flush_output(stream_or_alias) is pred.
:- typeof open_null_stream(stream) is pred.
:- typeof character_count(stream,int) is pred.
:- typeof byte_count(stream,int) is pred.
:- typeof line_count(stream,int) is pred.
:- type stream_position.
:- typeof line_position(stream, stream_position) is pred.
:- type stream_position_field is [ line_count, character_count, 
                                   line_position, byte_count ].
:- typeof stream_position_data(stream_position_field, stream_position,
                               term) is pred.
:- type end_of_stream_value is [ at , not , past ].
:- type stream_property is [ file_name(atom),
                             mode(open_mode),
                             input,
                             output,
                             position(stream_position),
                             end_of_stream(end_of_stream_value)
                           ].
:- order open_option < stream_property.
:- typeof stream_property(stream, stream_property) is pred.
:- typeof set_stream_position(stream_or_alias, stream_position) is pred.
:- type seek_method is [ bof , current , eof ].
:- typeof seek(stream, int, seek_method, int) is pred.
:- typeof at_end_of_stream is pred.
:- typeof at_end_of_stream(stream_or_alias) is pred.
:- typeof at_end_of_line is pred.
:- typeof at_end_of_line(stream_or_alias) is pred.
:- typeof nofileerrors is pred.
:- typeof fileerrors is pred.

%% Dec-10 Prolog file I/O
:- typeof see(stream_or_alias) is pred.
:- typeof seeing(atom) is pred.
:- typeof seen is pred.
:- typeof tell(stream_or_alias) is pred.
:- typeof telling(atom) is pred.
:- typeof told is pred.

%% Arithmetics
% arithmetic expressions
:- typeof +(float_expr) is float_expr.
:- typeof +(int_expr) is int_expr.
:- typeof -(float_expr) is float_expr.
:- typeof -(int_expr) is int_expr.
:- typeof +(float_expr,int_expr) is float_expr.
:- typeof +(int_expr,float_expr) is float_expr.
:- typeof +(float_expr,float_expr) is float_expr.
:- typeof +(int_expr,int_expr) is int_expr.
:- typeof -(float_expr,int_expr) is float_expr.
:- typeof -(int_expr,float_expr) is float_expr.
:- typeof -(float_expr,float_expr) is float_expr.
:- typeof -(int_expr,int_expr) is int_expr.
:- typeof *(float_expr,int_expr) is float_expr.
:- typeof *(int_expr,float_expr) is float_expr.
:- typeof *(float_expr,float_expr) is float_expr.
:- typeof *(int_expr,int_expr) is int_expr.
:- typeof /(float_expr,int_expr) is float_expr.
:- typeof /(int_expr,float_expr) is float_expr.
:- typeof /(float_expr,float_expr) is float_expr.
:- typeof /(int_expr,int_expr) is float_expr.
:- typeof //(float_expr,int_expr) is int_expr.
:- typeof //(int_expr,float_expr) is int_expr.
:- typeof //(float_expr,float_expr) is int_expr.
:- typeof //(int_expr,int_expr) is int_expr.
:- typeof rem(float_expr,int_expr) is int_expr.
:- typeof rem(int_expr,float_expr) is int_expr.
:- typeof rem(float_expr,float_expr) is int_expr.
:- typeof rem(int_expr,int_expr) is int_expr.
:- typeof mod(float_expr,int_expr) is int_expr.
:- typeof mod(int_expr,float_expr) is int_expr.
:- typeof mod(float_expr,float_expr) is int_expr.
:- typeof mod(int_expr,int_expr) is int_expr.
:- typeof integer(int_expr) is int_expr.
:- typeof integer(float_expr) is int_expr.
:- typeof float_integer_part(float_expr) is int_expr.
:- typeof float_fractional_part(float_expr) is int_expr.
:- typeof float(float_expr) is float_expr.
:- typeof float(int_expr) is float_expr.
% bitwise operations
:- typeof /\(int_expr,int_expr) is int_expr.
:- typeof \/(int_expr,int_expr) is int_expr.
:- typeof #(int_expr,int_expr) is int_expr.
:- typeof \(int_expr) is int_expr.
:- typeof >>(int_expr,int_expr) is int_expr.
:- typeof <<(int_expr,int_expr) is int_expr.
% other
:- typeof abs(int_expr) is int_expr.
:- typeof abs(float_expr) is float_expr.
:- typeof sign(float_expr) is float_expr.
:- typeof sign(int_expr) is int_expr.
:- typeof gcd(int_expr,int_expr) is int_expr.
:- typeof min(float_expr,int_expr) is float_expr.
:- typeof min(int_expr,float_expr) is float_expr.
:- typeof min(float_expr,float_expr) is float_expr.
:- typeof min(int_expr,int_expr) is int_expr.
:- typeof max(float_expr,int_expr) is float_expr.
:- typeof max(int_expr,float_expr) is float_expr.
:- typeof max(float_expr,float_expr) is float_expr.
:- typeof max(int_expr,int_expr) is int_expr.
:- typeof msb(int_expr) is int_expr.
:- typeof round(float_expr) is int_expr.
:- typeof truncate(float_expr) is int_expr.
:- typeof floor(float_expr) is float_expr.
:- typeof ceiling(float_expr) is int_expr.
:- typeof sin(int_expr) is float_expr.
:- typeof sin(float_expr) is float_expr.
:- typeof cos(int_expr) is float_expr.
:- typeof cos(float_expr) is float_expr.
:- typeof tan(int_expr) is float_expr.
:- typeof tan(float_expr) is float_expr.
:- typeof cot(int_expr) is float_expr.
:- typeof cot(float_expr) is float_expr.
:- typeof sinh(int_expr) is float_expr.
:- typeof sinh(float_expr) is float_expr.
:- typeof cosh(int_expr) is float_expr.
:- typeof cosh(float_expr) is float_expr.
:- typeof tanh(int_expr) is float_expr.
:- typeof tanh(float_expr) is float_expr.
:- typeof asin(int_expr) is float_expr.
:- typeof asin(float_expr) is float_expr.
:- typeof acos(int_expr) is float_expr.
:- typeof acos(float_expr) is float_expr.
:- typeof atan(int_expr) is float_expr.
:- typeof atan(float_expr) is float_expr.
:- typeof acot(int_expr) is float_expr.
:- typeof acot(float_expr) is float_expr.
:- typeof acot2(float_expr,int_expr) is float_expr.
:- typeof acot2(int_expr,float_expr) is float_expr.
:- typeof acot2(float_expr,float_expr) is float_expr.
:- typeof acot2(int_expr,int_expr) is float_expr.
:- typeof asinh(int_expr) is float_expr.
:- typeof asinh(float_expr) is float_expr.
:- typeof acosh(int_expr) is float_expr.
:- typeof acosh(float_expr) is float_expr.
:- typeof atanh(int_expr) is float_expr.
:- typeof atanh(float_expr) is float_expr.
:- typeof sqrt(int_expr) is float_expr.
:- typeof sqrt(float_expr) is float_expr.
:- typeof log(int_expr) is float_expr.
:- typeof log(float_expr) is float_expr.
:- typeof log(int_expr,int_expr) is float_expr.
:- typeof log(int_expr,float_expr) is float_expr.
:- typeof log(float_expr,int_expr) is float_expr.
:- typeof log(float_expr,float_expr) is float_expr.
:- typeof exp(int_expr) is float_expr.
:- typeof exp(float_expr) is float_expr.
:- typeof exp(int_expr,int_expr) is int_expr.
:- typeof exp(int_expr,float_expr) is float_expr.
:- typeof exp(float_expr,int_expr) is float_expr.
:- typeof exp(float_expr,float_expr) is float_expr.
:- typeof **(int_expr,int_expr) is int_expr.
:- typeof **(int_expr,float_expr) is float_expr.
:- typeof **(float_expr,int_expr) is float_expr.
:- typeof **(float_expr,float_expr) is float_expr.
:- typeof inf is float_expr.
:- typeof nan is float_expr.
% arithmetic predicates
:- typeof is(float,float_expr) is pred.
:- typeof is(int,int_expr) is pred.
:- typeof =:=(float_expr,int_expr) is pred.
:- typeof =:=(int_expr,float_expr) is pred.
:- typeof =:=(float_expr,float_expr) is pred.
:- typeof =:=(int_expr,int_expr) is pred.
:- typeof =\=(float_expr,float_expr) is pred.
:- typeof =\=(int_expr,int_expr) is pred.
:- typeof <(float_expr,float_expr) is pred.
:- typeof <(int_expr,int_expr) is pred.
:- typeof >(float_expr,float_expr) is pred.
:- typeof >(int_expr,int_expr) is pred.
:- typeof =<(float_expr,float_expr) is pred.
:- typeof =<(int_expr,int_expr) is pred.
:- typeof >=(float_expr,float_expr) is pred.
:- typeof >=(int_expr,int_expr) is pred.

%% term comparison
:- typeof ==(A,A) is pred.
:- typeof \==(A,A) is pred.
:- typeof @<(A,A) is pred.
:- typeof @>(A,A) is pred.
:- typeof @=<(A,A) is pred.
:- typeof @>=(A,A) is pred.
:- typeof ?=(A,A) is pred.
:- type compare_result is [ '=' , '<' , '>' ]. 
:- typeof compare(compare_result, A,A) is pred.
:- typeof sort(list(A),list(A)) is pred.
:- typeof keysort(list(pair(A,B)),list(pair(A,B))) is pred.

%% Control structures
:- typeof (goal,goal) is goal.
:- typeof ';'(goal,goal) is goal.
:- typeof '!' is pred.
:- typeof (\+ goal) is goal.
:- typeof '->'(goal,goal) is goal.
:- typeof if(goal,goal,goal) is pred.
:- typeof once(goal) is pred.
:- typeof true is pred.
:- typeof otherwise is pred.
:- typeof false is pred.
:- typeof fail is pred.
:- typeof repeat is pred.
:- typeof call(goal) is pred.
:- typeof call_cleanup(goal,goal) is pred.

%% Error and exception handling
:- typeof on_exception(term,goal,goal) is pred.
:- typeof catch(goal,term,goal) is pred.
:- typeof throw(term) is pred.
:- typeof raise_exception(term) is pred.

%% Information about the State of the Program
:- typeof listing is pred.
:- typeof listing(list(functor)) is pred.
:- typeof current_atom(atom) is pred.
:- typeof current_predicate(atom,pred) is pred.
:- typeof current_predicate(functor) is pred.
:- typeof predicate_property(pred,term) is pred.
:- typeof current_module(atom) is pred.
:- typeof current_module(atom,atom) is pred.
:- typeof set_prolog_flag(term,term) is pred.
:- typeof prolog_flag(term,term,term) is pred.
:- typeof prolog_flag(term,term) is pred.
:- typeof current_prolog_flag(term,term) is pred.
:- type load_context_key is [ source , file , directory , module ,
                              stream , term_position ].
:- typeof prolog_load_context(load_context_key,term) is pred.
:- typeof statistics is pred.
:- type statistics_key is [ global_stack , local_stack , trail ,
                            choice , core , memory , heap , program ,
                            runtime , walltime , garbage_collection ,
                            stack_shifts , atoms , atom_garbage_collection ].
:- typeof statistics(statistics_key,list(term)) is pred.
:- typeof trimcore is pred.

%% Meta-Logic
:- typeof var(A) is pred.
:- typeof nonvar(A) is pred.
:- typeof ground(term) is pred.
:- typeof atom(term) is pred.
:- typeof float(term) is pred.
:- typeof integer(term) is pred.
:- typeof number(term) is pred.
:- typeof atomic(term) is pred.
:- typeof simple(term) is pred.
:- typeof compound(term) is pred.
:- typeof callable(term) is pred.
:- typeof is_mutable(term) is pred.
:- typeof functor(term,atom,int) is pred.
:- typeof arg(int, term, term) is pred.
:- typeof =..(term, list(term)) is pred.
:- typeof atom_codes(atom,list(int)) is pred.
:- typeof number_codes(int,list(int)) is pred.
:- typeof number_codes(float,list(int)) is pred.
:- typeof atom_chars(atom,list(int)) is pred.
:- typeof number_chars(int,list(int)) is pred.
:- typeof number_chars(float,list(int)) is pred.
:- typeof char_code(character,int) is pred.
:- typeof atom_length(atom,int) is pred.
:- typeof atom_concat(atom,atom,atom) is pred.
:- typeof sub_atom(atom,int,int,int,atom) is pred.
:- typeof copy_term(A,A) is pred.

%% Modification of Terms
:- type mutable.
:- typeof create_mutable(term,mutable) is pred.
:- typeof get_mutable(term,mutable) is pred.
:- typeof update_mutable(term,mutable) is pred.

%% Modification of the Program
% types
:- type clause is [ (pred :- goal) ].
:- type directive is [ (:- goal) ].
:- type phrase.
:- order clause < phrase.
:- order directive < phrase.
:- order pred < clause.
:- type clause_ref.
% predicates
:- typeof assert(clause) is pred.
:- typeof assert(clause,clause_ref) is pred.
:- typeof asserta(clause) is pred.
:- typeof asserta(clause,clause_ref) is pred.
:- typeof assertz(clause) is pred.
:- typeof assertz(clause,clause_ref) is pred.
:- typeof clause(pred,goal) is pred.
:- typeof clause(pred,goal,clause_ref) is pred.
:- typeof retract(clause) is pred.
:- typeof retractall(pred) is pred.
:- typeof abolish(functor) is pred.
:- typeof abolish(atom,int) is pred.
:- typeof erase(clause_ref) is pred.
:- typeof instance(clause_ref,clause) is pred.

%% Blackboard Primitives
:- typeof bb_put(atom,term) is pred.
:- typeof bb_put(int,term) is pred.
:- typeof bb_get(atom,term) is pred.
:- typeof bb_get(int,term) is pred.
:- typeof bb_delete(atom,term) is pred.
:- typeof bb_delete(int,term) is pred.
:- typeof bb_update(atom,term,term) is pred.
:- typeof bb_update(int,term,term) is pred.

%% All solutions
:- typeof A^goal is goal.
:- typeof setof(A,goal,list(A)) is pred.
:- typeof bagof(A,goal,list(A)) is pred.
:- typeof findall(A, goal, list(A)) is pred.
:- typeof findall(A, goal, list(A), list(A)) is pred.

%% Message handling predicates
:- typeof print_message(term,term) is pred.
:- typeof portray_message(term,term) is pred.
:- typeof generate_message_hook(term,list(term),list(term)) is pred.
:- typeof message_hook(term,term,list(term)) is pred.
:- typeof print_message_lines(stream,term,list(term)) is pred.
:- type source_info is [ fileref(atom,int),
                         clauseref(atom,functor,int,int,int) ].
:- typeof goal_source_info(goal,goal,source_info) is pred.

%% Query Processing
:- type query_class.
:- typeof ask_query(query_class, goal, term, term) is pred.
:- type query_failure_mode is [ help_query ,
                                help, query, none ].
:- typeof query_class(query_class, atom, term, term, query_failure_mode) is pred. 
:- typeof query_hook(query_class, goal, list(int), term, list(int), term) 
        is pred.
:- typeof query_class_hook(query_class, atom, term, term, query_failure_mode) is pred.
:- typeof query_abbreviation(query_class, atom, list(pair(character,term)))
        is pred.
:- typeof query_input_hook(term,atom,term) is pred.
:- typeof query_input(term,atom,term) is pred.
:- typeof query_map_hook(term,term,term,term) is pred.
:- typeof query_map(term,term,term,term) is pred.

%% Coroutining
:- typeof when(goal,goal) is pred.
:- typeof freeze(term,goal) is pred.
:- typeof frozen(term,goal) is pred.
:- typeof dif(A,A) is pred.
:- typeof call_residue(goal,list(pair(list(A),goal))) is pred.

%% Debugging
%:- type action_on_unknown_predicates is [ trace , fail , warning , error ].
%:- typeof unknown(action_on_unknown_predicates,action_on_unknown_predicates)
%        is pred.
%:- typeof debug is pred.
%:- typeof trace is pred.
%:- typeof zip is pred.
%:- typeof nodebug is pred.
%:- typeof notrace is pred.
%:- typeof nozip is pred.
%:- type leash_mode is [ call , exit , redo , fail , exception ].
%:- typeof leash(leash_mode) is pred.
%:- type breakpoint_condition is 

%:- typeof (spy list(functor)) is pred.
%:- typeof spy(list(functor),goal) is pred.
%:- typeof (nospy list(functor)) is pred.
%:- typeof nospyall is pred.
%:- typeof debugging is pred.
%:- typeof add_breakpoint(

%% Miscellaneous
:- typeof '='(A,A) is pred.
:- typeof \=(A,A) is pred.
:- typeof unify_with_occurs_check(A,A) is pred.
:- typeof length(list(A),int) is pred.
:- typeof numbervars(term,int,int) is pred.
:- typeof undo(goal) is pred.
:- typeof halt is pred.
:- typeof halt(int) is pred.
:- type op_mode is [ fx,fy,xf,yf,xfx,xfy,yfx,yfy ].
:- typeof op(int, op_mode, atom) is pred.
:- typeof op(int, op_mode, list(atom)) is pred.
:- typeof current_op(int, op_mode, atom) is pred.
:- typeof break is pred.
:- typeof abort is pred.
:- typeof save_files(list(atom), atom) is pred.
:- typeof save_files(atom, atom) is pred.
:- typeof save_modules(list(atom), atom) is pred.
:- typeof save_modules(atom, atom) is pred.
:- typeof save_predicates(list(functor),atom) is pred.
:- typeof save_predicates(functor,atom) is pred.
:- typeof save_program(atom) is pred.
:- typeof save_program(atom, goal) is pred.
:- typeof restore(atom) is pred.
:- typeof garbage_collect is pred.
:- typeof garbage_collect_atoms is pred.
:- typeof gc is pred.
:- typeof nogc is pred.
:- typeof prompt(list(int),list(int)) is pred.
:- typeof prompt(atom,atom) is pred.
:- typeof version is pred.
:- typeof version(atom) is pred.
:- typeof help is pred.
:- typeof user_help is pred.

%% Mixing C and Prolog
:- untyped [ foreign_resource/2, foreign/2 , foreign/3 ].
:- typeof load_foreign_resource(filename) is pred.
:- typeof unload_foreign_resource(filename) is pred.
:- typeof stream_code(stream,int) is pred.

%% Modules
:- typeof module(atom,list(functor)) is pred.
:- untyped [ module/2 , use_module/3 , use_module/2 , use_module/1 ].
:- typeof ':'(atom,A) is A.
:- typeof include(filename) is pred.

%% Pairs
:- typeof (A-B) is pair(A,B).

%% Grammars
:- untyped '-->'/2.

