%% trees.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/trees.typ,v 1.3 2003/08/29 15:53:48 manu Exp $

%% types for module trees in Sicstus Prolog

:- type tree(A).
:- typeof gen_label(int, tree(A), A) is pred.
:- typeof get_label(int, tree(A), A) is pred.
:- typeof list_to_tree(list(A), tree(A)) is pred.
:- typeof map_tree(atom, tree(A), tree(A)) is pred.
:- typeof put_label(int, tree(A), A, tree(A)) is pred.
:- typeof put_label(int, tree(A), A, tree(A), A) is pred.
:- typeof tree_size(tree(A), int) is pred.
:- typeof tree_to_list(tree(A), list(A)) is pred.
