%% ugraphs.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/beaune/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/ugraphs.typ,v 1.4 2003/09/08 14:41:35 coquery Exp $

%% types for module ugraphs in Sicstus Prolog

% edge = pair(A,A)
% graph = list(pair(A,list(edge))) = list(pair(A,list(pair(A,A))))

:- typeof vertices_edges_to_ugraph(list(A), list(pair(A, A)), list(pair(A, list(A)))) is pred.
:- typeof vertices(list(pair(A, list(A))), list(A)) is pred.
:- typeof edges(list(pair(A, list(A))), list(pair(A, A))) is pred.
:- typeof add_vertices(list(pair(A, list(A))), list(A), list(pair(A, list(A)))) is pred.
:- typeof del_vertices(list(pair(A, list(A))), list(A), list(pair(A, list(A)))) is pred.
:- typeof add_edges(list(pair(A, list(A))), list(pair(A, A)), list(pair(A, list(A)))) is pred.
:- typeof del_edges(list(pair(A, list(A))), list(pair(A, A)), list(pair(A, list(A)))) is pred.
:- typeof transpose(list(pair(A, list(A))), list(pair(A, list(A)))) is pred.
:- typeof neighbors(A, list(pair(A, B)), B) is pred.
:- typeof neighbours(A, list(pair(A, B)), B) is pred.
:- typeof complement(list(pair(A, list(A))), list(pair(A, list(A)))) is pred.
:- typeof compose(list(pair(A, list(A))), list(pair(A, list(A))), list(pair(A, list(A)))) is pred.
:- typeof transitive_closure(list(pair(A, list(A))), list(pair(A, list(A)))) is pred.
:- typeof symmetric_closure(list(pair(A, list(A))), list(pair(A, list(A)))) is pred.
:- typeof top_sort(list(pair(A, list(A))), list(A)) is pred.
:- typeof max_path(A, A, list(pair(A, list(A))), list(A), int) is pred.
:- typeof min_path(A, A, list(pair(A, list(A))), list(A), int) is pred.
:- typeof min_paths(A, list(pair(A, list(A))), list(pair(A, list(A)))) is pred.
:- typeof path(A, list(pair(A, list(A))), list(A)) is pred.
:- typeof reduce(list(pair(A, list(A))), list(pair(A, list(A)))) is pred.
:- typeof reachable(A, list(pair(A, list(A))), list(A)) is pred.
:- typeof random_ugraph(float, int, list(pair(int, list(int)))) is pred.
:- typeof min_tree(list(pair(A, list(A))), list(pair(A, list(A))), int) is pred.
:- typeof clique(list(pair(A, list(A))), int, list(A)) is pred.
:- typeof independent_set(list(pair(A, list(A))), int, list(A)) is pred.
:- typeof coloring(list(pair(int, list(int))), int, list(pair(int, int))) is pred.
:- typeof colouring(list(pair(int, list(int))), int, list(pair(int, int))) is pred.
