%% corelib.typ
%% this is used to defined the layouts of the clauses and other low level
%% definitions
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                                   TCLP                                    %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/yquem/contraintes/coquery/cvs/contraintes/tclpchr/lib/gprolog/corelib.typ,v 1.2 2004/01/23 14:04:33 coquery Exp $

%% Note that definitions for clauses layout are asserted in first position.
%% This means that the lastest ones are considered before the first ones,
%% which  is the reverse order w.r.t. standard prolog approch.
%% This is intended to allow one to refine later a clause layout definition

%% directives
:- tclp__define_clause((:- Body),Location,[],[Body-BodyLocation],
                       (user:args_location(Location,[BodyLocation]))).

%% standard clauses
:- tclp__define_clause((Head :- Body),Location,
                       HeadDef,[Body-BodyLoc],
                       (
                         user:args_location(Location,[HeadLoc,BodyLoc]),
                         tclp__clause(Head,HeadLoc,HeadDef,[])
                       )).

%% allow the user to add phrase handlers
:- tclp__executable(tclp__add_phrase_handler(_P,_T,_G)).
:- tclp__add_hook(tclp__add_phrase_handler(P,T,G),
                  tclp__handle_goals:tclp__add_phrase_handler(P,T,G)).

%% built-in executable goals

%% since op is already a directive, we just need to say it is executable,
%% in order to parse the file
:- tclp__executable(op(_, _, _)).

%% allow the user to load some prolog definitions for tclp
:- tclp__executable(tclp__load_prolog(_)).
:- tclp__add_hook(tclp__load_prolog(Files),consult(Files)).


%% Handling grammar rules
:- tclp__load_prolog(tclplib('gprolog/grammar_typ.pl')).
:- tclp__add_phrase_handler((Head --> _), TermData,
                            grammar_handler(Head,TermData)).
