%% lib/gprolog/stdlib.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/yquem/contraintes/coquery/cvs/contraintes/tclpchr/lib/gprolog/stdlib.typ,v 1.5 2006/07/17 14:51:28 ecoquery Exp $

%% Standard Library, type definitions for GNU Prolog in TCLP

:- tclp__include('corelib.typ').

%% The type predicates are untyped
:- untyped [ type/1, untyped/1, typeof/1 , order/1 , subtype/1, typealias/1].

%% Necessary types, needed by the type checker
:- type term. %% already defined, added for coherence
:- type int.
:- type float.
:- type atom.
:- type pred. %% predicates
:- type goal.
:- order pred < goal.
:- type character.
:- type in_character.
:- order character < in_character.
:- order in_character < atom.
:- type in_byte.
:- type byte.
:- order in_byte < int.
:- order byte < in_byte.
:- type int_expr.
:- order int < int_expr.
:- type float_expr.
:- order float < float_expr.


%% Usual types
%% for consulting files with ['xxx']
:- typeof [atom|list(atom)] is pred.
:- type list(A) is [ [] , [ A | list(A) ] ].
:- type exception.
:- type true_false is [ true , false ].

%% Predicate properties declarations
:- untyped [dynamic/1,public/1,multifile/1,discontiguous/1,
            ensure_linked/1,built_in/1,built_in_fd/1,ensure_linked/1].
:- typeof built_in is pred.
:- typeof built_in_fd is pred.

%% Loading predicates
:- typeof include(atom) is pred.
:- typeof ensure_loaded(atom) is pred.


%% Prolog options
:- typeof initialization(goal) is pred.
:- typeof foreign(pred) is pred.
:- typeof foreign(pred,list(term)) is pred.

%% Logic and control
:- typeof true is pred.
:- typeof fail is pred.
:- typeof '!' is pred.
:- typeof (goal , goal) is goal.
:- typeof (goal ; goal) is goal.
:- typeof (goal -> goal) is goal.
:- typeof call(goal) is pred.
:- typeof catch(goal,exception,goal) is pred.
:- typeof throw(exception) is pred.
:- typeof abort is pred.
:- typeof stop is pred.
:- typeof top_level is pred.
:- typeof break is pred.
:- typeof halt(int) is pred.
:- typeof halt is pred.
:- typeof once(goal) is pred.
:- typeof (\+ goal) is pred.
:- typeof call_with_args(atom,term) is pred. %% FIXME comment les gnrer tous
:- typeof call(goal,true_false) is pred.
:- typeof repeat is pred.
:- typeof for(int,int,int) is pred.

%% Type testing 
:- typeof var(A) is pred.
:- typeof nonvar(A) is pred.
:- typeof atom(term) is pred.
:- typeof integer(term) is pred.
:- typeof float(term) is pred.
:- typeof number(term) is pred.
:- typeof atomic(term) is pred.
:- typeof compound(term) is pred.
:- typeof callable(term) is pred.
:- typeof list(term) is pred.
:- typeof partial_list(term) is pred.
:- typeof list_or_partial_list(term) is pred.

%% Term unification
:- typeof =(A,A) is pred.
:- typeof unify_with_occurs_check(A,A) is pred.
:- typeof \=(A,A) is pred.

%% Term conmparison
:- typeof ==(A,A) is pred.
:- typeof \==(A,A) is pred.
:- typeof @<(A,A) is pred.
:- typeof @=<(A,A) is pred.
:- typeof @>(A,A) is pred.
:- typeof @>=(A,A) is pred.
:- type compare_result is [ < , = , > ].
:- typeof compare(compare_result,A,A) is pred.

%% Term processing
:- typeof functor(term,atom,int) is pred.
:- typeof arg(int,term,term) is pred.
:- typeof =..(term,list(term)) is pred.
:- typeof copy_term(A,A) is pred.
:- typeof setarg(int,term,term,true_false) is pred.
:- typeof setarg(int,term,term) is pred.

%% Variable naming/numbering
:- typeof name_singleton_vars(term) is pred.
:- typeof name_query_vars(list(term),list(term)) is pred.
:- type variable_binding_option is [ numbervars , namevars , from(int),
                                     next(int), exclude(list(term)) ].
:- typeof bind_variables(term, list(variable_binding_option)) is pred.
:- typeof number_vars(term,int,int) is pred.
:- typeof number_vars(term) is pred.
:- typeof term_ref(term,int) is pred.

%% Arithmetic
:- type float_expr is
        [ +float_expr,
          inc(float_expr), dec(float_expr),
          int_expr+float_expr, float_expr+int_expr, float_expr+float_expr,
          int_expr-float_expr, float_expr-int_expr, float_expr-float_expr,
          int_expr*float_expr, float_expr*int_expr, float_expr*float_expr,
          int_expr/float_expr, float_expr/int_expr, int_expr/int_expr,
          float_expr/float_expr,
          abs(float_expr),
          int_expr**float_expr, float_expr**int_expr, int_expr**int_expr,
          float_expr**float_expr,
          sqrt(int_expr), atan(int_expr), cos(int_expr), sin(int_expr),
          asin(int_expr), exp(int_expr), log(int_expr), float(int_expr),
          sqrt(float_expr), atan(float_expr), cos(float_expr), sin(float_expr),
          asin(float_expr), exp(float_expr), log(float_expr),
          float(float_expr),
          float_fractionnal_part(float_expr), float_integer_part(float_expr)
        ].
:- type int_expr is
        [ +int_expr,
          inc(int_expr), dec(int_expr),
          int_expr+int_expr, int_expr-int_expr,
          int_expr*int_expr, int_expr//int_expr,
          int_expr rem int_expr, int_expr mod int_expr,
          int_expr /\ int_expr, int_expr \/ int_expr,
          int_expr ^ int_expr, \ int_expr,
          int_expr << int_expr, int_expr >> int_expr,
          abs(int_expr),
          ceiling(float_expr), floor(float_expr),
          round(float_expr), truncate(float_expr)
        ].
:- typeof is(float, float_expr) is pred.
:- typeof is(int,int_expr) is pred.
:- typeof =:=(float_expr,int_expr) is pred.
:- typeof =:=(int_expr,float_expr) is pred.
:- typeof =:=(float_expr,float_expr) is pred.
:- typeof =:=(int_expr,int_expr) is pred.
:- typeof =\=(float_expr,int_expr) is pred.
:- typeof =\=(int_expr,float_expr) is pred.
:- typeof =\=(float_expr,float_expr) is pred.
:- typeof =\=(int_expr,int_expr) is pred.
:- typeof <(float_expr,int_expr) is pred.
:- typeof <(int_expr,float_expr) is pred.
:- typeof <(float_expr,float_expr) is pred.
:- typeof <(int_expr,int_expr) is pred.
:- typeof =<(float_expr,int_expr) is pred.
:- typeof =<(int_expr,float_expr) is pred.
:- typeof =<(float_expr,float_expr) is pred.
:- typeof =<(int_expr,int_expr) is pred.
:- typeof >(float_expr,int_expr) is pred.
:- typeof >(int_expr,float_expr) is pred.
:- typeof >(float_expr,float_expr) is pred.
:- typeof >(int_expr,int_expr) is pred.
:- typeof >=(float_expr,int_expr) is pred.
:- typeof >=(int_expr,float_expr) is pred.
:- typeof >=(float_expr,float_expr) is pred.
:- typeof >=(int_expr,int_expr) is pred.

%% Dynamic clause management
:- type clause is [ (pred :- goal) ].
:- order pred < clause.
:- type predicate_indicator is [ atom/int ].
:- typeof asserta(clause) is pred.
:- typeof assertz(clause) is pred.
:- typeof retract(clause) is pred.
:- typeof retractall(pred) is pred.
:- typeof clause(pred,goal) is pred.
:- typeof abolish(predicate_indicator) is pred.

%% Predicate information
:- typeof current_predicate(predicate_indicator) is pred.
:- type predicate_property is [ static, dynamic, private, public,
                                user, built_in, built_in_fd, native_code,
                                prolog_file(atom), prolog_line(int) ].
:- typeof predicate_property(predicate_indicator, predicate_property) is pred.

%% All solutions
:- typeof findall(A,goal,list(A)) is pred.
:- typeof bagof(A,goal,list(A)) is pred.
:- typeof setof(A,goal,list(A)) is pred.
:- typeof A^goal is goal.

%% Streams
:- type stream.
:- type stream_or_alias.
:- order stream < stream_or_alias.
:- order atom < stream_or_alias.
:- type source_sink.
:- order atom < source_sink.
:- typeof current_input(stream) is pred.
:- typeof current_output(stream) is pred.
:- typeof set_input(stream_or_alias) is pred.
:- typeof set_output(stream_or_alias) is pred.
:- type io_mode is [ read, write, append ].
:- type text_binary is [ texte , binary ].
:- type eof_action is [ error, eof_code, reset ].
:- type buffering is [ none , line, block ].
:- type stream_option is [ type(text_binary),
                           reposition(true_false),
                           eof_action(eof_action),
                           alias(atom),
                           mirror(stream_or_alias),
                           buffering(buffering) ].
:- typeof open(source_sink, io_mode, stream, list(stream_option)) is pred.
:- typeof open(source_sink, io_mode, stream) is pred.
:- type close_option is [ force(true_false) ].
:- typeof close(stream_or_alias, list(close_option)) is pred.
:- typeof close(stream_or_alias) is pred.
:- typeof flush_output(stream_or_alias) is pred.
:- typeof flush_output is pred.
:- typeof current_stream(stream) is pred.
:- type stream_position.
:- type end_of_stream is [ not, at, past ].
:- type stream_property is [ file_name(atom),
                             mode(io_mode),
                             input, output,
                             end_of_stream(end_of_stream),
                             position(stream_position) ].
:- order stream_option < stream_property.
:- typeof at_end_of_stream(stream_or_alias) is pred.
:- typeof at_end_of_stream is pred.
:- typeof stream_position(stream_or_alias, stream_position) is pred.
:- typeof set_stream_position(stream_or_alias, stream_position) is pred.
:- type stream_seek_method is [ bof, current, eof ].
:- typeof seek(stream_or_alias, stream_seek_method, int,int) is pred.
:- typeof character_count(stream_or_alias, int) is pred.
:- typeof line_count(stream_or_alias, int) is pred.
:- typeof line_position(stream_or_alias, int) is pred.
:- typeof stream_line_column(stream_or_alias, int, int) is pred.
:- typeof set_stream_line_column(stream_or_alias, int, int) is pred.
:- typeof add_stream_alias(stream_or_alias, atom) is pred.
:- typeof current_alias(stream_or_alias, atom) is pred.
:- typeof add_stream_mirror(stream_or_alias, stream_or_alias) is pred.
:- typeof remove_stream_mirror(stream_or_alias, stream_or_alias) is pred.
:- typeof current_mirror(stream,stream) is pred.
:- typeof set_stream_type(stream_or_alias, text_binary) is pred.
:- typeof set_stream_eof_action(stream_or_alias, eof_action) is pred.
:- typeof set_stream_buffering(stream_or_alias, buffering) is pred.

%% Constant term stream
:- typeof open_input_atom_stream(atom,stream) is pred.
:- typeof open_input_chars_stream(list(character), stream) is pred.
:- typeof open_input_code_stream(list(int), stream) is pred.
:- typeof close_input_atom_stream(stream_or_alias) is pred.
:- typeof close_input_chars_stream(stream_or_alias) is pred.
:- typeof close_input_code_stream(stream_or_alias) is pred.
:- typeof open_output_atom_stream(stream) is pred.
:- typeof open_output_chars_stream(stream) is pred.
:- typeof open_output_code_stream(stream) is pred.
:- typeof close_output_atom_stream(stream_or_alias,atom) is pred.
:- typeof close_output_chars_stream(stream_or_alias,list(character)) is pred.
:- typeof close_output_code_stream(stream_or_alias,list(int)) is pred.

%% Character input/output
:- typeof get_char(stream_or_alias, in_character) is pred.
:- typeof get_char(in_character) is pred.
:- typeof get_code(stream_or_alias, int) is pred.
:- typeof get_code(int) is pred.
:- typeof get_key(stream_or_alias, int) is pred.
:- typeof get_key(int) is pred.
:- typeof get_key_no_echo(stream_or_alias, int) is pred.
:- typeof get_key_no_echo(int) is pred.
:- typeof peek_char(stream_or_alias, in_character) is pred.
:- typeof peek_char(in_character) is pred.
:- typeof peek_code(stream_or_alias, int) is pred.
:- typeof peek_code(int) is pred.
:- typeof unget_char(stream_or_alias, character) is pred.
:- typeof unget_char(character) is pred.
:- typeof unget_code(stream_or_alias, int) is pred.
:- typeof unget_code(int) is pred.
:- typeof put_char(stream_or_alias, character) is pred.
:- typeof put_char(character) is pred.
:- typeof put_code(stream_or_alias, int) is pred.
:- typeof put_code(int) is pred.
:- typeof nl(stream_or_alias) is pred.
:- typeof nl is pred.

%% byte input/ouput
:- typeof get_byte(stream_or_alias, in_byte) is pred.
:- typeof get_byte(in_byte) is pred.
:- typeof peek_byte(stream_or_alias, in_byte) is pred.
:- typeof peek_byte(in_byte) is pred.
:- typeof unget_byte(stream_or_alias, byte) is pred.
:- typeof unget_byte(byte) is pred.
:- typeof put_byte(stream_or_alias, byte) is pred.
:- typeof put_byte(byte) is pred.

%% Term input/output
:- type syntax_error_action is [ error, warning,fail ].
:- type end_of_term_delimiter is [ dot , eof ].
:- type read_option is [ variables(list(term)) ,
                         variable_names(list(term)),
                         singletons(list(term)),
                         syntax_error(syntax_error_action),
                         end_of_term(end_of_term_delimiter)
                       ].
:- typeof read_term(stream_or_alias, term, list(read_option)) is pred.
:- typeof read_term(term, list(read_option)) is pred.
:- typeof read(stream_or_alias, term) is pred.
:- typeof read(term) is pred.
:- typeof read_atom(stream_or_alias,atom) is pred.
:- typeof read_atom(atom) is pred.
:- typeof read_integer(stream_or_alias, int) is pred.
:- typeof read_integer(int) is pred.
:- typeof read_number(stream_or_alias, float) is pred.
:- typeof read_number(float) is pred.
:- typeof read_number(stream_or_alias, int) is pred.
:- typeof read_number(int) is pred.
:- typeof read_token(stream_or_alias, term) is pred.
:- typeof read_token(term) is pred.
:- typeof syntax_error_info(atom,int,int,atom) is pred.
:- typeof last_read_start_line_column(int,int) is pred.
:- type write_option is [ quoted(true_false),
                          ignore_ops(true_false),
                          numbervars(true_false),
                          namevars(true_false),
                          space_args(true_false),
                          portrayed(true_false),
                          max_depth(int),
                          priority(int)
                        ].
:- typeof write_term(stream_or_alias, term, list(write_option)) is pred.
:- typeof write_term(term, list(write_option)) is pred.
:- typeof write(stream_or_alias, term) is pred.
:- typeof write(term) is pred.
:- typeof writeq(stream_or_alias, term) is pred.
:- typeof writeq(term) is pred.
:- typeof write_canonical(stream_or_alias, term) is pred.
:- typeof write_canonical(term) is pred.
:- typeof display(stream_or_alias, term) is pred.
:- typeof display(term) is pred.
:- typeof print(stream_or_alias, term) is pred.
:- typeof print(term) is pred.
:- typeof format(stream_or_alias, list(int), list(term)) is pred.
:- typeof format(stream_or_alias, atom, list(term)) is pred.
:- typeof format(list(int), list(term)) is pred.
:- typeof format(atom, list(term)) is pred.
:- typeof portray_clause(stream_or_alias, clause) is pred.
:- typeof portray_clause(clause) is pred.
:- typeof get_print_stream(stream) is pred.
:- type op_specifier is [ fx , fy , xfx, xfy, yfx, xf, yf ].
:- typeof op(int,op_specifier, atom) is pred.
:- typeof op(int,op_specifier, list(atom)) is pred.
%% FIXME change op table to reflect gnu syntax ?
:- typeof current_op(int,op_specifier, atom) is pred.
:- typeof char_conversion(character,character) is pred.
:- typeof current_char_conversion(character,character) is pred.

%% Input/output from/to constant terms
:- typeof read_term_from_atom(atom, term, list(read_option)) is pred.
:- typeof read_from_atom(atom, term) is pred.
:- typeof read_token_from_atom(atom, term) is pred.

:- typeof read_term_from_chars(list(character), term, list(read_option)) is pred.
:- typeof read_from_chars(list(character), term) is pred.
:- typeof read_token_from_chars(list(character), term) is pred.

:- typeof read_term_from_codes(list(int), term, list(read_option)) is pred.
:- typeof read_from_codes(list(int), term) is pred.
:- typeof read_token_from_codes(list(int), term) is pred.

:- typeof write_term_to_atom(atom, term, list(write_option)) is pred.
:- typeof write_to_atom(atom, term) is pred.
:- typeof writeq_to_atom(atom, term) is pred.
:- typeof write_canonical_to_atom(atom, term) is pred.
:- typeof display_to_atom(atom, term) is pred.
:- typeof print_to_atom(atom, term) is pred.
:- typeof format_to_atom(atom, list(int), list(term)) is pred.
:- typeof format_to_atom(atom, atom, list(term)) is pred.

:- typeof write_term_to_chars(list(character), term, list(write_option)) is pred.
:- typeof write_to_chars(list(character), term) is pred.
:- typeof writeq_to_chars(list(character), term) is pred.
:- typeof write_canonical_to_chars(list(character), term) is pred.
:- typeof display_to_chars(list(character), term) is pred.
:- typeof print_to_chars(list(character), term) is pred.
:- typeof format_to_chars(list(character), list(int), list(term)) is pred.
:- typeof format_to_chars(list(character), atom, list(term)) is pred.

:- typeof write_term_to_codes(list(int), term, list(write_option)) is pred.
:- typeof write_to_codes(list(int), term) is pred.
:- typeof writeq_to_codes(list(int), term) is pred.
:- typeof write_canonical_to_codes(list(int), term) is pred.
:- typeof display_to_codes(list(int), term) is pred.
:- typeof print_to_codes(list(int), term) is pred.
:- typeof format_to_codes(list(int), list(int), list(term)) is pred.
:- typeof format_to_codes(list(int), atom, list(term)) is pred.

%% DEC-10 compatibility input/output
:- typeof see(source_sink) is pred.
:- typeof see(stream) is pred.
:- typeof tell(source_sink) is pred.
:- typeof tell(stream) is pred.
:- typeof append(source_sink) is pred.
:- typeof append(stream) is pred.
:- typeof seeing(source_sink) is pred.
:- typeof telling(source_sink) is pred.
:- typeof seen is pred.
:- typeof told is pred.
:- typeof get0(int) is pred.
:- typeof get(int) is pred.
:- typeof skip(int) is pred.
:- typeof put(int) is pred.
:- typeof tab(int_expr) is pred.

%% Term expansion
:- typeof expand_term(term,term) is pred.
:- typeof term_expansion(term,term) is pred.
:- typeof phrase(term, list(term), list(term)) is pred.
:- typeof phrase(term,list(term)) is pred.

%% Atomic term processing
:- typeof atom_length(atom, int) is pred.
:- typeof atom_concat(atom,atom,atom) is pred.
:- typeof sub_atom(atom,int,int,int,atom) is pred.
:- typeof char_code(character,int) is pred.
:- typeof lower_upper(character,character) is pred.
:- typeof atom_chars(atom,list(character)) is pred.
:- typeof atom_codes(atom,list(int)) is pred.
:- typeof number_atom(float, atom) is pred.
:- typeof number_atom(int, atom) is pred.
:- typeof number_chars(float, list(character)) is pred.
:- typeof number_chars(int, list(character)) is pred.
:- typeof number_codes(float, list(int)) is pred.
:- typeof number_codes(int, list(int)) is pred.
:- typeof name(term,list(int)) is pred.
:- typeof atom_hash(atom,int) is pred.
:- typeof new_atom(atom,int,atom) is pred.
:- typeof new_atom(atom,atom) is pred.
:- typeof new_atom(atom) is pred.
:- typeof current_atom(atom) is pred.
:- type atom_property is [ length(int),
                           hash(int),
                           prefix_op, infix_op, postfix_op,
                           needs_quotes, needs_scan
                         ].
:- typeof atom_property(atom, atom_property) is pred.

%% List processing
:- typeof append(list(A),list(A),list(A)) is pred.
:- typeof member(A,list(A)) is pred.
:- typeof memberchk(A,list(A)) is pred.
:- typeof reverse(list(A),list(A)) is pred.
:- typeof delete(list(A),A,list(A)) is pred.
:- typeof select(A,list(A),list(A)) is pred.
:- typeof permutation(list(A),list(A)) is pred.
:- typeof prefix(list(A),list(A)) is pred.
:- typeof suffix(list(A),list(A)) is pred.
:- typeof sublist(list(A),list(A)) is pred.
:- typeof last(list(A),A) is pred.
:- typeof length(list(A),int) is pred.
:- typeof nth(int,list(A),A) is pred.
:- typeof min_list(list(A),float) is pred.
:- typeof min_list(list(A),int) is pred.
:- typeof max_list(list(A),float) is pred.
:- typeof max_list(list(A),int) is pred.
:- typeof sum_list(list(A),float) is pred.
:- typeof sum_list(list(A),int) is pred.
:- typeof sort(list(A),list(A)) is pred.
:- typeof sort0(list(A),list(A)) is pred.
:- typeof keysort(list(pair(A,B)),list(pair(A,B))) is pred.
:- typeof sort(list(A)) is pred.
:- typeof sort0(list(A)) is pred.
:- typeof keysort(list(pair(A,B))) is pred.

%% Global variables
:- typeof (term-term) is term.
:- typeof g_assign(term,term) is pred.
:- typeof g_assignb(term,term) is pred.
:- typeof g_link(term,term) is pred.
:- typeof g_read(term,term) is pred.
:- typeof g_array_size(term,int) is pred.
:- typeof g_inc(term,int,int) is pred.
:- typeof g_inc(term,int) is pred.
:- typeof g_inco(term,int) is pred.
:- typeof g_inc(term) is pred.
:- typeof g_dec(term,int,int) is pred.
:- typeof g_dec(term,int) is pred.
:- typeof g_deco(term,int) is pred.
:- typeof g_dec(term) is pred.
:- typeof g_set_bit(term,int) is pred.
:- typeof g_reset_bit(term,int) is pred.
:- typeof g_test_set_bit(term,int) is pred.
:- typeof g_test_reset_bit(term,int) is pred.

%% Prolog state
:- typeof set_prolog_flag(term,term) is pred.
:- typeof current_prolog_flag(term,term) is pred.
:- typeof set_bip_name(atom,int) is pred.
:- typeof current_bip_name(atom,int) is pred.
:- typeof write_pl_state_file(source_sink) is pred.
:- typeof read_pl_state_file(source_sink) is pred.

%% Program state
:- typeof consult(atom) is pred.
:- typeof consult(list(atom)) is pred.
:- typeof load(atom) is pred.
:- typeof load(list(atom)) is pred.
:- typeof listing is pred.
:- typeof listing(predicate_indicator) is pred.
:- typeof listing(atom) is pred.

%% System statistics
:- typeof statistics is pred.
:- typeof statistics(atom,list(int)) is pred.
:- typeof user_time(int) is pred.
:- typeof system_time(int) is pred.
:- typeof cpu_time(int) is pred.
:- typeof real_time(int) is pred.

%% Random number generation
:- typeof set_seed(int) is pred.
:- typeof randomize is pred.
:- typeof get_seed(int) is pred.
:- typeof random(float) is pred.
:- typeof random(float,int,float) is pred.
:- typeof random(int,float,float) is pred.
:- typeof random(float,float,float) is pred.
:- typeof random(int,int,int) is pred.

%% File name processing
:- typeof absolute_file_name(atom,atom) is pred.
:- typeof decompose_file_name(atom,atom,atom,atom) is pred.
:- typeof prolog_file_name(atom,atom) is pred.
:- typeof argument_counter(int) is pred.
:- typeof argument_value(int,atom) is pred.
:- typeof argument_list(list(atom)) is pred.
:- typeof environ(atom,atom) is pred.
:- typeof make_directory(atom) is pred.
:- typeof delete_directory(atom) is pred.
:- typeof change_directory(atom) is pred.
:- typeof working_directory(atom) is pred.
:- typeof directory_files(atom,list(atom)) is pred.
:- typeof rename_file(atom,atom) is pred.
:- typeof delete_file(atom) is pred.
:- typeof unlink(atom) is pred.
:- type file_permission is [ read,write,execute,search ].
:- typeof file_permission(atom,file_permission) is pred.
:- typeof file_permission(atom,list(file_permission)) is pred.
:- typeof file_exists(atom) is pred.
:- type date_time is [ dt(int,int,int,int,int,int) ].
:- type file_type is [ regular, directory, fifo, socket, character_device,
                       block_device, unknown ].
:- type os_file_property is [ absolute_file_name(atom),
                              real_file_name(atom),
                              type(file_type),
                              size(int),
                              permission(file_permission),
                              last_modification(date_time) ].
:- typeof file_property(atom,os_file_property) is pred.
:- typeof temporary_file_name(atom, atom) is pred.
:- typeof temporary_file(atom,atom,atom) is pred.
:- typeof date_time(date_time) is pred.
:- typeof host_name(atom) is pred.
:- typeof os_version(atom) is pred.
:- typeof architecture(atom) is pred.
:- typeof shell(atom,int) is pred.
:- typeof shell(atom) is pred.
:- typeof shell is pred.
:- typeof system(atom,int) is pred.
:- typeof system(atom) is pred.
:- typeof spawn(atom, list(atom), int) is pred.
:- typeof spawn(atom, list(atom)) is pred.
:- typeof popen(atom, io_mode, stream) is pred.
:- typeof exec(atom, stream, stream, stream, int) is pred.
:- typeof exec(atom, stream, stream, stream) is pred.
:- typeof wait(int,int) is pred.
:- typeof send_signal(int,int) is pred.
:- typeof send_signal(int,atom) is pred.
:- typeof sleep(int) is pred.
:- typeof select(list(stream), list(stream), list(stream), list(stream), int) is pred.

%% Sockets input/output
:- type socket_domain is [ 'AF_INET' , 'AF_UNIX' ].
:- type socket_address is [ 'AF_INET'(atom,int) , 'AF_UNIX'(atom) ].
:- typeof socket(socket_domain, int) is pred.
:- typeof socket_close(int) is pred.
:- typeof socket_bind(int, socket_address) is pred.
:- typeof socket_connect(int, socket_address, stream, stream) is pred.
:- typeof socket_listen(int,int) is pred.
:- typeof socket_accept(int, atom, stream, stream) is pred.
:- typeof socket_accept(int,stream, stream) is pred.
:- typeof hostname_address(atom,atom) is pred.

%% Linedit management
:- typeof get_linedit_prompt(atom) is pred.
:- typeof set_linedit_prompt(atom) is pred.
:- typeof add_linedit_completion(atom) is pred.
:- typeof find_linedit_completion(atom,atom) is pred.

%% FD predicates
:- type boolean is [ 0, 1 ].
:- order boolean < byte.
:- typeof fd_max_integer(int) is pred.
:- typeof fd_vector_max(int) is pred.
:- typeof fd_set_vector_max(int) is pred.
:- typeof fd_domain(list(int),int,int) is pred.
:- typeof fd_domain(int,int,int) is pred.
:- typeof fd_domain_bool(boolean) is pred.
:- typeof fd_domain_bool(list(boolean)) is pred.
:- typeof fd_domain(list(int),list(int)) is pred.
:- typeof fd_domain(int, list(int)) is pred.
:- typeof fd_var(term) is pred.
:- typeof non_fd_var(term) is pred.
:- typeof generic_var(A) is pred.
:- typeof non_generic_var(A) is pred.
:- typeof fd_min(int,int) is pred.
:- typeof fd_max(int,int) is pred.
:- typeof fd_size(int,int) is pred.
:- typeof fd_dom(int,list(int)) is pred.
:- typeof fd_has_extra_cstr(int) is pred.
:- typeof fd_has_vector(int) is pred.
:- typeof fd_use_vector(int) is pred.
:- type fd_expr is [ (+ fd_expr),
                     (- fd_expr),
                     fd_expr+fd_expr, fd_expr-fd_expr,
                     fd_expr*fd_expr, fd_expr/fd_expr,
                     fd_expr**fd_expr,
                     min(fd_expr,fd_expr),
                     max(fd_expr,fd_expr),
                     dist(fd_expr,fd_expr),
                     fd_expr//fd_expr,
                     fd_expr rem fd_expr,
                     quot_rem(fd_expr,fd_expr,fd_expr)
                   ].
:- order int < fd_expr.
:- type reified_constr.
:- order reified_constr < pred.
:- typeof #=(fd_expr, fd_expr) is reified_constr.
:- typeof #\=(fd_expr, fd_expr) is reified_constr.
:- typeof #<(fd_expr, fd_expr) is reified_constr.
:- typeof #=<(fd_expr, fd_expr) is reified_constr.
:- typeof #>(fd_expr, fd_expr) is reified_constr.
:- typeof #>=(fd_expr, fd_expr) is reified_constr.
:- typeof #=#(fd_expr, fd_expr) is reified_constr.
:- typeof #\=#(fd_expr, fd_expr) is reified_constr.
:- typeof #<#(fd_expr, fd_expr) is reified_constr.
:- typeof #=<#(fd_expr, fd_expr) is reified_constr.
:- typeof #>#(fd_expr, fd_expr) is reified_constr.
:- typeof #>=#(fd_expr, fd_expr) is reified_constr.
:- typeof fd_prime(int) is pred.
:- typeof fd_not_prime(int) is pred.

:- type boolean_fd_expr.
:- order boolean < boolean_fd_expr.
:- order reified_constr < boolean_fd_expr.
:- typeof #\(boolean_fd_expr) is reified_constr.
:- typeof #<=>(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof #\<=>(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof ##(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof #==>(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof #\==>(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof #/\(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof #\/\(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof #\/(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof #\\/(boolean_fd_expr, boolean_fd_expr) is reified_constr.
:- typeof fd_cardinality(list(boolean), int) is pred.
:- typeof fd_cardinality(int, int, int) is pred.
:- typeof fd_at_least_one(list(boolean_fd_expr)) is pred.
:- typeof fd_at_most_one(list(boolean_fd_expr)) is pred.
:- typeof fd_only_one(list(boolean_fd_expr)) is pred.

:- typeof fd_all_different(list(int)) is pred.

:- typeof fd_element(int, list(int), int) is pred.
:- typeof fd_element_var(int,list(int),int) is pred.

:- typeof fd_atmost(int, list(int), int) is pred.
:- typeof fd_atleast(int, list(int), int) is pred.
:- typeof fd_exactly(int, list(int), int) is pred.

:- typeof fd_relation(list(list(int)), list(int)) is pred.
:- typeof fd_relationc(list(list(int)), list(int)) is pred.

:- type variable_method is [ first_fail,ff,
                             most_constrained,
                             smallest,
                             largest,
                             max_regret,
                             random
                           ].
:- type value_method is [ min, max, middle, bounds, random ].
:- type fd_labeling_option is [ variable_method(variable_method),
                                reorder(true_false),
                                value_method(value_method),
                                backtracks(int)
                              ].
:- typeof fd_labeling(list(int), list(fd_labeling_option)) is pred.
:- typeof fd_labeling(int, list(fd_labeling_option)) is pred.
:- typeof fd_labeling(list(int)) is pred.
:- typeof fd_labeling(int) is pred.
:- typeof fd_labelingff(list(int)) is pred.
:- typeof fd_labelingff(int) is pred.

:- typeof fd_minimize(goal,int) is pred.
:- typeof fd_maximize(goal,int) is pred.

%% Other data structures
:- type pair(A,B) is [ (A - B) ].
:- typeof type_error(term, term) is exception.
:- typeof error(exception, term) is exception.
:- typeof '$VARNAME'(atom) is term.

%% Grammars
:- untyped '-->'/2.

