%% lib/ISO/stdlib.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/yquem/contraintes/coquery/cvs/contraintes/tclpchr/lib/iso.old/stdlib.typ,v 1.10 2003/12/19 13:23:17 coquery Exp $

%% Standard Library, type definitions for ISO Prolog in TCLP

:- tclp__include('corelib.typ').

%% The type predicates are untyped
:- untyped [ type/1, untyped/1, typeof/1 , order/1 , subtype/1].

%% Necessary types, needed by the type checker
:- type term. %% already defined, added for coherence
:- type int.
:- type float.
:- type atom.
:- type pred. %% predicates
:- type goal.
:- order pred < goal.
:- type character.
:- type in_character.
:- order character < in_character.
:- order in_character < atom.
:- type in_byte.
:- type byte.
:- order in_byte < int.
:- order byte < in_byte.
:- type int_expr.
:- order int < int_expr.
:- type float_expr.
:- order float < float_expr.


%% Usual types
:- type list(A) is [ [] , [ A | list(A) ] ].
:- type exception.
:- type true_false is [ true , false ].

%% Logic and Control 
:- typeof true is pred.
:- typeof fail is pred.
:- typeof call(goal) is pred.
:- typeof ! is pred.
:- typeof (goal,goal) is goal.
:- typeof (goal;goal) is goal.
:- typeof (goal -> goal) is goal.
:- typeof catch(goal,exception,goal) is pred.
:- typeof throw(exception) is pred.
:- typeof (\+ goal) is pred.
:- typeof once(goal) is pred.
:- typeof repeat is pred.


%% Prolog unification
:- typeof (A = A) is pred.
:- typeof unify_with_occurs_check(A,A) is pred.
:- typeof (A \= A) is pred.

%% Dynamic type testing
:- typeof var(term) is pred.
:- typeof atom(term) is pred.
:- typeof integer(term) is pred.
:- typeof float(term) is pred.
:- typeof atomic(term) is pred.
:- typeof compound(term) is pred.
:- typeof nonvar(term) is pred.
:- typeof number(term) is pred.

%% term comparison
:- typeof (A @=< A) is pred.
:- typeof (A == A) is pred.
:- typeof (A \== A) is pred.
:- typeof (A @< A) is pred.
:- typeof (A @> A) is pred.
:- typeof (A @>= A) is pred.

%% term creation and decomposition
:- typeof functor(term,atom,int) is pred.
:- typeof arg(int,term,term) is pred.
:- typeof ( term =.. list(term) ) is pred.
:- typeof copy_term(A,B) is pred.

%% Arithmetic expressions
% predicates
:- typeof (float is float_expr) is pred.
:- typeof (int is int_expr) is pred.
:- typeof (float_expr =:= int_expr) is pred.
:- typeof (int_expr =:= float_expr) is pred.
:- typeof (float_expr =:= float_expr) is pred.
:- typeof (int_expr =:= int_expr) is pred.
:- typeof (float_expr =\= int_expr) is pred.
:- typeof (int_expr =\= float_expr) is pred.
:- typeof (float_expr =\= float_expr) is pred.
:- typeof (int_expr =\= int_expr) is pred.
:- typeof (float_expr < int_expr) is pred.
:- typeof (int_expr < float_expr) is pred.
:- typeof (float_expr < float_expr) is pred.
:- typeof (int_expr < int_expr) is pred.
:- typeof (float_expr =< int_expr) is pred.
:- typeof (int_expr =< float_expr) is pred.
:- typeof (float_expr =< float_expr) is pred.
:- typeof (int_expr =< int_expr) is pred.
:- typeof (float_expr > int_expr) is pred.
:- typeof (int_expr > float_expr) is pred.
:- typeof (float_expr > float_expr) is pred.
:- typeof (int_expr > int_expr) is pred.
:- typeof (float_expr >= int_expr) is pred.
:- typeof (int_expr >= float_expr) is pred.
:- typeof (float_expr >= float_expr) is pred.
:- typeof (int_expr >= int_expr) is pred.
% standard evaluable functors
:- typeof (float_expr + int_expr) is float_expr.
:- typeof (int_expr + float_expr) is float_expr.
:- typeof (float_expr + float_expr) is float_expr.
:- typeof (int_expr + int_expr) is int_expr.
:- typeof (float_expr - int_expr) is float_expr.
:- typeof (int_expr - float_expr) is float_expr.
:- typeof (float_expr - float_expr) is float_expr.
:- typeof (int_expr - int_expr) is int_expr.
:- typeof (float_expr * int_expr) is float_expr.
:- typeof (int_expr * float_expr) is float_expr.
:- typeof (float_expr * float_expr) is float_expr.
:- typeof (int_expr * int_expr) is int_expr.
:- typeof (int_expr // int_expr) is int_expr.
:- typeof (float_expr / int_expr) is float_expr.
:- typeof (int_expr / float_expr) is float_expr.
:- typeof (float_expr / float_expr) is float_expr.
:- typeof (int_expr / int_expr) is float_expr.
:- typeof rem(int_expr,int_expr) is int_expr.
:- typeof mod(int_expr,int_expr) is int_expr.
:- typeof (-float_expr) is float_expr.
:- typeof (-int_expr) is int_expr.
:- typeof abs(float_expr) is float_expr.
:- typeof abs(int_expr) is int_expr.
:- typeof sign(float_expr) is float_expr.
:- typeof sign(int_expr) is int_expr.
:- typeof float_integer_part(float_expr) is float_expr.
:- typeof float_fractional_part(float_expr) is float_expr.
:- typeof float(int_expr) is float_expr.
:- typeof float(float_expr) is float_expr.
:- typeof floor(float_expr) is int_expr.
:- typeof truncate(float_expr) is int_expr.
:- typeof round(float_expr) is int_expr.
:- typeof ceiling(float_expr) is int_expr.
% other evaluable functors
:- typeof (float_expr ** int_expr) is float_expr.
:- typeof (int_expr ** float_expr) is float_expr.
:- typeof (float_expr ** float_expr) is float_expr.
:- typeof (int_expr ** int_expr) is float_expr.
:- typeof sin(float_expr) is float_expr.
:- typeof sin(int_expr) is float_expr.
:- typeof cos(float_expr) is float_expr.
:- typeof cos(int_expr) is float_expr.
:- typeof atan(float_expr) is float_expr.
:- typeof atan(int_expr) is float_expr.
:- typeof exp(float_expr) is float_expr.
:- typeof exp(int_expr) is float_expr.
:- typeof log(float_expr) is float_expr.
:- typeof log(int_expr) is float_expr.
:- typeof sqrt(float_expr) is float_expr.
:- typeof sqrt(int_expr) is float_expr.
% bitwise evaluable functors
:- typeof (int_expr >> int_expr) is int_expr.
:- typeof (int_expr << int_expr) is int_expr.
:- typeof (int_expr /\ int_expr) is int_expr.
:- typeof (int_expr \/ int_expr) is int_expr.
:- typeof (\ int_expr) is int_expr.


%% Clause retrivial and information
:- type functor is [ atom/int ].
:- typeof clause(pred,goal) is pred.
:- typeof current_predicate(functor) is pred.
:- type clause is [ (pred :- goal) ].
:- order pred < clause.
:- typeof asserta(clause) is pred.
:- typeof assertz(clause) is pred.
:- typeof retract(clause) is pred.
:- typeof abolish(functor) is pred.

%% All solutions
:- typeof findall(A, goal, list(A)) is pred.
:- typeof bagof(A, goal, list(A)) is pred.
:- typeof setof(A, goal, list(A)) is pred.


%% Inputs / Ouputs
% Streams
:- type stream.
:- type stream_or_alias.
:- order stream < stream_or_alias.
:- order atom < stream_or_alias.
:- type io_mode is [ read , write , append ].
:- type stream_type is [ binary , text ].
:- type eof_option is [ error , eof_code, reset ].
:- type open_option is [ type(stream_type),
                         reposition(true_false),
                         alias(atom),
                         eof_action(eof_option) ].
:- type close_option is [ force(true_false) ].
:- type stream_position.
:- type end_of_stream_value is [ at , not ].
:- type stream_property is [ file_name(atom),
                             mode(io_mode),
                             input,
                             output,
                             position(stream_position),
                             end_of_stream(end_of_stream_value)
                           ].
:- order open_option < stream_property.
% Terms
:- type variable_name is [ (term = atom) ].
:- type read_option is [ variables(list(term)),
                         variable_names(list(variable_name)),
                         singletons(list(variable_name)) ].
:- type write_option is [ quoted(true_false),
                          ignore_ops(true_false),
                          numbervars(true_false) ].
:- type source_sink.
:- order atom < source_sink. % files names are sources/sinks
% selection and control predicates
:- typeof current_input(stream) is pred.
:- typeof current_output(stream) is pred.
:- typeof set_input(stream_or_alias) is pred.
:- typeof set_output(stream_or_alias) is pred.
:- typeof open(source_sink, io_mode, stream) is pred.
:- typeof open(source_sink, io_mode, stream, list(open_option)) is pred.
:- typeof close(stream_or_alias) is pred.
:- typeof close(stream_or_alias, list(close_option)) is pred.
:- typeof flush_output is pred.
:- typeof flush_output(stream_or_alias) is pred.
:- typeof stream_property(stream, stream_property) is pred.
:- typeof at_end_of_stream is pred.
:- typeof at_end_of_stream(stream_or_alias) is pred.
:- typeof set_stream_position(stream_or_alias, stream_position) is pred.
% character input/output
:- typeof end_of_file is in_character.
:- typeof get_char(stream_or_alias, in_character) is pred.
:- typeof get_char(in_character) is pred.
:- typeof get_code(stream_or_alias, int) is pred.
:- typeof get_code(int) is pred.
:- typeof peek_char(stream_or_alias, in_character) is pred.
:- typeof peek_char(in_character) is pred.
:- typeof peek_code(stream_or_alias, int) is pred.
:- typeof peek_code(int) is pred.
:- typeof put_char(stream_or_alias, character) is pred.
:- typeof put_char(character) is pred.
:- typeof put_code(stream_or_alias, int) is pred.
:- typeof put_code(int) is pred.
:- typeof nl(stream_or_alias) is pred.
:- typeof nl is pred.
:- typeof get_byte(stream_or_alias, in_byte) is pred.
:- typeof get_byte(in_byte) is pred.
:- typeof peek_byte(stream_or_alias, in_byte) is pred.
:- typeof peek_byte(in_byte) is pred.
:- typeof put_byte(stream_or_alias, byte) is pred.
:- typeof put_byte(byte) is pred.
% term input/output
:- typeof read_term(stream_or_alias, term, list(read_option)) is pred.
:- typeof read_term(term, list(read_option)) is pred.
:- typeof read(stream_or_alias, term) is pred.
:- typeof read(term) is pred.
:- typeof write_term(stream_or_alias,term,list(write_option)) is pred.
:- typeof write_term(term,list(write_option)) is pred.
:- typeof write(stream_or_alias,term) is pred.
:- typeof write(term) is pred.
:- typeof writeq(term) is pred.
:- typeof writeq(stream_or_alias,term) is pred.
:- typeof write_canonical(term) is pred.
:- typeof write_canonical(stream_or_alias,term) is pred.
:- type op_specifier is [ fx , fy , xfx, xfy, yfx, xf, yf ].
:- typeof op(int,op_specifier, atom) is pred.
:- typeof op(int,op_specifier, list(atom)) is pred.
:- typeof current_op(int,op_specifier,atom) is pred.
:- typeof char_conversion(character, character) is pred.
:- typeof current_char_conversion(character,character) is pred.

%% Atomic term processing
:- typeof atom_length(atom,int) is pred.
:- typeof atom_concat(atom,atom,atom) is pred.
:- typeof sub_atom(atom,int,int,int,atom) is pred.
:- typeof atom_chars(atom,list(character)) is pred.
:- typeof atom_codes(atom,list(int)) is pred.
:- typeof char_code(character,int) is pred.
:- typeof number_chars(float,list(character)) is pred.
:- typeof number_chars(int,list(character)) is pred.

%% Implementation defined hooks : flags
:- type flag is [ bounded , min_integer , max_integer ,
                  integer_rounding_function ,
                  char_conversion ,
                  debug ,
                  max_arity ,
                  unknown ,
                  double_quotes ].
:- typeof set_prolog_flag(flag,term) is pred.
:- typeof current_prolog_flag(flag,term) is pred.
:- typeof halt is pred.
:- typeof halt(int) is pred.


%% Errors
:- type type_error_term is [ atom ,
                             atomic ,
                             byte ,
                             callable ,
                             character ,
                             compound ,
                             evaluable ,
                             in_byte ,
                             in_character ,
                             integer ,
                             list ,
                             number ,
                             predicate_indicator ,
                             variable ].
:- type domain_error is [ character_code_list ,
                          close_option ,
                          io_mode ,
                          non_empty_list ,
                          not_less_than_zero ,
                          operator_priority ,
                          operator_specifier ,
                          prolog_flag ,
                          read_option ,
                          source_sink ,
                          stream ,
                          stream_option ,
                          stream_or_alias ,
                          stream_position ,
                          stream_property ,
                          write_option ].
:- type existence_error_term is [ procedure ,
                                  source_sink,
                                  stream ].
:- type operation_term is [ access ,
                            create ,
                            input ,
                            modify ,
                            open ,
                            output ,
                            reposition ].
:- type permission_type_term is [ binary_stream,
                                  flag,
                                  operator,
                                  past_end_of_stream,
                                  private_procedure,
                                  static_procedure,
                                  source_sink,
                                  stream,
                                  text_stream ].
:- type representation_error_flag is [ character,
                                       character_code,
                                       in_character_code,
                                       max_arity,
                                       max_integer,
                                       min_integer ].
:- type evaluation_error_flag is [ float_overflow ,
                                   int_overflow,
                                   undefined,
                                   underflow,
                                   zero_divisor ].
:- type error_term is [ instanciation_error ,
                        type_error(type_error_term,term) ,
                        domain_error(term,term) ,
                        existence_error(existence_error_term,term) ,
                        permission_error(operation_term,
                                         permission_type_term, term),
                        representation_error(representation_error_flag),
                        evaluation_error(evaluation_error_flag) ].
:- typeof error(error_term,term) is exception.

%% Other data structures
:- type pair(A,B) is [ (A - B) ].
