%% bdb.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/yquem/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/bdb.typ,v 1.5 2003/09/08 12:46:49 coquery Exp $

:- tclp__include('prolog.typ').

%% types for bdb Sicstus Module

:- type dbmode is [ update , enumerate , read , '-' ].
:- type dbenvref is [ none ].
:- type dbref is [ none ].
:- type dbtermref.
:- order clause_ref < dbtermref.
:- type dbspec is [ + , - ].
:- type dbit.
:- type dboption is [ environment(dbenvref) , cache_size(int) ].
%:- order int < dbenvref.
%:- order dbenvref < dboption.


:- typeof db_open_env(atom, dbenvref) is pred.
:- typeof db_open_env(atom, int, dbenvref) is pred.
:- typeof db_close_env(dbenvref) is pred.
:- typeof db_current_env(atom, dbenvref) is pred.
:- typeof db_open(atom, dbmode, list(dbspec), list(dboption), dbref) is pred.
:- typeof db_open(atom, dbmode, list(dbspec), dbref) is pred.
:- typeof db_close(dbref) is pred.
:- typeof db_current(atom, dbmode, list(dbspec), dbenvref, dbref) is pred.
:- typeof db_store(dbref, term, dbtermref) is pred.
:- typeof db_fetch(dbref, term, dbtermref) is pred.
:- typeof db_erase(dbref, dbtermref) is pred.
:- typeof db_erase(dbref, dbtermref, term) is pred.
:- typeof db_enumerate(dbref, term, dbtermref) is pred.
:- typeof db_findall(dbref, A, term, goal, list(A)) is pred.
:- typeof db_compress(dbref, atom) is pred.
:- typeof db_compress(dbref, atom, list(dbspec)) is pred.
:- typeof db_make_iterator(dbref, term, dbit) is pred.
:- typeof db_make_iterator(dbref, dbit) is pred.
:- typeof db_iterator_next(dbit, term, dbtermref) is pred.
:- typeof db_iterator_done(dbit) is pred.
:- typeof db_current_iterator(dbref, term, dbit) is pred.
