%% clpfd.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                                   TCLP                                    %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/yquem/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/clpfd.typ,v 1.9 2004/03/30 15:43:21 coquery Exp $
:- op(1200, xfx, [+:,-:,+?,-?]).
:- op(760,  yfx, #<=>).
:- op(750,  xfy, #=>).
:- op(750,  yfx, #<=).
:- op(740,  yfx, #\/).
:- op(730,  yfx, #\).
:- op(720,  yfx, #/\).
:- op(710,   fy, #\).
:- op(700,  xfx, [in,in_set]).
:- op(700,  xfx, [#=,#\=,#<,#=<,#>,#>=]).
:- op(550,  xfx, ..).
:- op(500,   fy, \).
:- op(490,  yfx, ?).
:- op(400,  yfx, [/>,/<]).

% :- typeof '+:'(pred,goal) is pred.
% :- typeof in(int,interval) is pred.
% :- type interval is [ \(interval) , \/(interval,interval),
%                       {}(int) ].
% :- typeof domain(list(int),int,int) is pred.
% :- typeof labeling(term,list(int)) is pred.

:- type fd_range_bound is [ inf , sup ].
:- order int < fd_range_bound.

:- type fd_term_expr is [ min(int), max(int), card(int),
                          -fd_term_expr,
                          fd_term_expr + fd_term_expr,
                          fd_term_expr - fd_term_expr,
                          fd_term_expr * fd_term_expr,
                          fd_term_expr /> fd_term_expr,
                          fd_term_expr /< fd_term_expr ].
:- order fd_range_bound < fd_term_expr.

:- type fd_values is [ (fd_values , fd_values) , true ].
:- order fd_term_expr < fd_values.

:- type boolean is [ 0 , 1 ].
:- order boolean < int.
:- order boolean < fd_constraint.

%% changer int en fd_term_expr verifier les fd_range_bounds ...
:- type fd_range is [ fd_term_expr .. fd_term_expr ,
                      dom(int), {}(fd_values),
                      fd_range /\ fd_range, fd_range \/ fd_range,
                      \ fd_range, fd_range + fd_range,
                      fd_range + fd_term_expr, - fd_range,
                      fd_range - fd_range, fd_term_expr - fd_range ,
                      fd_range - fd_term_expr,
                      fd_range mod fd_range, fd_range mod fd_term_expr,
                      fd_range ? fd_range,
                      unionof(fd_term_expr, fd_range, fd_range),
                      switch(fd_term_expr,
                             list(pair(fd_term_expr,fd_term_expr))) ].

:- type fd_rel_op is [ '#=', '#\=', '#<', '#=<', '#>', '#>=' ].

:- type fd_constraint.
:- order fd_constraint < pred.

%:- type fd_set.

% Arithmetic Constraints
:- typeof (int_expr #= int_expr) is fd_constraint.
:- typeof (int_expr #\= int_expr) is fd_constraint.
:- typeof (int_expr #< int_expr) is fd_constraint.
:- typeof (int_expr #=< int_expr) is fd_constraint.
:- typeof (int_expr #> int_expr) is fd_constraint.
:- typeof (int_expr #>= int_expr) is fd_constraint.
:- typeof sum(list(int),fd_rel_op,int) is pred.
:- typeof scalar_product(list(int),list(int),fd_rel_op, int) is pred.
:- typeof knapsack(list(int), list(int), int) is pred.

% Membership Constraints
:- typeof domain(list(int), fd_range_bound, fd_range_bound) is pred.
:- typeof (int in fd_range) is fd_constraint.
%:- typeof (int in_set fd_set) is fd_constraint.
:- typeof (int in_set list(int)) is fd_constraint.

% Propositional Constraints
:- typeof (fd_constraint #/\ fd_constraint) is fd_constraint.
:- typeof (#\ fd_constraint) is fd_constraint.
:- typeof (fd_constraint #\/ fd_constraint) is fd_constraint.
:- typeof (fd_constraint #=> fd_constraint) is fd_constraint.
:- typeof (fd_constraint #<= fd_constraint) is fd_constraint.
:- typeof (fd_constraint #<=> fd_constraint) is fd_constraint.
:- typeof #<=>(fd_constraint,fd_constraint) is fd_constraint.

% Combinatorial Constraints
:- typeof count(int,list(int),fd_rel_op,int) is pred.
:- typeof global_cardinality(list(int),(list(pair(int,int)))) is pred.
:- typeof element(int,list(int),int) is pred.
:- typeof relation(int,list(pair(int,fd_range)),int) is pred.
:- type fd_range_or_pair.
:- order fd_range < fd_range_or_pair.
:- order pair(A,B) < fd_range_or_pair.
:- type case_node is [ node(term,int,list(fd_range_or_pair)) ].
:- typeof case(A,list(A),list(case_node)) is pred.
:- type case_option is [ dom(int),
                         min(int),
                         max(int),
                         minmax(int),
                         val(int),
                         none(int) ].
:- typeof case(A,list(A),list(case_node),list(case_option)) is pred.
:- type all_diff_on_value is [ value, range, domain ].
:- type all_diff_option is [ on(all_diff_on_value),
                             complete(true_false) ].
:- typeof all_different(list(int)) is pred.
:- typeof all_different(list(int),list(all_diff_option)) is pred.
:- typeof all_different(list(int)) is pred.
:- typeof all_different(list(int),list(all_diff_option)) is pred.
:- typeof assignment(list(int),list(int)) is pred.
:- typeof assignment(list(int),list(int),list(all_diff_option)) is pred.
:- typeof circuit(list(int)) is pred.
:- typeof circuit(list(int),list(int)) is pred.
:- typeof serialized(list(int),list(int)) is pred.
:- type precedence is [ d(int,int,int), pair(int,int) in fd_range ].
:- type serialized_resource.
:- type serialized_option is [ precedences(list(precedence)),
                               resource(serialized_resource),
                               path_consistency(true_false),
                               static_sets(true_false),
                               edge_finder(true_false),
                               decomposition(true_false),
                               bounds_only(true_false) ].
:- typeof serialized(list(int),list(int),list(serialized_option)) is pred.
:- type task is [ (int, task1) ].
:- type task1 is [ (int, task2) ].
:- type task2 is [ (int, task3) ].
:- type task3 is [ (int, term) ].
:- type machine_decription is [ machine(term,int) ].
:- typeof cumulatives(list(task),list(machine_decription)) is pred.
:- type bound_spec is [ lower, upper ].
:- type prune_spec is [ all, next ].
:- type cumulative_option is [ bound(bound_spec),
                               prune(prune_spec),
                               generalization(true_false),
                               task_intervals(true_false) ].
:- typeof cumulatives(list(task),list(machine_decription),
                      list(cumulative_option)) is pred.
:- typeof cumulative(list(int),list(int),list(int),int) is pred.
:- typeof cumulative(list(int),list(int),list(int),int,
                     list(serialized_option)) is pred.
:- type fd_line is [ 'F'(int,int), 'F'(int,int,term) ].
:- typeof disjoint1(list(fd_line)) is pred.
:- type distjoint1_option is [ decomposition(true_false),
                              global(true_false),
                              wrap(int,int),
                              margin(int,term,term) ].
:- typeof disjoint1(list(fd_line),list(distjoint1_option)) is pred.
:- type fd_rectangle is [ 'F'(int,int,int,int),'F'(int,int,int,int,term) ].
:- typeof disjoint2(list(fd_rectangle)) is pred.
:- type distjoint2_option is [ decomposition(true_false),
                              global(true_false),
                              wrap(int,int,int,int),
                              margin(int,int,term,term),
                              synchronization(true_false) ].
:- typeof disjoint2(list(fd_rectangle), list(distjoint2_option)) is pred.

% Enumeration Predicates
:- typeof in_domain(int) is pred.
:- type fd_search_options is [ leftmost, min, max, ff, ffc, variable(atom),
                               step, enum, bisect, value(atom),
                               up, down,
                               all, minimize(int), maximize(int),
                               assumptions(int)].
:- typeof labeling(list(fd_search_options), list(int)) is pred.
:- typeof first_bound(int,int) is pred.
:- typeof later_bound(int,int) is pred.
:- typeof minimize(goal,int) is pred.
:- typeof maximize(goal,int) is pred.
:- type order_resource_option is [ first, last, est, lst, ect, lct ].
:- typeof order_resource(list(order_resource_option),
                         serialized_resource) is pred.

% Statistics Predicates
:- type fd_statistics_key is [ resumptions, entailments, prunings,
                               backtracks, constraints ].
:- typeof fd_statistics(fd_statistics_key, int) is pred.
:- typeof fd_statistics is pred.

% Answer Constraints
:- typeof full_answer is pred.

% The Global Constraint Programming Interface
%:- type fd_action is [ exit, fail, int=int, int in fd_range,
%                       int in_set fd_set, call(goal) ].
:- type fd_action is [ exit, fail, int=int, int in fd_range,
                       int in_set list(int), call(goal) ].
:- typeof dispatch_global(pred,term,term,list(fd_action)) is pred.
:- type fd_global_susp_mode is [ dom(int), min(int), max(int), minmax(int),
                                 val(int) ].
:- typeof fd_global(goal, term, list(fd_global_susp_mode)) is pred.

% Reflection Predicates
:- typeof fd_min(int,int) is pred.
:- typeof fd_max(int,int) is pred.
:- typeof fd_size(int,int) is pred.
%:- typeof fd_set(int,fd_set) is pred.
:- typeof fd_set(int,list(int)) is pred.
:- typeof fd_dom(int,fd_range) is pred.
:- typeof fd_degree(int,int) is pred.
:- typeof fd_neighbors(int,list(int)) is pred.
:- typeof fd_closure(list(int), list(int)) is pred.
:- typeof fd_copy_term(A, A, goal) is pred.

% FD Set Operations
:- type fd_interval is [ [ fd_range_bound | fd_range_bound ] ].
:- typeof is_fdset(term) is pred.
%:- typeof empty_fdset(fd_set) is pred.
:- typeof empty_fdset(list(fd_interval)) is pred.
%:- typeof fdset_parts(fd_set, fd_range_bound, fd_range_bound,
%                      list(fd_interval)) is pred.
:- typeof fdset_parts(list(fd_interval), fd_range_bound, fd_range_bound,
                      list(fd_interval)) is pred.
:- typeof empty_interval(int,int) is pred.
%:- typeof fdset_interval(fd_set, fd_range_bound, fd_range_bound) is pred.
:- typeof fdset_interval(list(fd_interval), fd_range_bound, fd_range_bound) is pred.
%:- typeof fdset_min(fd_set, fd_range_bound) is pred.
:- typeof fdset_min(list(fd_interval), fd_range_bound) is pred.
%:- typeof fdset_max(fd_set, fd_range_bound) is pred.
:- typeof fdset_min(list(fd_interval), fd_range_bound) is pred.
%:- fdset_size(fd_set, fd_range_bound) is pred.
:- fdset_size(list(fd_interval), fd_range_bound) is pred.
%:- typeof list_to_fdset(list(int),fd_set) is pred.
:- typeof list_to_fdset(list(int),list(fd_interval)) is pred.
%:- typeof fdset_to_list(fd_set,list(int)) is pred.
:- typeof fdset_to_list(list(fd_interval),list(int)) is pred.
%:- typeof fdset_to_range(fd_set, fd_range) is pred.
:- typeof fdset_to_range(list(fd_interval), fd_range) is pred.
%:- typeof range_to_fdset(fd_range, fd_set) is pred.
:- typeof range_to_fdset(fd_range, list(fd_interval)) is pred.
%:- typeof fdset_add_element(fd_set, int, fd_set) is pred.
:- typeof fdset_add_element(list(fd_interval), int, list(fd_interval)) is pred.
%:- typeof fdset_del_element(fd_set, int, fd_set) is pred.
:- typeof fdset_del_element(list(fd_interval), int, list(fd_interval)) is pred.
%:- typeof fdset_distjoint(fd_set, fd_set) is pred.
:- typeof fdset_distjoint(list(fd_interval), list(fd_interval)) is pred.
%:- typeof fdset_intersect(fd_set, fd_set) is pred.
:- typeof fdset_intersect(list(fd_interval), list(fd_interval)) is pred.
%:- typeof fdset_intersection(fd_set, fd_set, fd_set)  is pred.
:- typeof fdset_intersection(list(fd_interval), list(fd_interval), list(fd_interval))  is pred.
%:- typeof fdset_intersection(list(fd_set), fd_set)  is pred.
:- typeof fdset_intersection(list(list(fd_interval)), list(fd_interval))  is pred.
%:- typeof fdset_member(int, fd_set) is pred.
:- typeof fdset_member(int, list(fd_interval)) is pred.
%:- typeof fdset_eq(fd_set, fd_set) is pred.
:- typeof fdset_eq(list(fd_interval), list(fd_interval)) is pred.
%:- typeof fdset_subset(fd_set, fd_set) is pred.
:- typeof fdset_subset(list(fd_interval), list(fd_interval)) is pred.
%:- typeof fdset_subtract(fd_set, fd_set, fd_set) is pred.
:- typeof fdset_subtract(list(fd_interval), list(fd_interval), list(fd_interval)) is pred.
%:- typeof fdset_union(fd_set, fd_set, fd_set) is pred.
:- typeof fdset_union(list(fd_interval), list(fd_interval), list(fd_interval)) is pred.
%:- typeof fdset_union(list(fd_set), fd_set) is pred.
:- typeof fdset_union(list(list(fd_interval)), list(fd_interval)) is pred.
%:- typeof fdset_complement(fd_set, fd_set) is pred.
:- typeof fdset_complement(list(fd_interval), list(fd_interval)) is pred.

% FD predicates
:- tclp__define_clause_op(+:,fd_constraint).
:- tclp__define_clause_op(-:,fd_constraint).
:- tclp__define_clause_op(+?,fd_constraint).
:- tclp__define_clause_op(-?,fd_constraint).

:- typeof '+:'(fd_constraint,goal) is clause.
:- typeof '-:'(fd_constraint,goal) is clause.
:- typeof '+?'(fd_constraint,goal) is clause.
:- typeof '-?'(fd_constraint,goal) is clause.
