%% prolog.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/yquem/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/prolog.typ,v 1.7 2004/02/02 13:51:55 coquery Exp $

%% The prolog module in Sicstus Prolog

%% Assoc lib builtins
:- type assoc(A,B).
:- typeof assoc_to_list(assoc(A,B), list(pair(A,B)), list(pair(A,B))) is pred.
:- typeof assoc(int, A, B, assoc(A,B), assoc(A, B), assoc(A, B)) is pred.
:- typeof put_assoc(assoc(A,B),A,B,assoc(A,B),term) is pred.
:- typeof gen_assoc(A, assoc(A,B),B) is pred.
:- typeof get_assoc(A, assoc(A,B),B, assoc(A,B), B) is pred.
:- typeof get_assoc(A, assoc(A,B),B) is pred.

%% Atts built-ins
:- typeof '$save_attribute_info'(atom) is pred.

%% Module builtins
:- typeof get_module(atom,atom,atom) is pred.
:- typeof prolog is atom.

%% Illegal arguments
:- typeof illarg(term, term, int, term) is pred.
:- typeof illarg(term, term, int) is pred.

%% builtin bdd
:- typeof '$bdd_parts'(term,term,term,term) is pred.
:- typeof '$bdd_store'(term,term,term,term) is pred.
:- typeof '$bdd_univ_case'(term, term, term, term, term, term, term) is pred.
:- typeof '$bdd_negate'(term, term) is pred.
:- typeof '$bdd_subst_store'(term, term) is pred.
:- typeof '$bdd_type'(term, term, term) is pred.
:- typeof '$bdd_subst_reset' is pred.
:- typeof '$bdd_build'(term, term, term, term) is pred.
:- typeof '$bdd_subst_case'(term, term, term, term, term, term, term, term) is pred.

%% Atom codes
:- typeof '$atom_codes'(atom, list(int)) is pred.

%% Builtin list predicates
:- typeof merge(list(A),list(A),list(A)) is pred.
:- typeof subtract(list(A),list(A),list(A)) is pred.
:- typeof length(list(A),int,int) is pred.

%% Builtin term predicates
:- typeof '$acyclic'(A) is pred.
:- typeof '$term_variables'(A,list(term)) is pred.
:- typeof term_variables(A,list(term)) is pred.
:- typeof '$term_hash'(A,int,int,int) is pred.
:- typeof '$subsumes'(A,A) is pred.

%% Builtin predicates for trees
:- typeof dcg_translate_dcg_atom(atom, goal, A, A) is pred.

%% Other builtin predicates
:- typeof '$large_data'(int,term,term) is pred.
                                % what type for the last 2 args ?

