%% system.typ
%% Copyright (C) 2001,2002 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                                   TCLP                                    %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/yquem/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/system.typ,v 1.3 2003/11/21 16:56:52 coquery Exp $

%% system utilities in sicstus prolog

:- typeof now(atom) is pred.
:- type datime is [ datime(int,int,int,int,int,int) ].
:- typeof datime(datime) is pred.
:- typeof datime(atom,datime) is pred.
:- type delete_file_option is [ directory , recursive , ignore ].
:- typeof delete_file(atom,list(delete_file_option)) is pred.
:- typeof delete_file(atom) is pred.
:- typeof directory_files(atom,list(atom)) is pred.
:- typeof make_directory(atom) is pred.
:- typeof environ(atom,atom) is pred.
:- type stream_spec is [ null , std , pipe(stream) ].
:- typeof exec(atom, list(stream_spec), int) is pred.
:- type file_permission is [read,write,search,exists].
:- typeof file_exists(atom) is pred.
:- typeof file_exists(atom,file_permission) is pred.
:- typeof file_exists(atom,int) is pred.
:- typeof file_exists(atom,list(term)) is pred.
:- type system_file_type is [ regular, directory, fifo, 
                              symlink, socket , unknown ].
:- type file_property is [ type(system_file_type), size(int), mod_time(atom) ].
:- typeof file_property(atom,file_property) is pred.
:- typeof host_id(atom) is pred.
:- typeof host_name(atom) is pred.
:- typeof pid(int) is pred.
:- typeof kill(int,int) is pred.
:- typeof mktemp(atom,atom) is pred.
:- type popen_mode is [ read , write ].
:- typeof popen(atom,popen_mode,stream) is pred.
:- typeof rename_file(atom,atom) is pred.
:- typeof shell is pred.
:- typeof shell(atom) is pred.
:- typeof shell(atom,int) is pred.
:- typeof sleep(int) is pred.
:- typeof system is pred.
:- typeof system(atom) is pred.
:- typeof system(atom,int) is pred.
:- typeof tmpnam(atom) is pred.
:- typeof wait(int,int) is pred.
:- typeof working_directory(atom,atom) is pred.
