%% xml_data.typ
%% Copyright (C) 2005 INRIA Emmanuel Coquery

%% This library is free software; you can redistribute it and/or
%% modify it under the terms of the GNU Lesser General Public
%% License as published by the Free Software Foundation; either
%% version 2.1 of the License, or (at your option) any later version.

%% This library is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% Lesser General Public License for more details.

%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                                                                           %%
%%                              Prolog typer                                 %%
%%                                                                           %%
%%         Emmanuel Coquery, projet Contraintes, INRIA Rocquencourt          %%
%%                                                                           %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% $Header: /home/yquem/contraintes/coquery/cvs/contraintes/tclpchr/lib/sicstus/xml_data.typ,v 1.2 2005/06/17 16:54:01 coquery Exp $

%% Data types for xml

:- type xml_attribute is [ ( atom = list(int) ) ].

:- type xml_document is [ xml(list(xml_attribute),list(xml_cterm)),
                          malformed(list(xml_attribute),list(xml_cterm))].
:- type xml_cterm is [ pcdata(list(int)),
                       comment(list(int)),
                       namespace(atom,atom,xml_cterm),
                       element(atom,list(xml_attribute),list(xml_cterm)),
                       instructions(atom,list(int)),
                       cdata(list(int)),
                       doctype(atom,doctypeid),
                       unparsed(list(int)),
                       out_of_context(atom) ].

:- type doctypeid is [ public(list(int),list(int)),
                       system(list(int)),
                       local ].

:- type xml_term.
:- subtype xml_document < xml_term.
:- subtype xml_cterm < xml_term.
