/* eclat_items.c
* 
* Copyright (C) 2005 2006 Toon Calders, Bart Goethals, Szymon Jaroszewicz
* 
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or (at
* your option) any later version.
* 
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "eclat_items.h"

#include <stdio.h>

tidlist *
tidlist_new()
{
    tidlist * tl;
	
    tl = (tidlist *) malloc(sizeof(tidlist));
    if(tl != NULL)
    {
		tl->list = (size_t *) malloc(sizeof(size_t) * 128);
		tl->n = 0;
		tl->alloc_size = 128;
    }
    return tl;
}

void
tidlist_free(tidlist * tl)
{
    free(tl->list);
    free(tl);
}

void tidlist_append(tidlist * tl, size_t t)
{
    if(tl->n == tl->alloc_size)
    {
		tl->alloc_size *= 2;
		tl->list = (size_t *) realloc(tl->list, tl->alloc_size * sizeof(size_t));
    }
    tl->list[tl->n++] = t;
}

tidlist *
tidlist_intersect(tidlist * t1, tidlist * t2)
{
    tidlist * result = tidlist_new();
    size_t i = 0, j = 0;
	
    while(i < t1->n && j < t2->n)
    {
		if(t1->list[i] == t2->list[j])
		{
			tidlist_append(result, t1->list[i]);
			i++;
			j++;
		}
		else if(t1->list[i] > t2->list[j])
		{
			j++;
		}
		else
		{
			i++;
		}
    }
	
    return result;
}



tidlist **
make_item_tidlists(dataset * d_gt, dataset * d_lt)
{
    size_t i, j, k;
    size_t recno = 0;
    size_t n_items = d_gt->n_items;
    tidlist ** result;
	
    result = (tidlist **) malloc(n_items * sizeof(tidlist *));
    if(result == NULL)
    {
		return NULL;
    }
    for(k = 0; k < n_items; k++)
    {
		result[k] = tidlist_new();
    }
	
    for(i = 0; i < d_gt->n; i++)
    {
		for(j = 0; j < d_lt->n; j++)
		{
			for(k = 0; k < n_items; k++)
			{
				if(!isnan(d_lt->data[j][k]) && !isnan(d_gt->data[i][k]) && d_lt->data[j][k] < d_gt->data[i][k])
				{
					tidlist_append(result[k], recno);
				}
			}
			recno++;
		}
    }
    return result;
}



void
eclat_items(size_t i, tidlist * curlist, size_t n_items, tidlist ** item_tidlists, 
			size_t minsup, size_t * root, size_t lenroot, htable * freq)
{
    size_t supp = 0;
    size_t r, s, t, u;
    static size_t prune_buf[5000];
    tidlist * new_curlist;
	
    //for(s = 0; s < lenroot; s++)
    //	printf("%d,", root[s]);
    //printf(" cand\n", supp);
    if(i > n_items)
		return;
	
    if(lenroot >= 1)
    {
        // pruning
		if(lenroot >= 2)
		{
			prune_buf[0] = lenroot - 1;
			for(r = 0; r < lenroot; r++)
			{
				t = 1;
				for(s = 0; s < lenroot; s++)
					if(s != r)
						prune_buf[t++] = root[s];
					if(htable_get(freq, prune_buf) == NULL)
						return;
			}
		}
		
		
		// compute support
		if(lenroot >= 2)
		{
			new_curlist = tidlist_intersect(curlist, item_tidlists[root[lenroot - 1]]);
		}
		else
		{
			new_curlist = item_tidlists[root[lenroot - 1]];
		}
		supp = new_curlist->n;
		
		
		if(supp >= minsup)
		{
			printf("[");
			for(s = 0; s < lenroot; s++)
			{
				printf("%d", root[s]);
				if(s < lenroot - 1)
					printf(", ");
			}
            printf("] %d\n", supp);
			// insert new frequent set into a hashtable
			{
				size_t z;
				size_t * key = (size_t *) malloc((lenroot + 1) * sizeof(size_t));
				size_t * value = (size_t *) malloc(sizeof(size_t));
				
				key[0] = lenroot;
				for(z = 0; z < lenroot; z++)
				{
					key[z+1] = root[z];
				}
				*value = supp;
				htable_put(freq, key, value);
			}
		}
    }
    if(lenroot < 1 || supp >= minsup)
    {
		size_t j;
		for(j = n_items; j > i; j--)
		{
			root[lenroot] = j-1;
			eclat_items(j, new_curlist, n_items, item_tidlists, minsup, root, lenroot + 1, freq);
		}
    }
    if(lenroot >= 2)
    {
		tidlist_free(new_curlist);
    }
}

