/* qselect.h
 * 
 * Copyright (C) 2005 2006 Toon Calders, Bart Goethals, Szymon Jaroszewicz
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* quickselect implementation based on glibc quicksort */


#include <stdlib.h>

#include <stdio.h>

#define SWAP(a, b)			 	              \
  do							      \
    {							      \
      double * __tmp = *(a);				      \
      *(a) = *(b);						      \
      *(b) = __tmp;					      \
    } while (0)







void
quickselect (double **pbase, size_t total_elems,
	     size_t k, size_t coord)
{
  register double **base_ptr = pbase;
  double **lo = base_ptr;
  double **hi = &lo[(total_elems - 1)];

  if (total_elems <= 1)
    return;

  while (hi - lo > 2)
    {
      double **left_ptr;
      double **right_ptr;
      
      /* Select median value from among LO, MID, and HI. Rearrange
	 LO and HI so the three values are sorted. This lowers the
	 probability of picking a pathological pivot value and
	 skips a comparison for both the LEFT_PTR and RIGHT_PTR in
	 the while loops. */
      
      double **mid = lo + ((hi - lo) >> 1);
      
      if ((*mid)[coord] < (*lo)[coord])
	SWAP (mid, lo);
      if ((*hi)[coord] < (*mid)[coord])
	SWAP (hi, mid);
      else
	goto jump_over;
      if ((*mid)[coord] < (*lo)[coord])
	SWAP (mid, lo);
    jump_over:;
      
      left_ptr  = lo + 1;
      right_ptr = hi - 1;
      
      /* Here's the famous ``collapse the walls'' section of quicksort.
	 Gotta like those tight inner loops!  They are the main reason
	 that this algorithm runs much faster than others. */
      do
	{
	  while ((*left_ptr)[coord] < (*mid)[coord])
	    left_ptr++;
	  
	  while ((*mid)[coord] < (*right_ptr)[coord])
	    right_ptr--;
	      
	  if (left_ptr < right_ptr)
	    {
	      SWAP (left_ptr, right_ptr);
	      if (mid == left_ptr)
		mid = right_ptr;
	      else if (mid == right_ptr)
		mid = left_ptr;
	      left_ptr++;
	      right_ptr--;
	    }
	  else if (left_ptr == right_ptr)
	    {
	      left_ptr++;
	      right_ptr--;
	      break;
	    }
	}
      while (left_ptr <= right_ptr);
      
      
      /* Set up pointers for next iteration. */
      
      //if(mid == base_ptr + k)
      //{
      //	  return;
      //}
      //else 
      if(left_ptr > base_ptr + k)
	{
	  /* ignore right partition */
	  hi = right_ptr;
	}
      else if(right_ptr < base_ptr + k)
	{
	  /* ignore left partition */
	  lo = left_ptr;
	}
      else
      {
	  return;
      }
    }
  if (hi - lo == 1)
  {
      if(lo[1][coord] < lo[0][coord])
	  SWAP(lo, lo + 1);
  }
  else if (hi - lo == 2)
  {
      if(lo[1][coord] < lo[0][coord])
	  SWAP(lo, lo + 1);
      if(lo[2][coord] < lo[0][coord])
	  SWAP(lo, lo + 2);
      if(lo[2][coord] < lo[1][coord])
	  SWAP(lo + 1, lo + 2);
  }

}


