/* range_tree.h
 * 
 * Copyright (C) 2005 2006 Toon Calders, Bart Goethals, Szymon Jaroszewicz
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __RANGETREE_H__
#define __RANGETREE_H__

#include <stdlib.h>
#include <math.h>

#include "dataset.h"

//new!!
typedef struct 
{
	double value;
	unsigned short int is_positive;
} Bound;


typedef struct
{
    double * record;		/* pointer to database record */
    double value;		/* indexed value */
} index_entry;


typedef struct Range_tree
{
    size_t counter;
    size_t counterGrt; //new
    struct Range_tree * list;
    size_t listlen;
    double value;
    size_t dim;
    unsigned short int is_positive; //new
} range_tree;


range_tree *
range_tree_new(double value);

void
range_tree_free(range_tree * r);

void
range_tree_remove_dimension(range_tree * r, size_t n);

void 
range_tree_add_dim(range_tree * r, size_t a, index_entry * ind, size_t indlen);

//new
void 
my_range_tree_add_dim(range_tree * r, size_t a, index_entry * ind, size_t indlen, unsigned short int is_positive);

size_t
range_tree_get_count(range_tree * r, double * bounds, size_t lenbounds);

//new
size_t
my_range_tree_get_count(range_tree * r, Bound * bounds, size_t lenbounds, unsigned short int is_positive);

index_entry **
range_tree_create_indices(dataset * d);

void
range_tree_free_indices(index_entry ** indices, size_t n_indices);

#endif
