/* dataset.h
 * 
 * Copyright (C) 2005 2006 Toon Calders, Bart Goethals, Szymon Jaroszewicz
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __DATASET_H__
#define __DATASET_H__

#include <stdio.h>


typedef struct
{
    double ** data;
    size_t n;			/* records in vector */
    size_t alloc_size;		/* allocated records */
    size_t n_items;		/* number of items */
} dataset;

dataset *
dataset_new(void);

void
dataset_free(dataset * d, int free_records);

int
dataset_append_record(dataset * d, double * record);

dataset *
dataset_clone(dataset * d, int clone_records);

#define TIES_MIN 0
#define TIES_MAX 1
#define TIES_AVG 2

void
convert_to_ranks(dataset * d, int mode);

#endif
