/* eclat_items.h
 * 
 * Copyright (C) 2005 2006 Toon Calders, Bart Goethals, Szymon Jaroszewicz
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __ECLAT_ITEMS_H__
#define __ECLAT_ITEMS_H__

#include <stdlib.h>

#include "htable.h"
#include "dataset.h"

typedef struct
{
    size_t * list;
    size_t n;
    size_t alloc_size;
} tidlist;


/* returns an array of tidlists */
tidlist *
tidlist_new();

void
tidlist_free(tidlist * tl);

void tidlist_append(tidlist * tl, size_t t);

tidlist *
tidlist_intersect(tidlist * t1, tidlist * t2);

tidlist **
make_item_tidlists(dataset * d_gt, dataset * d_lt);

void
eclat_items(size_t i, tidlist * curlist, size_t n_items, tidlist ** item_tidlists, 
	    size_t minsup, size_t * root, size_t lenroot, htable * freq);


#endif
