/* htable.h
 * 
 * Copyright (C) 2005 2006 Toon Calders, Bart Goethals, Szymon Jaroszewicz
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __HTABHLE_H__
#define __HTABHLE_H__


#include <stdlib.h>

typedef struct
{
    void * key;
    void * value;
} entry;

typedef struct 
{
    size_t n;			/* elems in the table */
    size_t alloc_size;		/* allocated size */
    size_t (* hashfunc)(void *); /* hash func */
    int (* cmpfunc)(void *, void *); /* cmp func */
    entry * entries;
}htable;


htable *
htable_new(size_t (* hashfunc)(void *), int (* cmpfunc)(void *, void *));

void
htable_free(htable * h, int free_keys, int free_values);

void *
htable_get(htable * h, void * key);

/* if key already present replaces the value but does not free old
   value */
void
htable_put(htable * h, void * key, void * value);

#endif
