
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <map>
#include <string>
using namespace std;

//typedef char M[1024];
//M * mapping;

map<string, int> mapping;

size_t get_num_attr(size_t item)
{
	if (item%2 == 0) //if the item is even
		return item/2;
	else //odd
		return (item+1)/2;

}

void print_mapping()
{
 for( map<string,int>::iterator ii=mapping.begin(); ii!=mapping.end(); ++ii)
 {
      printf("%s => %d\n", ((*ii).first).c_str(), (*ii).second);
 }

} 


void create_mapping(char *fn) 
{
    char linebuf[2048];
    char *line, *token1, *token2, *tokenTmp, *ptr;
    FILE *f = fopen(fn, "r");
    if(f == NULL)
    {
		fprintf(stderr, "error opening mapping file\n");
		exit(1);
    }

   //mapping = (M *) malloc(num_items * sizeof(M));
   line = fgets(linebuf, 2048, f);
   //printf("%s\n",line);

   while(line != NULL && strlen(line) > 0)
   {
	if(line[strlen(line) - 1] = '\n')
	{
		line[strlen(line) - 1] = '\0';
	}
   	ptr = line;

       token1 = strtok(ptr, " ");
       token2 = strtok(NULL," ");

       mapping[string(token2)] = atoi(token1); 

       string tmp = string(token2) + "+";
       mapping[tmp] = atoi(token1)*2;

       tmp = string(token2) + "-";
       mapping[tmp] = atoi(token1)*2 - 1;

       line = fgets(linebuf, 2048, f);
    }
    fclose(f);
}


int main(int argc, char* argv[])
{
	if(argc < 3)
    {
		fprintf(stderr, "usage: mapitems gradualitemsfile mappingfile\n");
		return 10;
    }
	
    create_mapping(argv[2]);
    //print_mapping();
	
    char linebuf[2048];
    char *line, *token, *token1, *ptr;
    char * lcopy;
    FILE *f = fopen(argv[1], "r");
    size_t pos;
	
    if(f == NULL)
    {
		fprintf(stderr, "error opening gradualitems file\n");
		return 1;
    }

    //print_mapping();
	
	line = fgets(linebuf, 2048, f);
	
	while(line != NULL && strlen(line) > 0)
	{
		if(line[strlen(line) - 1] = '\n')
		{
			line[strlen(line) - 1] = '\0';
		}

 	        //printf("line: %s\n",line);	
                lcopy = strdup(line); //copy line
		ptr = lcopy;
		
		token = strtok(ptr, "[]");
		if (token != NULL)
		{
			ptr = strchr(token,':');
			if (ptr != NULL)
				printf("%s\n", line);
			else
			{
				pos = 0;
				token1 = strtok(token, ",");

				//print_mapping();
				while(token1 != NULL )
				{
					if (pos > 0)
						printf(", ");
					else
						printf("[");
	
					if (token1[0] == ' ') 
						token1 = &token1[1];
	
					if (token1[strlen(token)-1] == '=') 
						printf("%d=",mapping[token1]*2);
					else
						printf("%d",mapping[token1]);
					pos++;
					token1 = strtok(NULL, ",");
				}
				//printf("%s\n", line);
				ptr = strchr(line,']');
				if (ptr != NULL)
					printf("%s\n", ptr);
		  	    }
		}
		line = fgets(linebuf, 2048, f);
    }
    fclose(f);
    return 0;

} 
