
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

typedef char M[1024];
M * mapping;


size_t get_num_attr(size_t item)
{

	if (item%2 == 0) //if the item is even
		return item/2;
	else //odd
		return (item+1)/2;

}

void print_mapping(int num_items)
{
  //printf("%d\n",num_items);
  size_t i;
  for (i=0;i<num_items;i++)
  {
      printf("%d => %s\n", i, mapping[i]);
  }
}



void create_mapping(char *fn, int num_items) 
{
    char linebuf[2048];
    char *line, *token1, *token2, *ptr;
    FILE *f = fopen(fn, "r");
    if(f == NULL)
    {
		fprintf(stderr, "error opening mapping file\n");
		exit(1);
    }

   mapping = (M *) malloc(num_items * sizeof(M));
   line = fgets(linebuf, 2048, f);
   //printf("%s\n",line);

   while(line != NULL && strlen(line) > 0)
   {
	if(line[strlen(line) - 1] = '\n')
	{
		line[strlen(line) - 1] = '\0';
	}
   	ptr = line;

    	token1 = strtok(ptr, " ");
    	token2 = strtok(NULL," ");
	strcpy(mapping[atoi(token1)],token2);

	line = fgets(linebuf, 2048, f);
    }
    fclose(f);
}


int main(int argc, char* argv[])
{
   if(argc < 4)
    {
	fprintf(stderr, "usage: maprules rulesfile mappingfile num_items\n");
	return 10;
    }

    size_t num_items = atoi(argv[3]);
    create_mapping(argv[2], num_items);
    //print_mapping(num_items);

    char linebuf[2048];
    char *line, *token, *ptr;
    char * lcopy;
    FILE *f = fopen(argv[1], "r");
    size_t pos;

    if(f == NULL)
    {
		fprintf(stderr, "error opening rules file\n");
		return 1;
    }

   line = fgets(linebuf, 2048, f);

   while(line != NULL && strlen(line) > 0)
   {
	if(line[strlen(line) - 1] = '\n')
	{
		line[strlen(line) - 1] = '\0';
	}

        lcopy = strdup(line); //copy line
   	ptr = lcopy;

    	token = strtok(ptr, " ");
        pos = 0;
	while(token != NULL && token[0] != '(')
	{
		if (strcmp(token, "=>") != 0)
		{
			if (pos > 0)
				printf(", ");

			if (atoi(token)%2==0) //even 
				printf("%s+",mapping[get_num_attr(atoi(token))]);
			else
				printf("%s-",mapping[get_num_attr(atoi(token))]);
			pos++;
		}
		else
		{
	  		printf(" => ");    	   
			pos=0;
		}
	    	token = strtok(NULL, " ");
	}
	//printf("%s\n", line);
	ptr = strchr(line,'(');
	if (ptr != NULL)
		printf(" %s\n", ptr);

	line = fgets(linebuf, 2048, f);
    }
    fclose(f);
    return 0;

} 
