# Z-Indexed SZ Samplers

We provide three variants of **Z-indexed SZ samplers**, differing in how Z-indexed pixels are shuffled:

1. **`SZZSamplerMorton`**
   No shuffling, hence strong aliasing. Intended only for demonstration and benchmarking.

2. **`SZZSamplerZHash`**
   Uses the original hashing from Ahmed-and-Wonka (2020) on Z sampling.
   This hashing is table-less, hence more GPU-friendly and slightly faster.
   On the downside, it is invariant, hence not suitable for generating multiple instances.

3. **`SZZSamplerQARTOwen`**
   A recently introduced, more dynamic hashing with a randomization table that extends ART-Owen scrambling to base-4.

---

## Installation Instructions in PBRT-4

1. Copy `sz.h` to the `pbrt` folder.

2. Insert the following line in `pbrt/samplers.h`:

   ```cpp
   #include <pbrt/sz.h>
   ```

3. Copy the tables in `sz-tables.h` to the end of a suitable `.cpp` file (e.g., `pbrt/util/lowdiscrepancy.cpp`) and add declarations to the beginning of the corresponding header (e.g., `pbrt/util/lowdiscrepancy.h`):

   ```cpp
   // =============================================================================
   // Diagonals for fast evaluation of SZ samples
   // =============================================================================

   namespace pbrt {
   extern PBRT_CONST uint64_t SZMatrices_O2_Ensembled_Upper_Diagonals_64bit[7410]; // 15*14 + 240*30
   } // namespace pbrt

   // =============================================================================
   ```

4. In `pbrt/samplers.cpp`, function `Sampler Sampler::Create`, insert the following `else-if` clauses:

   ```cpp
   else if (name == "szz" || name == "szqart")
       sampler = SZZSamplerQARTOwen::Create(parameters, fullRes, loc, alloc);
   else if (name == "szzhash")
       sampler = SZZSamplerZHash::Create(parameters, fullRes, loc, alloc);
   else if (name == "szmorton")
       sampler = SZZSamplerMorton::Create(parameters, fullRes, loc, alloc);
   ```

5. In `pbrt/base/sampler.h`, add the following to the sampler declarations:

   ```cpp
   // -----------------------------------------------------------------------------
   // Forward declarations of base-4 Owen scramblers and the SZ-Z sampler template
   // -----------------------------------------------------------------------------
   template <class Base4Owen> class SZZSampler;
   class Base4OwenIdentity;
   class QARTOwen;
   class ZHash;
   // Concrete aliases (real types) for TaggedPointer
   using SZZSamplerMorton   = SZZSampler<Base4OwenIdentity>;
   using SZZSamplerQARTOwen = SZZSampler<QARTOwen>;
   using SZZSamplerZHash    = SZZSampler<ZHash>;
   ```

   Then add:
   ```cpp
   SZZSamplerMorton, SZZSamplerQARTOwen, SZZSamplerZHash
   ```
   to the `TaggedPointer` list in the `Sampler` class definition.

6. *(Optional)* For generating error plots, we recommend using 32-bit `.exr` images, which can be set in the film parameters of the input file.
   To avoid mistakes, you may want to set it by default. To do so, open `pbrt/film.cpp`, locate all lines reading:

   ```cpp
   bool writeFP16 = parameters.GetOneBool("savefp16", true);
   ```

   and replace `true` by `false`.
