/*
 * Implementation of SZ-based samplers
 * 2025-08-25: Created by Abdalla Ahmed from earlier versions.
 *
 */

namespace pbrt {
;

// =============================================================================
// Diagonals for fast evaluation of SZ samples
// =============================================================================

PBRT_CONST uint64_t SZMatrices_O2_Ensembled_Upper_Diagonals_64bit[7410] = {     // 15*14 + 240*30
    0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
    0xffffffffffffffff, 0x0000000000000000, 0x0000000000000000,
    0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
    0x0000000000000000, 0xffffffffffffffff, 0xaaaaaaaaaaaaaaaa,
    0xcccccccccccccccc, 0x8888888888888888,

    0x0000000000000000, 0x0000000000000000, 0x0550550550550550,
    0xf5af5af5af5af5af, 0x0aa0aa0aa0aa0aa0, 0x0000000000000000,
    0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
    0x0550550550550550, 0xfa5fa5fa5fa5fa5f, 0x4ea4ea4ea4ea4ea4,
    0x84c84c84c84c84c8, 0x8808808808808808,

    0x0000000000000000, 0x0000000000000000, 0x0550550550550550,
    0xfa5fa5fa5fa5fa5f, 0x0aa0aa0aa0aa0aa0, 0x0000000000000000,
    0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
    0x0550550550550550, 0xff0ff0ff0ff0ff0f, 0xe4ae4ae4ae4ae4ae,
    0xc0cc0cc0cc0cc0cc, 0x0880880880880880,

    0x0101100100011110, 0x0232203133012110, 0x0613354741526720,
    0xf4de158672acb93f, 0x0c266a8e82a4ce40, 0x08c880c4cc048440,
    0x0808800800088880, 0x0101100100011110, 0x0131103233021220,
    0x0346651714523720, 0xf2b78a16e453d9cf, 0x068cca2e28a46e40,
    0x04c440c8cc084880, 0x0808800800088880,

    0x0101100100011110, 0x0232203133012110, 0x0346651714523720,
    0xf17b4529d8a3e6cf, 0x068cca2e28a46e40, 0x08c880c4cc048440,
    0x0808800800088880, 0x0101100100011110, 0x0333303033003000,
    0x0035556363560360, 0xfc03c003fffc3c3f, 0xac682e802c446aea,
    0xccc0c0cc00c000cc, 0x8000888808088008,

    0x0010001111010110, 0x0323302122013110, 0x0134456263571270,
    0xfd187ab34e562c9f, 0x02688ac4c6ae24e0, 0x0c8cc0848804c440,
    0x0080008888080880, 0x0010001111010110, 0x0313301211023220,
    0x0065553636530630, 0xf3496518eba2c7df, 0x44caea6c28e20864,
    0x84408c880c4cc048, 0x8880808800800088,

    0x0010001111010110, 0x0323302122013110, 0x0461153236574270,
    0xf742daec1b59836f, 0x08c22a646cae84e0, 0x0c8cc0848804c440,
    0x0080008888080880, 0x0010001111010110, 0x0333303033003000,
    0x0752250205577270, 0xf000ffff0f0ff00f, 0xeae0e4aa40a044ee,
    0xc00c000cccc0c0cc, 0x0088880808800800,

    0x0011000110001100, 0x0322303223032230, 0x0463104631046310,
    0xf8be2f8be2f8be2f, 0x08c6208c6208c620, 0x0c88c0c88c0c88c0,
    0x0088000880008800, 0x0011000110001100, 0x0311303113031130,
    0x0136401364013640, 0xf1d74f1d74f1d74f, 0x026c8026c8026c80,
    0x0c44c0c44c0c44c0, 0x0088000880008800,

    0x0110101111000100, 0x0113102212033230, 0x0721753626544310,
    0xf9c265e43ba781df, 0x0e42ea6c4ca88620, 0x044c4088480cc8c0,
    0x0880808888000800, 0x0110101111000100, 0x0003003303033330,
    0x0366350565533060, 0xf330c03cc3f0fcff, 0xa0e8ae624846cc2a,
    0xcccc000c00cc0c0c, 0x8808088880008008,

    0x0011000110001100, 0x0322303223032230, 0x0136401364013640,
    0xf2eb8f2eb8f2eb8f, 0x026c8026c8026c80, 0x0c88c0c88c0c88c0,
    0x0088000880008800, 0x0011000110001100, 0x0311303113031130,
    0x0063500635006350, 0xfcb19fcb19fcb19f, 0x4086a4086a4086a4,
    0x8cc808cc808cc808, 0x8008080080800808,

    0x0110101111000100, 0x0113102212033230, 0x0724756323511640,
    0xf63895b1cead247f, 0x0e48eac646a22c80, 0x044c4088480cc8c0,
    0x0880808888000800, 0x0110101111000100, 0x0003003303033330,
    0x0727755020522570, 0xf00ff0f0ffff000f, 0xee440a04aa4e0eae,
    0xcc0c0cccc000c00c, 0x0080088080888800,

    0x0111100010011010, 0x0112103313022320, 0x0273254171566430,
    0xfc6e3a8d9254b71f, 0x04e64a82e2acc860, 0x044840cc4c088c80,
    0x0888800080088080, 0x0111100010011010, 0x0221203323011310,
    0x0276251474533160, 0xf367c51b94a2de8f, 0x04ec4a28e8a662c0,
    0x088480cc8c044c40, 0x0888800080088080,

    0x0100101001010010, 0x0233202332023320, 0x0614306143061430,
    0xfb28efb28efb28ef, 0x0c2860c2860c2860, 0x08cc808cc808cc80,
    0x0800808008080080, 0x0100101001010010, 0x0333303333033330,
    0x0563005630056300, 0xf30f3f30f3f30f3f, 0xa88c6a88c6a88c6a,
    0xc0c00c0c00c0c00c, 0x8088880888808888,

    0x0100101001010010, 0x0233202332023320, 0x0341603416034160,
    0xfe82bfe82bfe82bf, 0x0682c0682c0682c0, 0x08cc808cc808cc80,
    0x0800808008080080, 0x0100101001010010, 0x0133101331013310,
    0x0650306503065030, 0xfb9c1fb9c1fb9c1f, 0x48a0648a0648a064,
    0x8c0c88c0c88c0c88, 0x8000880008800088,

    0x0111100010011010, 0x0112103313022320, 0x0276251474533160,
    0xf39bca276851ed4f, 0x04ec4a28e8a662c0, 0x044840cc4c088c80,
    0x0888800080088080, 0x0111100010011010, 0x0003003303033330,
    0x0275252777500250, 0xf0ffff000f00ff0f, 0xe400a40ae4a4aeee,
    0xc00cc0c0cccc000c, 0x0808888000800880,

    0x0000000001010100, 0x0300000002020200, 0x0105050503030600,
    0x020a050a01010400, 0x121a1a0b06170d00, 0x2f1323020b1a0a00,
    0x64246153597b0b00, 0x48c742a1a26e0eff, 0xd848c2a6a2e60600,
    0x9c4c8c083c783800, 0xa080d00810984800, 0x30f0a0f020208000,
    0x4000a00020208000, 0x40000000c0c0c000, 0x8000000000000000,
    0x0001000100000100, 0x0002000103000100, 0x0002050604050605,
    0x000c05070b0a0705, 0x00050b1d181b1d1a, 0x000a31151f212613,
    0x000a166e31262a34, 0xff03e887d138c3db, 0x00042cdc724c5468,
    0x0038c4645c84a84c, 0x004858f8b088f8d0, 0x0040a090d0f090a0,
    0x0080a0e06000e0a0, 0x00c0008040008000, 0x0000008080008000,

    0x0101010001010100, 0x0102020002020200, 0x0203060506030600,
    0x03010b0a04010400, 0x05061c0b1c170d00, 0x060b2b021b1a0a00,
    0x5b0c3953297b0b00, 0x51f7125e3d91f1ff, 0xb60862a642e60600,
    0x283cbc087c783800, 0x38109008c0984800, 0x1020d0f080208000,
    0x6020200080208000, 0x80c0c000c0c0c000, 0x8000000000000000,
    0x0001000101010000, 0x0000030300000303, 0x0003030503030303,
    0x00030003030c0f00, 0x00011718011b1c06, 0x000c0f333f30000f,
    0x000e60033d566d53, 0xfff333300cccc000, 0xaabee67672345ef6,
    0xccfcc03cccf0300c, 0x88d00880688888b0, 0xf03000c0c030c030,
    0xa08000c04060c000, 0xc00000c00000c0c0, 0x8000000080800080,

    0x0000000000010100, 0x0303030000020200, 0x0101010500030600,
    0x0d0d020a0f010400, 0x1203120b11170d00, 0x2c3d2f02211a0a00,
    0x30123106322e5e00, 0x10dc1df4e3c45bff, 0x7034720c644cac00,
    0x90d49c0884783800, 0xf078a008d8984800, 0x606030f050208000,
    0xe0e04000a0208000, 0x4040400000c0c000, 0x8080800000000000,
    0x0000000101010001, 0x0003000201020002, 0x0000000603060503,
    0x000c0f080108050d, 0x0010051c071c0b06, 0x002c3a2b3a2b0e34,
    0x00305b3d0b680608, 0xff2f62d63d830830, 0x4434e27e56d40c40,
    0x88d8bc6854a43870, 0xd838d0e8e8b858d0, 0x5010607040d06060,
    0xa060e080c060e0e0, 0xc080800040408080, 0x0080800080808080,

    0x0001010000010100, 0x0301010000020200, 0x0107020505030600,
    0x02060c0a0a010400, 0x031f140b0b170d00, 0x0d252702311a0a00,
    0x573a6906422e5e00, 0xa6134d0b833ba4ff, 0xbe74d20c844cac00,
    0x14a4ac08c4783800, 0x28e8e00808984800, 0x30b040f0f0208000,
    0x40c0c00000208000, 0x4080800000c0c000, 0x8080800000000000,
    0x0001010000010101, 0x0000030000000303, 0x0002000005020500,
    0x000f000f000f0f00, 0x001a050f0a0b1105, 0x003f0c3c0f3f0c3f,
    0x005f07225a7d2a25, 0xffff00f0fffff0ff, 0xee140ef45e40a4f0,
    0xccfc3c3000ccf03c, 0x50d070d8f858f888, 0x0000f0f0f00000f0,
    0xa0e0400000a0a0a0, 0xc000c0c000c00000, 0x8080008000800000,

    0x0001000000010100, 0x0002000003020200, 0x0003050504030600,
    0x0f0e050a07010400, 0x11171a1a08061c00, 0x211910133f0b1b00,
    0x327a702414597c00, 0xe39c60c7d7a297ff, 0x64e4e04838a2e800,
    0x8474404cdc3c7c00, 0xd8c8d0807010c000, 0x5070a0f090208000,
    0xa080a000e0208000, 0x00c0000040c0c000, 0x0000000080000000,
    0x0001010101000001, 0x0001010101000002, 0x0006060606050502,
    0x0007070807050a0c, 0x000c1d1d1d1a1a04, 0x003425261610133b,
    0x001d2e7a6a303149, 0xffea379c7320de4e, 0x102a5ce4d4607292,
    0x20f0948868406cdc, 0x2010b8d8a8d0f030, 0xc0102050c0a09020,
    0x402060a040a0e060, 0x80c0400080008040, 0x8000800080008080,

    0x0100010000010100, 0x0100020003020200, 0x0205060501030600,
    0x0c050b0a02010400, 0x140b1c1a12061c00, 0x140118132f0b1b00,
    0x2d07282431597c00, 0xc506cf381d5d68ff, 0x5a0e404872a2e800,
    0x6004704c9c3c7c00, 0xe0589080a010c000, 0x40a0d0f030208000,
    0xc0a0200040208000, 0x8000c00040c0c000, 0x8000000080000000,
    0x0000000100000001, 0x0003030000030003, 0x0003060600060505,
    0x000f000c0f0f0f0c, 0x001c08140a020502, 0x00330f330f003c3c,
    0x005b0e5e0b50333d, 0xff3f0f3fff0ffc00, 0xba9c0292aceada6e,
    0xcc003030f03c30f0, 0xe8383050b8b8d038, 0x3030f030000030f0,
    0xe000c080606080c0, 0xc0c00000c0c00000, 0x0080800000000080,

    0x0101000001010100, 0x0101030001020200, 0x0207010507030600,
    0x0309020a09010400, 0x141f121a0e061c00, 0x24261c13040b1b00,
    0x3d3b75715d0c2900, 0xea1e6a92a508c2ff, 0x7a76fae2ba084200,
    0xa0a8504c203c7c00, 0xb0b8a0803010c000, 0x10e030f0e0208000,
    0x6060400060208000, 0x8080400080c0c000, 0x8080800080000000,
    0x0001010001010001, 0x0002020301010302, 0x0003060506060006,
    0x0002070904040c07, 0x0012080a0d1c1008, 0x001c333306242f33,
    0x006505550b386050, 0xffb5c6960d2f7c93, 0x548a0ebe062480a4,
    0xa8ccc82804c83c34, 0xb850086808585058, 0xd0500070f0506060,
    0x60a0008040a0e0e0, 0x40c0000080c08080, 0x8000000080008080,

    0x0100010001010100, 0x0203010001020200, 0x0301020502030600,
    0x0e020c0a0c010400, 0x1703141a14061c00, 0x193e1413140b1b00,
    0x7a462d71780c2900, 0x9c7bc56d90f73dff, 0xe49c5ae2f0084200,
    0x74d8604c603c7c00, 0xc828e080e010c000, 0x703040f040208000,
    0x8040c000c0208000, 0xc040800080c0c000, 0x0080800080000000,
    0x0001000100010000, 0x0003030303030000, 0x0005070002050505,
    0x000f0f0000000000, 0x00100404011e0b1a, 0x003f3c3c0c303f3f,
    0x005f25700a5d780f, 0xff0000f00ff0ff00, 0xfefa0a500a0a4a4a,
    0xcc00ccc00cfcc0c0, 0x70f0882008f85000, 0x00f0f000f0000000,
    0xe000e040e0a0a000, 0xc000c000c000c000, 0x0000008000008000,

    0x0000000001010100, 0x0300000002020200, 0x0105050503030600,
    0x020a050a01010400, 0x030b0b1a06171c00, 0x3e31322038292800,
    0x464216351d3f3800, 0x847c241a2ae6e0ff, 0x9c842c6a2a6e6000,
    0xd8c4c880f0b4b000, 0x280858801098c000, 0x30f0a0f020208000,
    0x4000a00020208000, 0x40000000c0c0c000, 0x8000000000000000,
    0x0001000100000100, 0x0002000103000100, 0x0002050604050605,
    0x000c05070b0a0705, 0x00140a0d190b0d1b, 0x001803051d323621,
    0x0038015e33421a23, 0xffd00ea82d43ec3d, 0x006002ac76843446,
    0x30703c0464c8d8b4, 0x40c01008a85868c8, 0x40401000c05070b0,
    0x8080200040a0c080, 0xc0c0c000800040c0, 0x0000000080008000,

    0x0101010001010100, 0x0102020002020200, 0x0203060506030600,
    0x03010b0a04010400, 0x14060d1a0d171c00, 0x24383a2039292800,
    0x3d481b351a3f3800, 0x157f21e5d3191fff, 0x7a80266a246e6000,
    0xa0f0f880f4b4b000, 0xb01018804898c000, 0x1020d0f080208000,
    0x6020200080208000, 0x80c0c000c0c0c000, 0x8000000000000000,
    0x0001000101010000, 0x0000030300000303, 0x0003030503030303,
    0x00030003030c0f00, 0x00111718111a0d06, 0x000c3f303f33333f,
    0x006b555558066d66, 0xffccc3c033c003f0, 0xaa4a282e86d88828,
    0xfc00f0c030fcf03c, 0xe8d0e0886808b068, 0xf000f00000c00000,
    0x20e0200080c06080, 0x00000000c0c0c0c0, 0x0080000080000080,

    0x0000000000010100, 0x0303030000020200, 0x0101010500030600,
    0x0d0d020a0f010400, 0x0312031a11171c00, 0x0e1f3e2012292800,
    0x03211360236a6d00, 0x01cdd14f3e4cb5ff, 0x165236c046c4ca00,
    0x185cd88048b4b000, 0x78f02880d898c000, 0x606030f050208000,
    0xe0e04000a0208000, 0x4040400000c0c000, 0x8080800000000000,
    0x0000000101010001, 0x0003000201020002, 0x0000000603060503,
    0x000c0f080108050d, 0x0000140d070d0a16, 0x000f1b3939393c14,
    0x0005680b5b5e556d, 0xff06b3c161946a45, 0x440e8416e6acfeda,
    0xb838f4e8b834a46c, 0xd8080868d858b8e0, 0x90c030709090d080,
    0xa0004080a0a060c0, 0x00c0400000004080, 0x0000800000008080,

    0x0001010000010100, 0x0301010000020200, 0x0107020505030600,
    0x02060c0a0a010400, 0x121f051a1a171c00, 0x1c16362013292800,
    0x752b1e60246a6d00, 0x6a31d4b038b34aff, 0xfa563cc048c4ca00,
    0x5068e8804cb4b000, 0xa0e868808098c000, 0x30b040f0f0208000,
    0x40c0c00000208000, 0x4080800000c0c000, 0x8080800000000000,
    0x0001010000010101, 0x0000030000000303, 0x0002000005020500,
    0x000f000f000f0f00, 0x001a041e1a0b1104, 0x000c3f3f3c0c0f0c,
    0x00782257585a7800, 0xfffff00f00ff000f, 0xee0ef0f4e05ae41e,
    0xfc0c3c0c000cfc3c, 0x700088f080f82050, 0x00f0f0f0f0f0f000,
    0xa0e0a000e000e0e0, 0x00c00000c0000000, 0x0000000000008080,

    0x0001000000010100, 0x0002000003020200, 0x0003050504030600,
    0x0f0e050a07010400, 0x11170b0b08060d00, 0x121901313f383900,
    0x232f0742411d4f00, 0x3ec9067c7d2a79ff, 0x464e0e84922a8e00,
    0x487404c4dcf0f400, 0xd8c8580870104800, 0x5070a0f090208000,
    0xa080a000e0208000, 0x00c0000040c0c000, 0x0000000080000000,
    0x0001010101000001, 0x0001010101000002, 0x0006060606050502,
    0x0007070807050a0c, 0x001c0d1c0d1b0a15, 0x0024351706220029,
    0x002d1e395a27557b, 0xffc5182e5cc6a59d, 0x104a3c62a45ebaf6,
    0x1080d47c38a820a4, 0x60d0689018f820f8, 0x80507010e0903060,
    0xc0a0c02020e040e0, 0x400040c0c0808080, 0x8000800000808080,

    0x0100010000010100, 0x0100020003020200, 0x0205060501030600,
    0x0c050b0a02010400, 0x051a0d0b03060d00, 0x051009313e383900,
    0x5a700a42131d4f00, 0x5c60fc83d1d586ff, 0xb4e00484362a8e00,
    0x244034c4d8f0f400, 0x68d0180828104800, 0x40a0d0f030208000,
    0xc0a0200040208000, 0x8000c00040c0c000, 0x8000000080000000,
    0x0000000100000001, 0x0003030000030003, 0x0003060600060505,
    0x000f000c0f0f0f0c, 0x000d18051b030413, 0x00000c030c000c3c,
    0x005b3d083e56005e, 0xfffcc00cccf3f0c3, 0xba5abe1ca44ea02e,
    0xfcf0003c30fcc0cc, 0x880038503830d080, 0x3030c0c000f000f0,
    0x6060a02060c0e0a0, 0x000000c0c00000c0, 0x8080008000808080,

    0x0101000001010100, 0x0101030001020200, 0x0207010507030600,
    0x0309020a09010400, 0x051f030b0e060d00, 0x06260d3104383900,
    0x5b3b57175d481a00, 0xaee1a6295a802cff, 0xb676be2eba802400,
    0x28a814c420f0f400, 0x38b8280830104800, 0x10e030f0e0208000,
    0x6060400060208000, 0x8080400080c0c000, 0x8080800080000000,
    0x0001010001010001, 0x0002020301010302, 0x0003060506060006,
    0x0002070904040c07, 0x0013081b0c1d0008, 0x001d002237150c00,
    0x00330033083b5555, 0xff1100dd33115555, 0x546600764476aaba,
    0x988830544498fcdc, 0xb88850e888e85060, 0x10f090b0004060b0,
    0x6040a08000c0e080, 0x808000c0004080c0, 0x8080000000808000,

    0x0100010001010100, 0x0203010001020200, 0x0301020502030600,
    0x0e020c0a0c010400, 0x1712050b05060d00, 0x192f053105383900,
    0x2f645a170f481a00, 0xc9b75cd6097fd3ff, 0x4ed8b42e1e802400,
    0x749c24c424f0f400, 0xc8a0680868104800, 0x703040f040208000,
    0x8040c000c0208000, 0xc040800080c0c000, 0x0080800080000000,
    0x0001000100010000, 0x0003030303030000, 0x0005070002050505,
    0x000f0f0000000000, 0x00101505110f1b0a, 0x003c0f0f0f300c0c,
    0x000d25557d7a7a0d, 0xfff00f0000ff00ff, 0xfeba40befe4ae4f4,
    0xfc3c3cf0c0fcc0c0, 0x5008a88828780828, 0x00f0f0f0f0000000,
    0xe0a0e0a0a0a00040, 0x00000000c0000000, 0x8000800080000080,

    0x0101000000010000, 0x0101000300020300, 0x0707050405030400,
    0x09060a070a0e0700, 0x0e0e0b081a060800, 0x0434313f203b0c00,
    0x5d4d424160490500, 0x5a75837d4f8d0aff, 0xba9a8492c0821a00,
    0x20e0c4dc80fc1000, 0x3060087080407000, 0xe0b0f090f0709000,
    0x60c000e00080e000, 0x8080004000c04000, 0x8080008000008000,
    0x0001010101000000, 0x0002020101000303, 0x0007020306000101,
    0x0006030d080f0101, 0x000f04171c010303, 0x0009382527323e3e,
    0x000e4d7b29124217, 0xff084a9dce1cbce9, 0x000c8af65224943e,
    0x0034f0a4acc8d8d8, 0x004810f8a0583838, 0x00b01060c0502020,
    0x008020e040a06060, 0x00c0c08080004040, 0x0000008080008080,

    0x0100000001010000, 0x0200000301020300, 0x0300050402030400,
    0x010f0a07030e0700, 0x17000b0814060800, 0x2930023f173b0c00,
    0x3f4506412c490500, 0xe67a0b823772f5ff, 0x6e8a0c9258821a00,
    0xb4c008dc6cfc1000, 0x98500870b0407000, 0x2050f09010709000,
    0x20a000e06080e000, 0xc000004080c04000, 0x0000008080008000,
    0x0001010100000000, 0x0000030000000300, 0x0006000305050305,
    0x00030c030000000f, 0x000f0c101f0e1714, 0x000f0c3f03033c3f,
    0x0050050e6d5e5353, 0xff03003f3c0f3330, 0xaaf61e62f2e28086,
    0xcc000000fc303c3c, 0x88b838d058e03860, 0xf0c0c0f030000000,
    0xa0a0a04080806080, 0xc00000c000c0c0c0, 0x8000000000800080,

    0x0100000001010000, 0x0200000301020300, 0x0300050402030400,
    0x010f0a07030e0700, 0x17001a0805060800, 0x1a03203f353b0c00,
    0x7b5460144a1c5000, 0x6ea7b02873275fff, 0xe6a8c0389428b000,
    0x780c80dce4fc1000, 0x9850807038407000, 0x2050f09010709000,
    0x20a000e06080e000, 0xc000004080c04000, 0x0000008080008000,
    0x0001010100000000, 0x0002010200000300, 0x0006060305050505,
    0x0007040d0a0a0605, 0x00191d061f0e0f0b, 0x0022250716343a3d,
    0x00333e5d3b085e06, 0xff2d24561dc067c4, 0x44262cbe6600f81c,
    0x88c4c4e8b4c0a0e4, 0xd8080838d800b038, 0x50f000d090f02020,
    0xa0400060a0402020, 0xc08000400080c0c0, 0x0080008000800000,

    0x0101000000010000, 0x0101000300020300, 0x0707050405030400,
    0x09060a070a0e0700, 0x0e0e1a080b060800, 0x0407133f023b0c00,
    0x5d5c2414061c5000, 0xa55738d7f4d8a0ff, 0xbab848380c28b000,
    0x202c4cdc08fc1000, 0x3060807008407000, 0xe0b0f090f0709000,
    0x60c000e00080e000, 0x8080004000c04000, 0x8080008000008000,
    0x0001010101000000, 0x0000000303000303, 0x0007020500000707,
    0x00000f0f000f0f0f, 0x000e1a11051e0404, 0x000c3f0c0c0f0f0f,
    0x00500a7f52770257, 0xfff0000f000fff00, 0xee4050e0a4f4eeaa,
    0xcc30fcf0f0ccf0f0, 0x50a05870a87028a0, 0x00f0f0f0000000f0,
    0xa0e0004000e000e0, 0xc000c0c0c0c0c000, 0x8080800080008080,

    0x0000000000010000, 0x0003030300020300, 0x0001010400030400,
    0x0f0d0d070f0e0700, 0x0012031900171900, 0x302c0e2e302a1d00,
    0x10305636456b7200, 0x2f10541b7a4193ff, 0x2070bc7c8ac6f400,
    0xc0901898c0b85400, 0x50f078f850c8f800, 0x5060609050709000,
    0xa0e0e0e0a080e000, 0x0040404000c04000, 0x0080808000008000,
    0x0001000000010101, 0x0002000303010201, 0x0002050104030703,
    0x000c050e0b0d090d, 0x00041a0319161e07, 0x0008230e2d271836,
    0x005821572379681f, 0xff5f3159c2618016, 0x10b042ae56f2c03e,
    0x20108c0894ac70d8, 0x20608058b8a09068, 0xc08000a020c0e070,
    0x40c000a0604020c0, 0x804000004080c040, 0x8080000080800080,

    0x0101000001010000, 0x0202030301020300, 0x0306010407030400,
    0x0e040d07060e0700, 0x061c03190e171900, 0x3b283d2e072a1d00,
    0x1c6d12365c6b7200, 0x27b523e457be6cff, 0x28ca347cb8c6f400,
    0xfcb0d4982cb85400, 0x40c078f860c8f800, 0x70806090b0709000,
    0x8080e0e0c080e000, 0xc0c0404080c04000, 0x0000808080008000,
    0x0000000000000001, 0x0003030300030303, 0x0003060300060600,
    0x000f000f0f0f000c, 0x000d191c1b02080d, 0x00330f330f330f0f,
    0x0068680e38365b50, 0xff0c3c3f33f0f0fc, 0xba9cfc6216d8465c,
    0xccfcfc30c03ccccc, 0xe8d000e0b8880060, 0x303030f030300030,
    0xe0806020006000e0, 0xc0000000c00000c0, 0x0000800080800000,

    0x0101000001010000, 0x0202030301020300, 0x0306010407030400,
    0x0e040d07060e0700, 0x060d12190e171900, 0x3b0a1f2e342a1d00,
    0x495e21634d3e2700, 0x725b324e75ebc6ff, 0x82ac52d69a6c5e00,
    0xfc385c98e0b85400, 0x4048f0f860c8f800, 0x70806090b0709000,
    0x8080e0e0c080e000, 0xc0c0404080c04000, 0x0000808080008000,
    0x0000000000000001, 0x0003030300030301, 0x0005000500000006,
    0x00090c090f030c04, 0x000a011b0405101c, 0x00003e2238351c24,
    0x000053665d0e606d, 0xff0f6d786a344f7a, 0x5404e68cfe5cc48e,
    0xa838b40894647834, 0xb8088808b8b8d808, 0xd03030f0e0209030,
    0x604040402020a040, 0x4040408000c00040, 0x8080808000000080,

    0x0000000000010000, 0x0003030300020300, 0x0001010400030400,
    0x0f0d0d070f0e0700, 0x0003121900171900, 0x030e2c2e032a1d00,
    0x01036563543e2700, 0xf20145b1a71439ff, 0x0216dad6a86c5e00,
    0x0c1890980cb85400, 0x5078f0f850c8f800, 0x5060609050709000,
    0xa0e0e0e0a080e000, 0x0040404000c04000, 0x0080808000008000,
    0x0001000000010101, 0x0000000303030003, 0x0002050702050705,
    0x00000f000f0f0f0f, 0x0005051b1e100001, 0x00300300030c003f,
    0x007a58727f7d557d, 0xff000f0f00ff0f00, 0xfea4aaeafa14a4be,
    0xcc00c0ccf030c030, 0x705880085058d808, 0x00f0f00000f0f000,
    0xe040e000e0004040, 0xc000c00000c000c0, 0x0080000080808000,

    0x0100010001010000, 0x0200010302020300, 0x0305020403030400,
    0x0e0a0307010e0700, 0x171a141917061900, 0x1920241d29082e00,
    0x7a6068276a0d3600, 0x634fbfc64c05e4ff, 0xe4c0d05ec40a7c00,
    0x7480a054b4309800, 0xc880b0f89840f800, 0x70f0109020709000,
    0x800060e02080e000, 0xc0008040c0c04000, 0x0000808000008000,
    0x0000010000010101, 0x0000010003020102, 0x0000030001020307,
    0x000f0d0f010c0d06, 0x000106101214171f, 0x003137131c18152a,
    0x00161c34606d6b2f, 0xffe7142b7f858d39, 0x003c2878d0dad65e,
    0x30d4fc6c60605498, 0x406810f0f0a0e8b8, 0x4080106060c070d0,
    0x80c020e0e040c060, 0xc040c08080804040, 0x0080008080808080,

    0x0001010000010000, 0x0301010303020300, 0x0402020404030400,
    0x08030307080e0700, 0x0805141908061900, 0x0f35171d0f082e00,
    0x044a7927510d3600, 0x0773623952fa1bff, 0x1894f25eb20a7c00,
    0x1ce46c541c309800, 0x2038b0f82040f800, 0xc0101090c0709000,
    0x406060e04080e000, 0x4080804040c04000, 0x8080808080008000,
    0x0000010001000100, 0x0003030300030003, 0x0006050306060306,
    0x000f0c000c000300, 0x0013130615090018, 0x00030f3f303c3f0f,
    0x003538335e3e6b6b, 0xffcc330f3c0c003f, 0xaaa2167c946486fc,
    0xfc0cc0c000c0fcc0, 0xe858b8383858e038, 0xf0003030c000f0c0,
    0x20e00000a0e020a0, 0x0000c0c000000000, 0x0080808000800000,

    0x0001010000010000, 0x0301010303020300, 0x0402020404030400,
    0x08030307080e0700, 0x0814051908061900, 0x3c17351d3c082e00,
    0x402c1f7215586300, 0x7037269325afb1ff, 0x90583ef43aa0d600,
    0xd06ce454d0309800, 0x20b038f82040f800, 0xc0101090c0709000,
    0x406060e04080e000, 0x4080804040c04000, 0x8080808080008000,
    0x0000010001000100, 0x0003010302030203, 0x0000030506000300,
    0x00030e06080c0d0c, 0x0014021e1c111600, 0x0027331b282d273c,
    0x006d553838633850, 0xff8696132f712360, 0x44ceae74248624f0,
    0xb8b808a4c808c490, 0xd8d808b8580808e0, 0x9090f0d050f00040,
    0xa0a04060a04000c0, 0x00008040c0800040, 0x0000808000800080,

    0x0100010001010000, 0x0200010302020300, 0x0305020403030400,
    0x0e0a0307010e0700, 0x170b051917061900, 0x1902061d1a082e00,
    0x2f060e722e586300, 0x36f4fb6cc4504eff, 0x4e0c1cf44ca0d600,
    0x7408285478309800, 0xc80838f89840f800, 0x70f0109020709000,
    0x800060e02080e000, 0xc0008040c0c04000, 0x0000808000008000,
    0x0000010000010101, 0x0000030003000300, 0x0000050007020507,
    0x000f0f0f0f000f00, 0x001e000f1515111e, 0x000c3c0c0f003c0f,
    0x00757857202f0f77, 0xfff000f0f0f0ff0f, 0xee1ab04ea4aeb0f4,
    0xfc0c000cccfc30fc, 0x702870d080a00000, 0x00000000f0f0f0f0,
    0xa040e0a0e0e0a0a0, 0x0000c0c0c0000000, 0x0080008000800000,

    0x0101010001010000, 0x0102020302020300, 0x0703060406030400,
    0x09010407040e0700, 0x1f171c080d170800, 0x151a1b0c0a193f00,
    0x2a2e7c505e2f4100, 0xc3c468a05bc97dff, 0x544ce8b0ac4e9200,
    0x64787c103874dc00, 0xb898c07048c87000, 0xe020809080709000,
    0x602080e08080e000, 0x80c0c040c0c04000, 0x8000008000008000,
    0x0001000001000000, 0x0001000302030000, 0x0006050407010000,
    0x00080a0406010f0f, 0x001c0a180e121111, 0x0017001c382f2222,
    0x0039556048212772, 0xff2ea57fb0313663, 0x1062bac080525ee4,
    0x107c2040f09ca888, 0x6090208040e0f8d8, 0x80103000b07060a0,
    0xc020400080c0e0a0, 0x40c08000c0408000, 0x8000800000808000,

    0x0100010000010000, 0x0103020303020300, 0x0704060401030400,
    0x060804070d0e0700, 0x0e081c0812170800, 0x340f280c2c193f00,
    0x18516d50302f4100, 0xdf524a5f103682ff, 0x30b2cab0704e9200,
    0xe01cb0109074dc00, 0x6020c070f0c87000, 0xb0c0809060709000,
    0xc04080e0e080e000, 0x8040c04040c04000, 0x8080008080008000,
    0x0000010101010001, 0x0000000000000303, 0x0005030306060305,
    0x00000c030303000c, 0x001f1a100f1e1613, 0x0033033c3c3c3f0f,
    0x000d630863500338, 0xff3ccf30f33fcf3c, 0xba724c60309adc0c,
    0xfc3c00300c0cc0cc, 0x888888b0683868d0, 0x3030f00030c030f0,
    0x6060a060e0a0e040, 0x0000c0c0c000c0c0, 0x8080800000000000,

    0x0100010000010000, 0x0103020303020300, 0x0704060401030400,
    0x060804070d0e0700, 0x0e080d0803170800, 0x073c0a0c0e193f00,
    0x09155e05037a1400, 0xfd25a4f5016328ff, 0x123aac1a16e43800,
    0x2cd038101874dc00, 0x6020487078c87000, 0xb0c0809060709000,
    0xc04080e0e080e000, 0x8040c04040c04000, 0x8080008080008000,
    0x0000010101010001, 0x0000020202020301, 0x0005030306060503,
    0x000a020d0707060e, 0x001f130619080e02, 0x00262e0411333b33,
    0x003b335d66550855, 0xffdddd55bb993399, 0x546666ba88ba44aa,
    0x984474dcfc207430, 0xb8d8d86050308800, 0x10a06040602030c0,
    0x60e0e0c0e0204000, 0x8040804080c040c0, 0x8080808080008000,

    0x0101010001010000, 0x0102020302020300, 0x0703060406030400,
    0x09010407040e0700, 0x1f170d081c170800, 0x1529390c28193f00,
    0x2a6a4f056d7a1400, 0x3c4c860ab59cd7ff, 0x54c48e1acae43800,
    0x64b4f410b074dc00, 0xb8984870c0c87000, 0xe020809080709000,
    0x602080e08080e000, 0x80c0c040c0c04000, 0x8000008000008000,
    0x0001000001000000, 0x0003000300030000, 0x0000050207070000,
    0x00000000000f0f0f, 0x00050a000f150e0e, 0x003c3f0f3f3c3f3f,
    0x00222f5f70072277, 0xff00000000f00ff0, 0xfe140abaa4be1e4a,
    0xfcc0f0c03c0cf0f0, 0x50a8a0a07020d870, 0x00f0f000f00000f0,
    0xe0a0e0404040e040, 0x00c00000c00000c0, 0x8080808000808000,

    0x0001000001000100, 0x0001000301000100, 0x0507050107000200,
    0x0a090a0d090f0300, 0x0b1f0b031f110500, 0x3115313d26210600,
    0x172a42123b320e00, 0xd63c83dc1ee304ff, 0x2e54843476641c00,
    0xc464c4d4a8842800, 0x08b80878b8d83800, 0xf0e0f060e0501000,
    0x006000e060a06000, 0x0080004080008000, 0x0080008080008000,
    0x0001010000000000, 0x0001020300000003, 0x0003020405000004,
    0x00020c04050f0f04, 0x000714080b011019, 0x00061b0f0232232d,
    0x000f395452122123, 0xff09de54ac1c3e32, 0x001e62b8a4244256,
    0x00287c1c08c88c94, 0x0028c0605858d0e8, 0x00304080a0505080,
    0x004080c0a0a0a0c0, 0x0080c04000000040, 0x0080008000000080,

    0x0101010000000100, 0x0202020300000100, 0x0306060105000200,
    0x010b040d050f0300, 0x170d0d030b110500, 0x29090a3d01210600,
    0x6a0a5e1207320e00, 0xb3fca423061cfbff, 0xc404ac340e641c00,
    0xb43438d404842800, 0x9818487858d83800, 0x20d08060a0501000,
    0x202080e0a0a06000, 0xc0c0c04000008000, 0x0000008000008000,
    0x0001000000010001, 0x0000000003000303, 0x0006050506060600,
    0x000c0f0f0f030f0c, 0x00150505121e030c, 0x00003f0c030f303f,
    0x003b355366636636, 0xff3cfcfc30cf0300, 0xaa1ad25af84c8e78,
    0xccf03cc0cc00fcfc, 0x88d088603888b008, 0xf0c0c0c0300000c0,
    0xa020c040000060c0, 0xc0c0c000c000c0c0, 0x8080008080000000,

    0x0100000001000100, 0x0203030302000100, 0x0604010103000200,
    0x0b070d0d0e0f0300, 0x1c08120317110500, 0x2b0c2c3d19210600,
    0x6c0565477a675b00, 0xb80a45899c4951ff, 0xc81ada9ee4ceb600,
    0xbc1090d474842800, 0x9070f078c8d83800, 0xd090606070501000,
    0x20e0e0e080a06000, 0xc0404040c0008000, 0x0080808000008000,
    0x0000010000010100, 0x0003020003010200, 0x0005030505030300,
    0x00060d0a0601020f, 0x001e060e0f160305, 0x002b07073a183d09,
    0x006d5d5d5e6d060e, 0xff76a9a698b53404, 0x448efafebc9a5c1c,
    0x8808605828ec5424, 0xd808e0e86860e838, 0x500080407080b0d0,
    0xa000c0c080c08060, 0xc00080400080c040, 0x0000808000800080,

    0x0100010000000100, 0x0200010303000100, 0x0305020101000200,
    0x0e05030d020f0300, 0x061a140303110500, 0x0810173d3e210600,
    0x0d25794746675b00, 0x053562767bb6aeff, 0x0a4af29e9cceb600,
    0x30406cd4d8842800, 0x40d0b07828d83800, 0x70a0106030501000,
    0x80a060e040a06000, 0xc000804040008000, 0x0000808080008000,
    0x0001010000000101, 0x0000030000030003, 0x0002000505020705,
    0x000f00000000000f, 0x001a141b0a010e00, 0x000c3f0f3c3c3f3f,
    0x007d07782d7a722a, 0xffffffff00f00ff0, 0xee04a40a0a44bee0,
    0xcc300c30ccc0300c, 0x50780070d80858d8, 0x0000f0f00000f000,
    0xa0a0e040a00000a0, 0xc000c0c0c000c0c0, 0x8000000080008080,

    0x0001000000000100, 0x0001030300000100, 0x0007010105000200,
    0x0f060d0d0a0f0300, 0x001f03120b001400, 0x30253d2c31301700,
    0x453a126542107900, 0x85ec23ba7c2f9dff, 0x8a7434da8420f200,
    0xc0a4d490c4c06c00, 0x50e878f00850b000, 0x50b06060f0501000,
    0xa0c0e0e000a06000, 0x0080404000008000, 0x0080808000008000,
    0x0000010100000101, 0x0000010103030102, 0x0000030601040607,
    0x000f0d07010b0706, 0x0011071d12080c0f, 0x001236162f0f070a,
    0x00671f6a74540c0f, 0xff89168c94a4fbf6, 0x10de3ec4f8b8080e,
    0x2058d848ac2c3c08, 0x20e86888a0204058, 0xc0807000c030b0a0,
    0x40c0c000404080a0, 0x804040008080c000, 0x8080800080800000,

    0x0001010001000100, 0x0002010301000100, 0x0006020107000200,
    0x0f04030d060f0300, 0x110d05121f001400, 0x1239062c16301700,
    0x234f0e652b107900, 0xc186fb4531d062ff, 0x468e1cda5620f200,
    0x48f4289068c06c00, 0xd84838f0e850b000, 0x50801060b0501000,
    0xa08060e0c0a06000, 0x00c0804080008000, 0x0000808080008000,
    0x0000000101010000, 0x0003000303000300, 0x0006000505060305,
    0x00000f03030c0f0f, 0x00190a1908050d14, 0x003c3c330000000f,
    0x000e3850050b5b66, 0xff3c00ccff0c0c30, 0xba74603cb41aeae8,
    0xcc30c0ccfc0000cc, 0xe8d850b08060d008, 0x3030f0303030f000,
    0xe080400060e04000, 0xc000c0c000c0c000, 0x0000008080000000,

    0x0100000000000100, 0x0203000303000100, 0x0604050101000200,
    0x04080a0d0d0f0300, 0x1c191a1212001400, 0x282d202c1f301700,
    0x3862603021452c00, 0x1f43b0efcd85c8ff, 0x60d4c070528a5800,
    0xb09480905cc06c00, 0xc0a880f0f050b000, 0x80c0f06060501000,
    0x804000e0e0a06000, 0xc040004040008000, 0x0080008080008000,
    0x0000010001000001, 0x0000020002000302, 0x0005030506050003,
    0x000a0205070a030d, 0x000f031a191e1407, 0x00063e1c11242406,
    0x005b033536683d0b, 0xffa2c2eae480da02, 0x54e2023e2cc06e02,
    0xa84cfc140480443c, 0xb8d050385880d800, 0xd0509010a0f0a0c0,
    0x60a0a060e040e000, 0x40c00080408040c0, 0x8000008080808000,

    0x0000010001000100, 0x0000020302000100, 0x0505060103000200,
    0x0a0a040d010f0300, 0x0b0b1c1206001400, 0x31311b2c38301700,
    0x42177c3048452c00, 0x7cd668107f7a37ff, 0x842ee870808a5800,
    0xc4c47c90f0c06c00, 0x0808c0f01050b000, 0xf0f0806020501000,
    0x000080e020a06000, 0x0000c040c0008000, 0x0000008000008000,
    0x0001000001000001, 0x0000030300030303, 0x0007070707070200,
    0x000f000f0f0f000f, 0x00001b150004011b, 0x0033000f000f3f00,
    0x0022272500077d72, 0xff0f0ffff0fff000, 0xfe0e50a0e0e45ef4,
    0xccc030ccf0fcc0f0, 0x70d8d0d870207808, 0x0000f00000f00000,
    0xe0a000a0a0e0e040, 0xc0c0c0c00000c0c0, 0x0080808000800000,

    0x0100010000000100, 0x0200010303000100, 0x0305020101000200,
    0x0e05030d020f0300, 0x060b051212111400, 0x0801351f2f122400,
    0x58521f7464763d00, 0x50532667b76beaff, 0xa0a43ef8d8ec7a00,
    0x3004e45c9c48a000, 0x405838f0a0d8b000, 0x70a0106030501000,
    0x80a060e040a06000, 0xc000804040008000, 0x0000808080008000,
    0x0001010000000101, 0x0002010000030201, 0x0002060505040703,
    0x0003080a0a04060d, 0x00041d0b1a091f06, 0x000b1632233d2a04,
    0x000c6a4271437a58, 0xfffb83bc61bd9350, 0x0018d484e296e4b0,
    0x301c68f88ce4b820, 0x4030f81880789870, 0x4020601000901060,
    0x8060e02000e020e0, 0xc04080c00080c080, 0x0080800000800080,

    0x0100000001000100, 0x0203030302000100, 0x0604010103000200,
    0x0b070d0d0e0f0300, 0x0d08031217111400, 0x3a0c0e1f19122400,
    0x4e5056742f763d00, 0x8ba05498c99415ff, 0x8cb0bcf84eec7a00,
    0xf810185c7448a000, 0x187078f0c8d8b000, 0xd090606070501000,
    0x20e0e0e080a06000, 0xc0404040c0008000, 0x0080808000008000,
    0x0000010000010100, 0x0003000003030000, 0x0003030503050300,
    0x0000030000030c0f, 0x0006001e17181a1a, 0x003f3f300c03000c,
    0x00663e0d3333606d, 0xfff000cf3c3fc03f, 0xaa2878d41a1c40f4,
    0xfc3cfcfcc0f030fc, 0xe8685850e088e000, 0xf00030c030c0f0c0,
    0x20808020e0c020c0, 0x00c000c0c0c000c0, 0x0080008000000000,

    0x0101010000000100, 0x0202020300000100, 0x0306060105000200,
    0x010b040d050f0300, 0x171c1c121a111400, 0x1a18281f10122400,
    0x2e286d2170236800, 0x3bcf4a3260c1bfff, 0x4c40ca52e046d000,
    0x7870b05c4048a000, 0x9890c0f0d0d8b000, 0x20d08060a0501000,
    0x202080e0a0a06000, 0xc0c0c04000008000, 0x0000008000008000,
    0x0001000000010001, 0x0002000003020301, 0x0006050500060006,
    0x0008050503070304, 0x001c0a0a0508140d, 0x00280f3c05001436,
    0x006d00005e50385b, 0xff850cc0a4af1f92, 0x44da0000fce474a2,
    0xb8ac0cc05448a80c, 0xd8b05050e888e850, 0x902050a040008050,
    0xa020a0e0c000c0a0, 0x00c0c040400080c0, 0x0000008080008000,

    0x0001000001000100, 0x0001000301000100, 0x0507050107000200,
    0x0a090a0d090f0300, 0x1a1f1a121f111400, 0x1315131f26122400,
    0x712a24213b236800, 0x6dc338cde13e40ff, 0xe25448527646d000,
    0x4c644c5ca848a000, 0x80b880f0b8d8b000, 0xf0e0f060e0501000,
    0x006000e060a06000, 0x0080004080008000, 0x0080008080008000,
    0x0001010000000000, 0x0003000300000003, 0x0005020205000002,
    0x000000000f0f0f00, 0x001e1500041e0f11, 0x0030330c303f0c0c,
    0x00580d0d2d57027a, 0xfff00ffff00f0fff, 0xee1040e4faf41a0a,
    0xfcc0fcc00c0c3c0c, 0x70a07808a8f05808, 0x00f000f0f0f0f000,
    0xa0a0a0e0a0000000, 0x00c000c0c000c000, 0x0080000080008000,

    0x0000010001000100, 0x0000020302000100, 0x0505060103000200,
    0x0a0a040d010f0300, 0x1a1a0d0306000500, 0x1313390e0b033500,
    0x24714f030c544a00, 0xc76d8601f7a773ff, 0x48e28e1608a89400,
    0x4c4cf4183c0ce400, 0x8080487810503800, 0xf0f0806020501000,
    0x000080e020a06000, 0x0000c040c0008000, 0x0000008000008000,
    0x0001000001000001, 0x0002030302030301, 0x0007010107010406,
    0x00090e0109010407, 0x000e03120e03090d, 0x000b3e1c383e3e06,
    0x000942654d47425a, 0xff0e438ab546b3a3, 0x101294da9a8e94b4,
    0x102cd860d0f8d828, 0x602068f030186878, 0x8030806020107060,
    0xc040c0e06020c0e0, 0x4080408040c04080, 0x8080808080008080,

    0x0100000000000100, 0x0203000303000100, 0x0604050101000200,
    0x04080a0d0d0f0300, 0x0d190b0303000500, 0x0a1e020e3d033500,
    0x0b26060312544a00, 0xf1340bfedc588cff, 0x065c0c1634a89400,
    0x38580818d40ce400, 0x48a8087878503800, 0x80c0f06060501000,
    0x804000e0e0a06000, 0xc040004040008000, 0x0080008080008000,
    0x0000010001000001, 0x0000000000000300, 0x0005030506050603,
    0x00000c0f03000f03, 0x001f1a150f0e0301, 0x0033030c3c33003c,
    0x000d6366633e036e, 0xffc3303c0c0f0c03, 0xbac8f6e48a621a9e,
    0xfcc0fcf0f0c030fc, 0x88000038e05000d0, 0x3000c0f000f0c0c0,
    0x6000c0c08040c020, 0x0000c000c0c0c0c0, 0x8000008080000080,

    0x0001010001000100, 0x0002010301000100, 0x0006020107000200,
    0x0f04030d060f0300, 0x111c14031f000500, 0x211b240e25033500,
    0x327c68563a011f00, 0x1c68bf54130d26ff, 0x64e8d0bc74023e00,
    0x847ca018a40ce400, 0xd8c0b078e8503800, 0x50801060b0501000,
    0xa08060e0c0a06000, 0x00c0804080008000, 0x0000808080008000,
    0x0000000101010000, 0x0003000101020300, 0x0000000303060505,
    0x000c0f0101080905, 0x00111517060c0a1b, 0x001d192a3b08331d,
    0x00333b6e5d5d5533, 0xff111188995599ee, 0x547666ccaabaaa32,
    0x98a8b88830dc0020, 0xb8e8d8d850305060, 0x1080905090e05070,
    0x60c0a0a0a020a080, 0x808000c00000c000, 0x8080000000000000,

    0x0001000000000100, 0x0001030300000100, 0x0007010105000200,
    0x0f060d0d0a0f0300, 0x001f12031a000500, 0x03161f0e13033500,
    0x542b215624011f00, 0x58ce32abc7f2d9ff, 0xa85652bc48023e00,
    0x0c685c184c0ce400, 0x50e8f07880503800, 0x50b06060f0501000,
    0xa0c0e0e000a06000, 0x0080404000008000, 0x0080808000008000,
    0x0000010100000101, 0x0000030303030300, 0x0000050007020007,
    0x000f0f0f0f0f0f00, 0x000e010b151f1a1e, 0x003f0f303c03033f,
    0x00220d2252282207, 0xfff0f00f0ff0f000, 0xfee0fe0aeab4b04a,
    0xfc0cf0fc0cfcccc0, 0x508858a88880a800, 0x0000f000f0f000f0,
    0xe0000000e0a040e0, 0x0000c0c0c00000c0, 0x8000808000008000,

    0x0001000101010100, 0x0302000201020100, 0x0406050307060700,
    0x0804050106040600, 0x190d1a171f1c0e00, 0x1e39232916280700,
    0x731a613f7e380900, 0x9ed342199b1f02ff, 0xf624c26efc601200,
    0x58f48cb468b02c00, 0xa848d098e8c06000, 0xc080a020b080b000,
    0x4080a020c080c000, 0x40c000c080c08000, 0x8000000080008000,
    0x0000010000000101, 0x0003020003000102, 0x0001070001050307,
    0x000e090f0e0a0d09, 0x00021f10131b060e, 0x000c2a101d213408,
    0x00052f3063261d0d, 0xff0a362f7d38eafa, 0x001a4e60d64c3a0a,
    0x0010b8405484e030, 0x006098d0e8887010, 0x0070e05070f060e0,
    0x00c020a0c000e020, 0x0040c000400080c0, 0x0080000080008000,

    0x0101000101010100, 0x0102030202020100, 0x0203010306060700,
    0x0c01020104040600, 0x140603170d1c0e00, 0x14380d2939280700,
    0x781d573f4f380900, 0x6f2aa6e679e0fdff, 0xf02abe6e8e601200,
    0x60f014b4f4b02c00, 0xe010289848c06000, 0x402030208080b000,
    0xc02040208080c000, 0x80c040c0c0c08000, 0x8000800000008000,
    0x0001010100010101, 0x0003000300030300, 0x0005060005000006,
    0x000c0c030f0c030c, 0x00020416141d0715, 0x000f00303f3f0300,
    0x005b085d5305083b, 0xff0ff03f30330cc3, 0xaafca09486680cb0,
    0xcc30f00c3c303c3c, 0x88d8e06060b03058, 0xf0c000c000f0f030,
    0xa020804080c0c080, 0xc0c0c000c0000000, 0x8080808080808000,

    0x0000010101010100, 0x0000010201020100, 0x0000020302060700,
    0x0f0f0c0103040600, 0x00111417141c0e00, 0x0312142924280700,
    0x54232d6a686d5c00, 0xa73ec54c40b557ff, 0xa8465ac4d0cab800,
    0x0c4860b4a0b02c00, 0x50d8e098b0c06000, 0x505040201080b000,
    0xa0a0c0206080c000, 0x000080c080c08000, 0x0000800080008000,
    0x0000000100010100, 0x0003030100010203, 0x0005000300030605,
    0x00090c0e0f0e0806, 0x000a100214020d0f, 0x00331f002b00093a,
    0x0050655068055b5e, 0xff63b6a0730aa167, 0x44e48ef0941ef6f8,
    0x8884c860142458a0, 0xd88808e06868b8b0, 0x50f0f0704080e020,
    0xa0404080c0c02020, 0xc0808000408000c0, 0x0080800080800000,

    0x0100010101010100, 0x0100020202020100, 0x0205060303060700,
    0x0c0a0b0101040600, 0x141a0d17061c0e00, 0x27133a290b280700,
    0x69241b6a596d5c00, 0x4d3821b35d4aa8ff, 0xd24826c4a2cab800,
    0xac4cf8b43cb02c00, 0xe080189810c06000, 0x40f0d0202080b000,
    0xc00020202080c000, 0x8000c0c0c0c08000, 0x8000000000008000,
    0x0001010001010001, 0x0000000303000000, 0x0007020200070002,
    0x00000f0000000f0f, 0x001f1a10140e1e0b, 0x003f0c0f3f3f0f3f,
    0x0005287a5272777d, 0xfff0ff0f00f00fff, 0xeeaeaeeee050f440,
    0xcc00fcf00cfccccc, 0x5058a07888087058, 0x0000f00000f00000,
    0xa0a0e0a000a0e0a0, 0xc0c000000000c0c0, 0x8080800000000080,

    0x0001010101010100, 0x0301020202020100, 0x0402060306060700,
    0x070c0b010b040600, 0x08051c061c0d1f00, 0x3f05183818391600,
    0x410f28487d1a7e00, 0x7d09cf7f65d39bff, 0x921e4080ea24fc00,
    0xdc2470f070f46800, 0x706890109048e800, 0x9040d020d080b000,
    0xe0c020202080c000, 0x4080c0c0c0c08000, 0x8080000000008000,
    0x0000010100000101, 0x0000010203030101, 0x0000030201040606,
    0x000f0d03010b0808, 0x0000161503081d0c, 0x0030141a0d3c1537,
    0x00103d6a03106b49, 0xffefda7c0d1f72be, 0x10306ad40620d682,
    0x20e0705834f064cc, 0x207090e81810a850, 0xc090e080101030a0,
    0x40e020c0202040a0, 0x8080c040c0c08000, 0x8080008000008000,

    0x0001010101010100, 0x0301010201020100, 0x0407020307060700,
    0x08090c0109040600, 0x190e05060e0d1f00, 0x2d04363837391600,
    0x375d1e48191a7e00, 0x165ad480d22c64ff, 0x7eba3c803224fc00,
    0x9420e8f0ecf46800, 0xa83068103048e800, 0xc0e04020e080b000,
    0x4060c0206080c000, 0x408080c080c08000, 0x8080800080008000,
    0x0000010101010001, 0x0000000300000300, 0x0005030506060303,
    0x00000c0303030f0c, 0x001e1b191e0f0d1b, 0x003333333c3c0033,
    0x005e555000665b00, 0xff30c333c0f3f3c3, 0xba882886c03e50d6,
    0xcc0cc000f03cccf0, 0xe858d05830003808, 0x30f0f000f030c030,
    0xe04040e0c060a060, 0xc0c0c00000000000, 0x0000008080800080,

    0x0100000101010100, 0x0103030202020100, 0x0204010303060700,
    0x030702010e040600, 0x14081206060d1f00, 0x243f2f383b391600,
    0x6841311d494f2b00, 0x407d1d2a8d79ceff, 0xd092722a828e5600,
    0xa0dc9cf0fcf46800, 0xb070a0104048e800, 0x109030207080b000,
    0x60e040208080c000, 0x804040c0c0c08000, 0x8080800000008000,
    0x0001010101010101, 0x0001010201020101, 0x0006060606060603,
    0x000b0b070b08040e, 0x00181808090c1c02, 0x002f1c000d0b1700,
    0x0030650556586d50, 0xffdc450a5453b650, 0x5460da1ebca49eb0,
    0xa84c5c24d4f4d8e0, 0xb880e03838083860, 0xd0f0b020e0301070,
    0x6040802020406080, 0x4080c0c000408000, 0x8080000000808000,

    0x0100000101010100, 0x0203000201020100, 0x0601050302060700,
    0x0b0205010c040600, 0x1c030b06140d1f00, 0x183e013814391600,
    0x2813071d2d4f2b00, 0xcfd106d5c58631ff, 0x40360e2a5a8e5600,
    0x70d804f060f46800, 0x90285810e048e800, 0xd030a0204080b000,
    0x2040a020c080c000, 0xc04000c080c08000, 0x0080000080008000,
    0x0001000100000100, 0x0003030303000003, 0x0005070502050202,
    0x000f0f00000f000f, 0x0001151e1005051e, 0x003f3c300c300330,
    0x0028075d7d2f5808, 0xff0000f0f0f000ff, 0xfe044e0a0afeb4ae,
    0xccccfcfc0c0cfc3c, 0x70d070f858f08020, 0x00f00000f000f0f0,
    0xe040a0a040e0a0e0, 0xc000000000c00000, 0x0080000080000080,

    0x0100000101010100, 0x0103030202020100, 0x0204010303060700,
    0x030702010e040600, 0x05080306061c1f00, 0x063f3e0b3b1b2500,
    0x0e1413591c7c3a00, 0x04d7d1a2d897ecff, 0x1c3836a228e87400,
    0x28dcd83cfc7ca400, 0x3870281040c0e800, 0x109030207080b000,
    0x60e040208080c000, 0x804040c0c0c08000, 0x8080800000008000,
    0x0001010101010101, 0x0001010201020101, 0x0006060206020603,
    0x00070703070c0802, 0x001c1c040d051d07, 0x0027140b05091606,
    0x007c6d0c5e5e6a5f, 0xff9b8a0457587c59, 0x00e8ca18acbcd4ae,
    0x308c402c34145808, 0x40d0d0704838b858, 0x40a0506040d02050,
    0x80a0a0e0806060a0, 0xc0000080c0404000, 0x0000008000808000,

    0x0100000101010100, 0x0203000201020100, 0x0601050302060700,
    0x0b0205010c040600, 0x0d121a06051c1f00, 0x092f100b051b2500,
    0x0a3170595a7c3a00, 0xfc1d605d5c6813ff, 0x0472e0a2b4e87400,
    0x349c403c247ca400, 0x18a0d01068c0e800, 0xd030a0204080b000,
    0x2040a020c080c000, 0xc04000c080c08000, 0x0080000080008000,
    0x0001000100000100, 0x0003030303000003, 0x0005030506050606,
    0x00030f0c000f0c0f, 0x00091c1318040413, 0x0030333c0f3c0330,
    0x00660b5e3e605e06, 0xff0ccf333ff00f33, 0xaa84dc8e0220f26e,
    0xfcf0c00cc000003c, 0xe8e868508050e0e0, 0xf000c0000000c000,
    0x208040e000e04080, 0x00c00000000000c0, 0x0080808000808080,

    0x0001010101010100, 0x0301020202020100, 0x0402060306060700,
    0x070c0b010b040600, 0x08140d060d1c1f00, 0x3f14090b091b2500,
    0x14780a0c5f296f00, 0xd790fcf7563db9ff, 0x38f00408ae42de00,
    0xdc60343c347ca400, 0x70e0181018c0e800, 0x9040d020d080b000,
    0xe0c020202080c000, 0x4080c0c0c0c08000, 0x8080000000008000,
    0x0000010100000101, 0x0000010203030101, 0x0000030605000606,
    0x000f010709030404, 0x000516190a051c0d, 0x00391b1100361436,
    0x005b3d63055e680e, 0xff6e16be0a97b038, 0x44f26e920eb8905c,
    0xb8a088d03420e068, 0xd8e0d860583060b8, 0x9070a0b090208020,
    0xa080e080a020c020, 0x000040c000c080c0, 0x0000800000008000,

    0x0001010101010100, 0x0301010201020100, 0x0407020307060700,
    0x08090c0109040600, 0x190e14060e1c1f00, 0x1e04270b371b2500,
    0x735d690c19296f00, 0x61a54d082dc246ff, 0xf6bad2083242de00,
    0x5820ac3cec7ca400, 0xa830e01030c0e800, 0xc0e04020e080b000,
    0x4060c0206080c000, 0x408080c080c08000, 0x8080800080008000,
    0x0000010101010001, 0x0000000300000300, 0x0005070502020707,
    0x0000000f0f0f0f00, 0x001a1e111a0b041e, 0x003c3c3c3f3f0f3c,
    0x0058555a0f2d5700, 0xffff0fff00fff00f, 0xee0ef40a5ae04a4e,
    0xfcfc00fcc03c00cc, 0x70f0a8f820a88050, 0x00f00000f0f000f0,
    0xa04040a0a0e00040, 0x00c00000c0000000, 0x0000800080800080,

    0x0000010101010100, 0x0000010201020100, 0x0000020302060700,
    0x0f0f0c0103040600, 0x00110517050d0e00, 0x3021051a060a3400,
    0x45325a2e0e5e4d00, 0x7ae35cc4045b75ff, 0x8a64b44c1cac9a00,
    0xc08424782838e000, 0x50d8689838486000, 0x505040201080b000,
    0xa0a0c0206080c000, 0x000080c080c08000, 0x0000800080008000,
    0x0000000100010100, 0x0003030100010203, 0x0001040300030201,
    0x000104020f020c0e, 0x0003180711070403, 0x003e1c0622060b3e,
    0x0012605f270a5917, 0xffec7fa93603aee9, 0x1024c0be5e14b23e,
    0x10c84018a8282ce8, 0x60588068f8287028, 0x8050008060c090c0,
    0xc0a000c0e040e040, 0x4000004080808080, 0x8000008080808080,

    0x0100010101010100, 0x0100020202020100, 0x0205060303060700,
    0x0c0a0b0101040600, 0x050b1c17060d0e00, 0x36312b1a380a3400,
    0x1e42392e1d5e4d00, 0xd483123bd5a48aff, 0x3c84624c2aac9a00,
    0xe8c4bc78f038e000, 0x6808909810486000, 0x40f0d0202080b000,
    0xc00020202080c000, 0x8000c0c0c0c08000, 0x8000000000008000,
    0x0001010001010001, 0x0000000303000000, 0x0003060600030006,
    0x000c03000c0c0f03, 0x001a1e181d0b1b0f, 0x00300f0c3c300c3c,
    0x0005633d53363e36, 0xff303fc0ccfcccf3, 0xba6eecbe3ac4a4de,
    0xfc00c000c000303c, 0x88d85838b08838d0, 0x30f0f0c030000030,
    0x604040a000006080, 0x00c0c000c000c000, 0x8000000080000000,

    0x0001000101010100, 0x0302000201020100, 0x0406050307060700,
    0x0804050106040600, 0x191c0b171f0d0e00, 0x2d1b321a250a3400,
    0x3729167b6f0b1800, 0xe93d2491b9f120ff, 0x7e422ce6de063000,
    0x947cc878a438e000, 0xa8c05898e8486000, 0xc080a020b080b000,
    0x4080a020c080c000, 0x40c000c080c08000, 0x8000000080008000,
    0x0000010000000101, 0x0003020003000102, 0x0005030005050303,
    0x00060d0f060a010d, 0x000e17151f1f0606, 0x0008261919263b04,
    0x00086e3b6e6e5d08, 0xff0077eebb7766ff, 0x541088329888fe54,
    0x98100020dc30a8a8, 0xb86000606050e8e8, 0x10b0008040908070,
    0x608000c0c0a0c080, 0x80c0008040008000, 0x8000008080008000,

    0x0101000101010100, 0x0102030202020100, 0x0203010306060700,
    0x0c01020104040600, 0x050612171c0d0e00, 0x050b1c1a1b0a3400,
    0x0f59757b7c0b1800, 0xf6a26a6e970edfff, 0x1ea2fae6e8063000,
    0x243c50787c38e000, 0x6810a098c0486000, 0x402030208080b000,
    0xc02040208080c000, 0x80c040c0c0c08000, 0x8000800000008000,
    0x0001010100010101, 0x0003000300030300, 0x0005020005000002,
    0x0000000f0f000f00, 0x000f051a15140b14, 0x00030030333c0300,
    0x00580a555800007d, 0xff00fff0f0ff0f00, 0xfeb4fa1a04ae0aea,
    0xfcccccfccc3c30cc, 0x50f0788880707058, 0x00f0f0000000f0f0,
    0xe000004000a04040, 0x000000c00000c000, 0x8000000000000080,

    0x0001000101000000, 0x0001000201000300, 0x0507000607050100,
    0x05090f0b09050200, 0x1a1f111c1f0b0300, 0x2315122b26320d00,
    0x612a236c3b430200, 0xbd3cc1b81e710cff, 0xc25446c876861400,
    0x8c6448bca8c81400, 0xd0b8d890b8582800, 0xa0e050d0e0a03000,
    0xa060a02060a04000, 0x008000c080004000, 0x0080000080008000,
    0x0000000000000001, 0x0003030300000002, 0x0001040400050002,
    0x000104040f050f0c, 0x00031908011a1014, 0x000d2d0f0113231b,
    0x0006765456342139, 0xff07675458243e21, 0x001cfcb8ac684262,
    0x0014941c044c8c7c, 0x0038e86058d0d0c0, 0x0020808050a05040,
    0x0060c0c0a0a0a080, 0x00404040000000c0, 0x0080808000000000,

    0x0100010101000000, 0x0103010202000300, 0x0704070603050100,
    0x0607060b0e050200, 0x1f080e1c170b0300, 0x160c342b19320d00,
    0x7e054d6c7a430200, 0x640a8a479c8ef3ff, 0xfc1a9ac8e4861400,
    0x6810e0bc74c81400, 0xe8706090c8582800, 0xb090b0d070a03000,
    0xc0e0c02080a04000, 0x804080c0c0004000, 0x8080800000008000,
    0x0001000001010100, 0x0000030000000000, 0x0003030503030305,
    0x00030000030c0c00, 0x0001170e010a1b0e, 0x000c0f033f300303,
    0x005b350b6865305e, 0xfff3ccf00c00ccf0, 0xaa50a2a69c8ebc48,
    0xccfc0cfcccf00cfc, 0x880858b0b0b86068, 0xf030f0f0c0f030f0,
    0xa06040c0a0c0e020, 0xc000c0000000c000, 0x8080008000800000,

    0x0100010100000000, 0x0100020203000300, 0x0705030601050100,
    0x0905010b02050200, 0x0e1a171c030b0300, 0x0410292b3e320d00,
    0x08256a3946165700, 0x0f35b3ed7bdb59ff, 0x104ac4629c2cbe00,
    0x2040b4bcd8c81400, 0x30d0989028582800, 0xe0a020d030a03000,
    0x60a0202040a04000, 0x8000c0c040004000, 0x8000000080008000,
    0x0001010000010100, 0x0001020000010203, 0x0003060505060300,
    0x000e080a05040203, 0x00020d1f1a0c1215, 0x000009252c071f16,
    0x00505b6e3558603e, 0xff5f5e7bd5ac4318, 0x44b4b2986ae0d47c,
    0x88e8d02c4c7c64a8, 0xd83860308080b8b8, 0x5020b02000c020d0,
    0xa020802000002060, 0xc0c0c0c000c0c040, 0x0000000000000080,

    0x0101000100000000, 0x0102030200000300, 0x0206040605050100,
    0x030b080b05050200, 0x140d081c0b0b0300, 0x17090f2b01320d00,
    0x790a043907165700, 0x62fcf8120624a6ff, 0xf20418620e2cbe00,
    0x6c341cbc04c81400, 0xb018209058582800, 0x10d0c0d0a0a03000,
    0x60204020a0a04000, 0x80c040c000004000, 0x8000800000008000,
    0x0001000001000000, 0x0003000000030303, 0x0000050507070202,
    0x0000000f000f0f00, 0x00051b051f151f01, 0x003f3c000c0f003c,
    0x00255a0f72757a7a, 0xfffffff0f000fff0, 0xeef01afe14fe0a44,
    0xcc3cfcfc00c00cc0, 0x5088d80028280808, 0x00f0f0f0f0f0f000,
    0xa0a000a0a0a0e000, 0xc000c000c0c0c000, 0x8000800080800000,

    0x0100010100000000, 0x0100020203000300, 0x0705030601050100,
    0x0905010b02050200, 0x0e0b170d121a1200, 0x04011a3a2f231c00,
    0x08522e1b64617500, 0xf0533bdeb7bd95ff, 0x10a44c26d8c2fa00,
    0x200478f89c8c5000, 0x30589818a0d0a000, 0xe0a020d030a03000,
    0x60a0202040a04000, 0x8000c0c040004000, 0x8000000080008000,
    0x0001010000010100, 0x0001020000010203, 0x0003020505060704,
    0x00020c0a0508060b, 0x0007040b0b1d0f08, 0x00063b0232260a3c,
    0x000f4902122f5a10, 0xff06b1fc1336a3e0, 0x101e8214245ea430,
    0x2018fc28c89838d0, 0x2038107808b81830, 0xc020e060f0d0e0d0,
    0x406020e000602060, 0x8040c0800040c040, 0x8080008000800080,

    0x0101000100000000, 0x0102030200000300, 0x0206040605050100,
    0x030b080b05050200, 0x051c080d1a1a1200, 0x35183c3a10231c00,
    0x1f28401b70617500, 0x26cf8f2160426aff, 0x3e409026e0c2fa00,
    0xe470d0f8408c5000, 0x38902018d0d0a000, 0x10d0c0d0a0a03000,
    0x60204020a0a04000, 0x80c040c000004000, 0x8000800000008000,
    0x0001000001000000, 0x0003000000030303, 0x0000050503030606,
    0x000c000f0c0f0f00, 0x001c0f140a1c0219, 0x003c333c3300000f,
    0x00503800663d503d, 0xffcffc30f03f0fc3, 0xba2acc602814eab8,
    0xcccc0c003ccc3c00, 0xe88880d038e0b830, 0x30f00000f03000c0,
    0xe0a000e0c0e060a0, 0xc0c0000000c0c000, 0x0080008080000000,

    0x0001000101000000, 0x0001000201000300, 0x0507000607050100,
    0x05090f0b09050200, 0x0b1f110d1f1a1200, 0x3215213a26231c00,
    0x162a324e3b342000, 0xdbc31c8be117c0ff, 0x2c54648c76685000,
    0xc86484f8a88c5000, 0x58b8d818b8d0a000, 0xa0e050d0e0a03000,
    0xa060a02060a04000, 0x008000c080004000, 0x0080000080008000,
    0x0000000000000001, 0x0003030300000002, 0x0005000000050006,
    0x00090c0c0f050f08, 0x000a0110040b151d, 0x00003e1c380d1a29,
    0x000053355d536e6b, 0xfff092e595aeb78e, 0x5450b23aaaf288d2,
    0xa8901c2c3c60f090, 0xb8b0303000b050e0, 0xd0e0e02030209040,
    0x602020204020a0c0, 0x400000c040c00040, 0x8000000080000080,

    0x0100010101000000, 0x0103010202000300, 0x0704070603050100,
    0x0607060b0e050200, 0x1f080e0d171a1200, 0x250c073a19231c00,
    0x6f505c4e2f342000, 0x46a0a874c9e83fff, 0xdeb0b88c4e685000,
    0xa4102cf8748c5000, 0xe8706018c8d0a000, 0xb090b0d070a03000,
    0xc0e0c02080a04000, 0x804080c0c0004000, 0x8080800000008000,
    0x0001000001010100, 0x0000030000000000, 0x0007070507070705,
    0x000f00000f000000, 0x00111b1a111f0e1a, 0x0000330c330f3c0c,
    0x0022502d55752078, 0xfff0f0ff0f0000ff, 0xfea404a4f0ee001e,
    0xccc0fcf00cc0f00c, 0x7088a0a8f858a070, 0x00f0000000f0f0f0,
    0xe0e00000e040e000, 0xc0c0c0c0c0000000, 0x0000808000808000,

    0x0000000101000000, 0x0000030202000300, 0x0505040603050100,
    0x050a080b01050200, 0x0b1a190d060b1200, 0x32131e090b012f00,
    0x4371260a0c073100, 0x8e6dcb03f7f9e2ff, 0x86e25c04080e7200,
    0xc84c58343c049c00, 0x5880a8181058a000, 0xa0f0c0d020a03000,
    0xa000402020a04000, 0x000040c0c0004000, 0x0000800000008000,
    0x0001010001010000, 0x0001010301010303, 0x0006060106030401,
    0x000707010702040e, 0x000d1c121c160913, 0x0036271c14170e2d,
    0x004f2935386c5223, 0xffb9312adf7b5332, 0x008e526a70c8b456,
    0x30c8ac70504c1894, 0x4008f090b08038b8, 0x40f060e0d0002020,
    0x8000e02060006060, 0xc00080c040004040, 0x0000800080008080,

    0x0001010101000000, 0x0002020201000300, 0x0506030607050100,
    0x0a04010b06050200, 0x1a1c060d1f0b1200, 0x131b380925012f00,
    0x247c1d0a3a073100, 0x3868d5fc13061dff, 0x48e82a04740e7200,
    0x4c7cf034a4049c00, 0x80c01018e858a000, 0xf08020d0b0a03000,
    0x00802020c0a04000, 0x00c0c0c080004000, 0x0000000080008000,
    0x0001000100000000, 0x0000000303030300, 0x0006050506060300,
    0x000c0f030f000f0f, 0x0004150913181c1a, 0x00033c30303c333f,
    0x005e5366060d0b0b, 0xff0f3c0c33c0cf3f, 0xaaf28a846ecedc6c,
    0xfc0030f03cf0c030, 0xe8e030e8e03868e8, 0xf0c000000000c0f0,
    0x2040608080604020, 0x0000c0c0c0c00000, 0x0080008080008000,

    0x0001010100000000, 0x0001010200000300, 0x0507070605050100,
    0x0a06060b0a050200, 0x0b1f1f0d1a0b1200, 0x0216250913012f00,
    0x062b3a5f24526400, 0xf4ce1356c753b7ff, 0x0c5674ae48a4d800,
    0x0868a4344c049c00, 0x08e8e8188058a000, 0xf0b0b0d0f0a03000,
    0x00c0c02000a04000, 0x008080c000004000, 0x0080800000008000,
    0x0000010101010101, 0x0000020102010101, 0x0005030606030603,
    0x000a020b07010b01, 0x000f131919070807, 0x00361e1e110a0f0a,
    0x000e3666630e005b, 0xffc8e747bef8fcad, 0x440c28d8925c50e6,
    0xb8c80050d0a8ac74, 0xd85800b060e8b0d8, 0x905000e0b0802060,
    0xa0a0002080c020e0, 0x00c00000c080c080, 0x0000000000800080,

    0x0100000100000000, 0x0103000203000300, 0x0204000601050100,
    0x0c080f0b0d050200, 0x0519000d030b1200, 0x051e03093d012f00,
    0x5a26015f12526400, 0xa3340da9dcac48ff, 0xb45c02ae34a4d800,
    0x24580c34d4049c00, 0x68a850187858a000, 0x40c050d060a03000,
    0xc040a020e0a04000, 0x804000c040004000, 0x8080000080008000,
    0x0000000001000001, 0x0000030003000303, 0x0005020505000200,
    0x000f0f0f000f0f0f, 0x00040f150f0f0f0b, 0x00033330033f0033,
    0x005a785a0d750f75, 0xff0f0ff00f0ff000, 0xeeaeaa1410a0febe,
    0xfcc030c00c0cfc30, 0x708870a878085058, 0x00f00000f0f000f0,
    0xa0e0a04000e0e000, 0x00c0000000c000c0, 0x0000008000008080,

    0x0001010100000000, 0x0001010200000300, 0x0507070605050100,
    0x0a06060b0a050200, 0x1a1f1f1c0b1a0300, 0x2025161831103e00,
    0x603a2b7d42254600, 0x4fec31657c357bff, 0xc07456ea844a9c00,
    0x80a46870c440d800, 0x80e8e89008d02800, 0xf0b0b0d0f0a03000,
    0x00c0c02000a04000, 0x008080c000004000, 0x0080800000008000,
    0x0000010101010101, 0x0000020102010101, 0x0005070602030603,
    0x000a0607030d070d, 0x001b0e0d15071c07, 0x00110b061a351735,
    0x00660c5a3a1e3c4b, 0xff870b5cdce82bbd, 0x10dc08a4743c7886,
    0x10640c3868d45cf4, 0x60f85018f868e048, 0x8090a0e060808040,
    0xc0e0a020e0c0c080, 0x408000c0804040c0, 0x8080000080808000,

    0x0100000100000000, 0x0103000203000300, 0x0204000601050100,
    0x0c080f0b0d050200, 0x1419001c121a0300, 0x142d30181f103e00,
    0x2d62107d21254600, 0x3a43d09acdca84ff, 0x5ad420ea524a9c00,
    0x6094c0705c40d800, 0xe0a85090f0d02800, 0x40c050d060a03000,
    0xc040a020e0a04000, 0x804000c040004000, 0x8080000080008000,
    0x0000000001000001, 0x0000030003000303, 0x0005060505000600,
    0x000f0f0f0c0f0f03, 0x00151204020a1217, 0x003f330c0f0c0003,
    0x005556555e58656d, 0xffc33ff0f000c033, 0xba28924e48e05ef8,
    0xfcc030f0fc0000c0, 0x88d0006838d0e830, 0x30f0300000f030c0,
    0x604060806040e0a0, 0x00c000c0c0c0c000, 0x8000808000000000,

    0x0000000101000000, 0x0000030202000300, 0x0505040603050100,
    0x050a080b01050200, 0x1a0b191c061a0300, 0x23312d1838103e00,
    0x3417622848701300, 0xe8d6bc307f9f2eff, 0x682ed44080e03600,
    0x8cc49470f040d800, 0xd008a89010d02800, 0xa0f0c0d020a03000,
    0xa000402020a04000, 0x000040c0c0004000, 0x0000800000008000,
    0x0001010001010000, 0x0001010301010303, 0x0006060506030005,
    0x000b0b090b0e0c06, 0x0019081b0813111f, 0x002e3f110c111d19,
    0x003355330033336e, 0xff22661100eeee44, 0x5422fe76102222cc,
    0x98fca8a820003044, 0xb850e8b8305050d8, 0x10907020d0a09050,
    0x60a0802060e0a0a0, 0x800000c0404000c0, 0x8000000080800000,

    0x0001010101000000, 0x0002020201000300, 0x0506030607050100,
    0x0a04010b06050200, 0x0b0d061c1f1a0300, 0x31390b1816103e00,
    0x424f59282b701300, 0x83865dcf3160d1ff, 0x848ea24056e03600,
    0xc4f43c706840d800, 0x08481090e8d02800, 0xf08020d0b0a03000,
    0x00802020c0a04000, 0x00c0c0c080004000, 0x0000000080008000,
    0x0001000100000000, 0x0000000303030300, 0x0002050502020700,
    0x00000f0f0f000f0f, 0x000504010e00151f, 0x0033000f300f3c0c,
    0x00285858280a0722, 0xff00f0f00ffff0f0, 0xfe0440540eeebea4,
    0xfcfc000cccc00cc0, 0x50f0d0a0800820d8, 0x00000000f0f00000,
    0xe0a0a040e0e040a0, 0x0000c000c0c000c0, 0x8000808000008080,

    0x0001000101000100, 0x0001000101000200, 0x0007050707050300,
    0x0f090506090a0100, 0x111f1a1f1f1a0600, 0x1215231626130b00,
    0x762a617e3b710c00, 0x6b3c42641e9208ff, 0xec54c2fc76e20800,
    0x48648c68a84c3c00, 0xd8b8d0e8b8801000, 0x50e0a0b0e0f02000,
    0xa060a0c060002000, 0x008000808000c000, 0x0080008080000000,
    0x0001010000000001, 0x0002010300000001, 0x0002060405050006,
    0x000308040a0a0f08, 0x00040d080a1b100d, 0x000b360f03212336,
    0x00094f540426211a, 0xff0eb954f4383e13, 0x00029eb8084c4234,
    0x003ce81c0c848ce8, 0x001028600088d028, 0x0010c080f0f050c0,
    0x002040c00000a040, 0x00c0804000000080, 0x0000808000000080,

    0x0000000100000100, 0x0300030103000200, 0x0405010701050300,
    0x07050206020a0100, 0x081a031f031a0600, 0x0c103e163e130b00,
    0x0525137e46710c00, 0x0a35d19b7b6df7ff, 0x1a4a36fc9ce20800,
    0x1040d868d84c3c00, 0x70d028e828801000, 0x90a030b030f02000,
    0xe0a040c040002000, 0x400040804000c000, 0x8000808080000000,
    0x0000000000010101, 0x0003030000000000, 0x0003060500060303,
    0x000f00000f0c0c0c, 0x001c191f1a150a1b, 0x00000c033c330303,
    0x006d3e3858085630, 0xffc0c3c33f3cffcc, 0xaa5eaeb68a7c42bc,
    0xcc303c300c0cc00c, 0x8888600858e00060, 0xf0c0f0c000c00030,
    0xa0c020c0e04000e0, 0xc0c000c0000000c0, 0x8000000080800000,

    0x0001010100000100, 0x0302010100000200, 0x0106020705050300,
    0x020b0c06050a0100, 0x030d051f0b1a0600, 0x3e09051601130b00,
    0x130a5a2b07245900, 0xd1fc5c3106385dff, 0x3604b4560e48a200,
    0xd8342468044c3c00, 0x281868e858801000, 0x30d040b0a0f02000,
    0x4020c0c0a0002000, 0x40c080800000c000, 0x8000808000000000,
    0x0000000001010001, 0x0003000001010302, 0x0000000503030006,
    0x000c0f05010e0308, 0x0010140b0713150d, 0x001f2b0e09221609,
    0x00303d535e363e0e, 0xffe3d9a2a4d7e7f4, 0x44247ae2ec78385c,
    0x8804507c44502094, 0xd858e0d0d8b060e8, 0x5050b090a0e08040,
    0xa0a080a0e020c0c0, 0xc0c0c00040008040, 0x0000000080008080,

    0x0000010101000100, 0x0303020102000200, 0x0104060703050300,
    0x0d070b060e0a0100, 0x03081c1f171a0600, 0x3d0c181619130b00,
    0x1205282b7a245900, 0xdc0acfce9cc7a2ff, 0x341a4056e448a200,
    0xd4107068744c3c00, 0x787090e8c8801000, 0x6090d0b070f02000,
    0xe0e020c080002000, 0x4040c080c000c000, 0x8080008000000000,
    0x0001010001000100, 0x0003030003030000, 0x0000000500020705,
    0x000f0f000f0f000f, 0x001b1b0a0a0e1f05, 0x0003300f03003f00,
    0x0070520f5258505a, 0xff0f0f00f0fff0f0, 0xeefaea1a405e0454,
    0xccf03c000c3ccc30, 0x5000a870d88080d8, 0x00f0f000f0f0f000,
    0xa0a0e0e040a0e0e0, 0xc00000c00000c000, 0x8000800080000080,

    0x0000010101000100, 0x0000010102000200, 0x0005020703050300,
    0x0f0a0c06010a0100, 0x111a140e060b1700, 0x211327070b021a00,
    0x677169090c537b00, 0x496d4d02f75e91ff, 0xcee2d21208a6e600,
    0x844cac2c3c087800, 0xd880e06010089800, 0x50f040b020f02000,
    0xa000c0c020002000, 0x00008080c000c000, 0x0000808000000000,
    0x0000010000010001, 0x0003020303020302, 0x0001070101020407,
    0x000e09010e030409, 0x00030f121215191e, 0x003d091c2c292e2b,
    0x00465b65757b2279, 0xffb7a27a6a6dc391, 0x109ca6caeaf654e2,
    0x20e43440809498bc, 0x202818d080b8b8c0, 0xc0c010a0f020d040,
    0x404020a000606080, 0x8080c000004040c0, 0x8080000000808000,

    0x0001010100000100, 0x0001020100000200, 0x0507060705050300,
    0x05060b060a0a0100, 0x0b1f0d0e1a0b1700, 0x01163a0713021a00,
    0x522b1b0924537b00, 0xacce21fdc7a16eff, 0xa456261248a6e600,
    0x0468f82c4c087800, 0x58e8186080089800, 0xa0b0d0b0f0f02000,
    0xa0c020c000002000, 0x0080c0800000c000, 0x0080008000000000,
    0x0000000101010100, 0x0000030303000303, 0x0005060005030006,
    0x000f0f030c0c030f, 0x00050207020a1613, 0x000f33000f333333,
    0x0000630e5b660e50, 0xfffc0f03fff030c3, 0xbaac9c0e5c287826,
    0xccccc00cf03c0cf0, 0xe8d0b8000838e8b8, 0x30f0c0f0c0f030f0,
    0xe040a0a0c0c0e0c0, 0xc0c000c0c000c000, 0x0000008000800080,

    0x0000000100000100, 0x0303000103000200, 0x0404050701050300,
    0x080805060d0a0100, 0x08190b0e030b1700, 0x0f1e01073d021a00,
    0x5126075c12062e00, 0x52340657dcf4c4ff, 0xb25c0eb8340c4c00,
    0x1c58042cd4087800, 0x20a8586078089800, 0xc0c0a0b060f02000,
    0x4040a0c0e0002000, 0x404000804000c000, 0x8080008080000000,
    0x0000010000000000, 0x0000010003000303, 0x0000030505050005,
    0x000f010509050306, 0x0015170b0a0b050e, 0x001a1a3e333e060b,
    0x003b6b0600535b5d, 0xffe24dc8c36252a9, 0x5422c61c14e2b2ea,
    0xa80c44d8d48cdc40, 0xb800d86838806080, 0xd0f050b01000b0f0,
    0x6040a08060008040, 0x4080c0c08000c080, 0x8080000080000080,

    0x0001000101000100, 0x0002030101000200, 0x0506010707050300,
    0x05040206060a0100, 0x0b1c120e1f0b1700, 0x321b1c0725021a00,
    0x167c755c3a062e00, 0x24686aa8130b3bff, 0x2ce8fab8740c4c00,
    0xc87c502ca4087800, 0x58c0a060e8089800, 0xa08030b0b0f02000,
    0xa08040c0c0002000, 0x00c040808000c000, 0x0000808080000000,
    0x0001000101010000, 0x0003000300030300, 0x0000050507000705,
    0x0000000f00000f00, 0x00151a011f04040b, 0x003c3f0c0f3c0f0c,
    0x00075a0a7570075a, 0xfff0ff00000fffff, 0xfeae0e14eeaee45a,
    0xcc0cf030c00cfc3c, 0x7000a80858502088, 0x0000f0f0f000f000,
    0xe000e0a040a0e040, 0xc000000000c000c0, 0x0000800080808000,

    0x0001010100000100, 0x0001020100000200, 0x0507060705050300,
    0x05060b060a0a0100, 0x1a1f1c0e0b1a1700, 0x10252b3431202900,
    0x253a391842353f00, 0xcaec12df7c1ae6ff, 0x4a746230846a6e00,
    0x40a4bce0c480b400, 0xd0e8906008809800, 0xa0b0d0b0f0f02000,
    0xa0c020c000002000, 0x0080c0800000c000, 0x0080008000000000,
    0x0000000101010100, 0x0000030101020103, 0x0005040603070604,
    0x00050b070206070b, 0x000a190d071f1c08, 0x00031d36352a273f,
    0x0001331a4e7a7c44, 0xff0e2dec486c9b4b, 0x000276348ce4e888,
    0x303c64d8c4888cfc, 0x4010a86858d8d010, 0x4010c070a050a0e0,
    0x802040c0a0a0a020, 0xc0c08040000000c0, 0x0000808000000000,

    0x0000010101000100, 0x0000010102000200, 0x0005020703050300,
    0x0f0a0c06010a0100, 0x110b050e061a1700, 0x1231363438202900,
    0x76171e1848353f00, 0x94d6d4207fe519ff, 0xec2e3c30806a6e00,
    0x48c4e8e0f080b400, 0xd808686010809800, 0x50f040b020f02000,
    0xa000c0c020002000, 0x00008080c000c000, 0x0000808000000000,
    0x0000010000010001, 0x0003000303000300, 0x0003030303060603,
    0x0000030f00030003, 0x0017110d060f0900, 0x003f3f330c3c0f3f,
    0x0055586d00660d3e, 0xffc33303f0030c00, 0xaa288688b09e0278,
    0xfcf030f0f0fc0cfc, 0xe8e068b080800858, 0xf0f0000030c0f030,
    0x2020806060c0a080, 0x0000c0c000c0c000, 0x0000800080008000,

    0x0001000101000100, 0x0002030101000200, 0x0506010707050300,
    0x05040206060a0100, 0x1a0d030e1f1a1700, 0x23390d3416202900,
    0x614f574d2b606a00, 0x4286a68a31b0b3ff, 0xc28ebe9a56c0c400,
    0x8cf414e06880b400, 0xd0482860e8809800, 0xa08030b0b0f02000,
    0xa08040c0c0002000, 0x00c040808000c000, 0x0000808080000000,
    0x0001000101010000, 0x0001000102010300, 0x0006050303060505,
    0x00040a010204090a, 0x001c1e07020d1b0f, 0x002714393c052205,
    0x0068680e055b630e, 0xff7c40343aa18204, 0x4490c05c5ee6c20c,
    0xb82c40645478bc04, 0xd86080e8e8888058, 0x9070f070403030a0,
    0xa0804080c04040e0, 0x0000800040404040, 0x0000800080808080,

    0x0000000100000100, 0x0303000103000200, 0x0404050701050300,
    0x080805060d0a0100, 0x08191a0e121a1700, 0x3c2d10341f202900,
    0x1562704d21606a00, 0x25436075cd4f4cff, 0x3ad4e09a52c0c400,
    0xd09440e05c80b400, 0x20a8d060f0809800, 0xc0c0a0b060f02000,
    0x4040a0c0e0002000, 0x404000804000c000, 0x8080008080000000,
    0x0000010000000000, 0x0000030003000303, 0x0000050507050207,
    0x000f0f0f0f0f0f00, 0x001e110415041e1a, 0x003f0f303c300003,
    0x00022d2d02782d22, 0xff0ffff0f0f0f0ff, 0xee4eb0faa440aabe,
    0xfcc0cc0c30c0fcf0, 0x7008a8a82850a8d8, 0x000000f000000000,
    0xa00040a000a000e0, 0x000000c0c0c0c000, 0x0000808080808080,

    0x0000000100000100, 0x0300030103000200, 0x0405010701050300,
    0x07050206020a0100, 0x080b121f120b0600, 0x0c012f252f313800,
    0x5052316f64174800, 0xa0531db9b7d67fff, 0xb0a472ded82e8000,
    0x10049ca49cc4f000, 0x7058a0e8a0081000, 0x90a030b030f02000,
    0xe0a040c040002000, 0x400040804000c000, 0x8000808080000000,
    0x0000000000010101, 0x0003030000020202, 0x0001040500020707,
    0x0001040a0f0c0606, 0x0003091b11041f0e, 0x000d0d22110b1a38,
    0x00035322630c6a48, 0xfffda23c72fb83b0, 0x1006b654c608c480,
    0x10041498440c78f0, 0x600838e88850c840, 0x80002080f05040b0,
    0xc00060c000a08080, 0x400040400000c0c0, 0x8000808000000000,

    0x0001000101000100, 0x0001000101000200, 0x0007050707050300,
    0x0f090506090a0100, 0x111f0b1f1f0b0600, 0x2115322526313800,
    0x672a166f3b174800, 0xb6c32446e12980ff, 0xce542cde762e8000,
    0x8464c8a4a8c4f000, 0xd8b858e8b8081000, 0x50e0a0b0e0f02000,
    0xa060a0c060002000, 0x008000808000c000, 0x0080008080000000,
    0x0001010000000001, 0x0000030300000003, 0x0006000605050000,
    0x00030c0000000f0c, 0x001e0c180e1f1b0c, 0x003c0f0c00000c0f,
    0x0050063d583e3e53, 0xffc0ff3f0fc333ff, 0xba20b204fabe1e5c,
    0xfcf0c0fc3c0cccf0, 0x88b0b0b08860b008, 0x30f0c0f0c03030c0,
    0x60c0a0c0c0e000c0, 0x00000000c0c0c0c0, 0x8080008000008000,

    0x0000010101000100, 0x0303020102000200, 0x0104060703050300,
    0x0d070b060e0a0100, 0x12080d1f170b0600, 0x1f0c092519313800,
    0x21500a3a2f421d00, 0xcda0fcecc97c2aff, 0x52b004744e842a00,
    0x5c1034a474c4f000, 0xf07018e8c8081000, 0x6090d0b070f02000,
    0xe0e020c080002000, 0x4040c080c000c000, 0x8080008000000000,
    0x0001010001000100, 0x0001010001030200, 0x0006060506000305,
    0x000b0b0a0b030205, 0x0019190e0815020a, 0x001d2e043f260c0c,
    0x0066665d006e0055, 0xff448855337700aa, 0x54ccccba449800ee,
    0x987488ec44203074, 0xb888d830d86000d8, 0x1030a0d050703090,
    0x6040e060a08040a0, 0x80404040c0004000, 0x8080808000008000,

    0x0001010100000100, 0x0302010100000200, 0x0106020705050300,
    0x020b0c06050a0100, 0x121c141f1a0b0600, 0x2f18142510313800,
    0x31282d3a70421d00, 0x1dcfc5136083d5ff, 0x72405a74e0842a00,
    0x9c7060a440c4f000, 0xa090e0e8d0081000, 0x30d040b0a0f02000,
    0x4020c0c0a0002000, 0x40c080800000c000, 0x8000808000000000,
    0x0000000001010001, 0x0003000003030300, 0x0002000505050202,
    0x00000f0f0f000f00, 0x00001f04011e0e14, 0x003c0c003c303033,
    0x007d22587a0d280a, 0xff00f0f0f0000fff, 0xfebaa440545a0ebe,
    0xfc0cc000c0fccc00, 0x5078d8d078588028, 0x00f00000f000f0f0,
    0xe000a0a000e0e0a0, 0x0000c0c00000c0c0, 0x8000808000800080,

    0x0101000101010000, 0x0102000102020000, 0x0703050206060500,
    0x06010a0c040b0500, 0x1f060b141c0d0b00, 0x160b31141b090100,
    0x2b59422d7c0a0700, 0x315d83c568fc06ff, 0x56a2845ae8040e00,
    0x683cc4607c340400, 0xe81008e0c0185800, 0xb020f04080d0a000,
    0xc02000c08020a000, 0x80c00080c0c00000, 0x8000008000000000,
    0x0000000001000001, 0x0000030301000301, 0x0005040103000403,
    0x00050b01020f040d, 0x000b091216010817, 0x00020e2f24320f25,
    0x000702712d12542e, 0xff06f3613a1cabc8, 0x000e14f25a24b85c,
    0x0008189ca0c81ca4, 0x005838b0a05860f8, 0x00a0d02030508060,
    0x00a0606040a0c0e0, 0x0000404080004080, 0x0000808080008080,

    0x0101010100010000, 0x0201010100020000, 0x0607020205060500,
    0x0b06030c0a0b0500, 0x1c1f14141a0d0b00, 0x2b16241413090100,
    0x6c7e682d710a0700, 0x479bbf3a6d03f9ff, 0xc8fcd05ae2040e00,
    0xbc68a0604c340400, 0x90e8b0e080185800, 0xd0b01040f0d0a000,
    0x20c060c00020a000, 0xc080808000c00000, 0x0080808000000000,
    0x0001010001010001, 0x0003030303000000, 0x0000000600060003,
    0x00030300030c0f03, 0x0016161907041a01, 0x0003300c03003c3f,
    0x003b083e5d5d5868, 0xff3f3fc3f30f3f0c, 0xaa1c7aae48e48a9c,
    0xccf00c3cf03c0ccc, 0x8888b86060b058b0, 0xf0c0c0f000f000c0,
    0xa0c0a02080c0e0a0, 0xc0c00000c0000000, 0x8000000080808000,

    0x0101010101010000, 0x0102020101020000, 0x0706060207060500,
    0x0604040c060b0500, 0x0e0d1c141f0d0b00, 0x07391b1416090100,
    0x5c4f7c782b5f5200, 0x57796890ce5653ff, 0xb88ee8f056aea400,
    0x2cf47c6068340400, 0x6048c0e0e8185800, 0xb0808040b0d0a000,
    0xc08080c0c020a000, 0x80c0c08080c00000, 0x8000008080000000,
    0x0001010101000100, 0x0002020101030103, 0x0003060606050605,
    0x0002070b04090b09, 0x000319180c0a180a, 0x000e111f34332c33,
    0x0006333058056550, 0xff071eec60c97563, 0x44087220f00a9ae4,
    0x8800903ca0c02c84, 0xd850b050e0006088, 0x50a0e090800070f0,
    0xa0e020a0c0008040, 0xc040000080000080, 0x0080000080000080,

    0x0001000100010000, 0x0301030103020000, 0x0102010204060500,
    0x02030d0c080b0500, 0x12140314190d0b00, 0x2f240e141e090100,
    0x31685678265f5200, 0xe240546f34a9acff, 0x72d0bcf05caea400,
    0x9ca0186058340400, 0xa0b078e0a8185800, 0x30106040c0d0a000,
    0x4060e0c04020a000, 0x4080408040c00000, 0x8080808080000000,
    0x0000010001010101, 0x0003030300030303, 0x0002050202050500,
    0x000f000f000f000f, 0x001f0f1f15001e1b, 0x00330300303f3030,
    0x00585d2f5f7f0807, 0xffffff000f0f000f, 0xee1a504ef0a45040,
    0xccc03c0c000cc0f0, 0x50a08880a0502070, 0x00f00000f0f0f000,
    0xa0a04000a040a0a0, 0xc0c0c000c000c000, 0x8080000080808000,

    0x0101010100010000, 0x0201010100020000, 0x0607020205060500,
    0x0b06030c0a0b0500, 0x0d1f05050b1c1a00, 0x3a25060531181000,
    0x4e6f0e5a17287000, 0x74b9fba3d6309fff, 0x8cde1cb42e40e000,
    0xf8a42824c4704000, 0x18e838680890d000, 0xd0b01040f0d0a000,
    0x20c060c00020a000, 0xc080808000c00000, 0x0080808000000000,
    0x0001010001010001, 0x0001010301020002, 0x0006060406020007,
    0x00070704070c0f09, 0x000c0c191d15110f, 0x0007341d252a2109,
    0x005948337b2f235b, 0xffae40d262c6325d, 0x10a29076f64e46b6,
    0x200ce054a4888414, 0x200070e8f8d8d838, 0xc0f090706050a0d0,
    0x4000e0c0e0a0a060, 0x8000804080000040, 0x8000808080000080,

    0x0101000101010000, 0x0102000102020000, 0x0703050206060500,
    0x06010a0c040b0500, 0x1f061a050d1c1a00, 0x2538130539181000,
    0x3a1d245a4f287000, 0x13d5385c86cf60ff, 0x742a48b48e40e000,
    0xa4f04c24f4704000, 0xe81080684890d000, 0xb020f04080d0a000,
    0xc02000c08020a000, 0x80c00080c0c00000, 0x8000008000000000,
    0x0000000001000001, 0x0000030303000303, 0x0005060305000605,
    0x000f0f0f0c0f0003, 0x0014020d130a0819, 0x003c00003c0f3c00,
    0x0000505b0e0b3d36, 0xff300f0c33fff0cc, 0xba60eaea6eacceb4,
    0xcc003c000cf00000, 0xe8d0b8d0d0b8d868, 0x300000f0f0000030,
    0xe0e060404060e0e0, 0xc000c0c0c0c000c0, 0x0080000000008000,

    0x0001000100010000, 0x0301030103020000, 0x0102010204060500,
    0x02030d0c080b0500, 0x03051205191c1a00, 0x3e062c052d181000,
    0x130e650f627d2500, 0x2e0445f6439acaff, 0x361cda1ed4ea4a00,
    0xd828902494704000, 0x2838f068a890d000, 0x30106040c0d0a000,
    0x4060e0c04020a000, 0x4080408040c00000, 0x8080808080000000,
    0x0000010001010101, 0x0003010302010101, 0x0000030006030306,
    0x00030e0308010e0b, 0x001402140c061309, 0x001733243838223e,
    0x0068503d0d0d6303, 0xff439cdacac58d32, 0x54d4a06e1e1ac652,
    0xa8540c44e4dc846c, 0xb8b850d8686088e0, 0xd0e050a070400070,
    0x6020a0e080c00080, 0x4000c04000400000, 0x8000008000800000,

    0x0101010101010000, 0x0102020101020000, 0x0706060207060500,
    0x0604040c060b0500, 0x0e1c0d051f1c1a00, 0x341b390525181000,
    0x4d7c4f0f3a7d2500, 0x75978609ec6535ff, 0x9ae88e1e74ea4a00,
    0xe07cf424a4704000, 0x60c04868e890d000, 0xb0808040b0d0a000,
    0xc08080c0c020a000, 0x80c0c08080c00000, 0x8000008080000000,
    0x0001010101000100, 0x0000000303030303, 0x0007020000070007,
    0x00000f0f000f0f0f, 0x000e0b0a15150a15, 0x000f0c330f3c003c,
    0x00025a7225070552, 0xfffff0fff0000000, 0xfeee445ebe4e0af4,
    0xccc000f0f0fc3c00, 0x70088858d87028a8, 0x00f000f0000000f0,
    0xe0e00000e0a000a0, 0xc0c000c00000c0c0, 0x0000008080008080,

    0x0101010100010000, 0x0202020103020000, 0x0603060204060500,
    0x040e040c070b0500, 0x1c061c05080d1a00, 0x1b3b28360c3a2300,
    0x291c6d4b504e3400, 0xc2d84a7ea074e8ff, 0x4228ca96b08c6800,
    0x7cfcb0e810f88c00, 0xc040c0687018d000, 0x8070804090d0a000,
    0x808080c0e020a000, 0xc0c0c08040c00000, 0x0000008080000000,
    0x0000010100010101, 0x0003020203020202, 0x0001070701020207,
    0x000e09060e030306, 0x00130f0e0204040e, 0x002d39083c380b08,
    0x00761b5845480c0d, 0xff98eda045bf04f5, 0x00ec26a08a80181a,
    0x30b4c430c0c02c20, 0x4098084000507020, 0x40e0f0b0f0506030,
    0x8020008000a0e040, 0xc0c000c000008080, 0x0000000000008080,

    0x0101000101010000, 0x0201030101020000, 0x0607010207060500,
    0x0b090d0c090b0500, 0x1c0e03051f0d1a00, 0x2b373d36153a2300,
    0x3919124b2a4e3400, 0xed2d2381c38b17ff, 0x62323496548c6800,
    0xbcecd4e864f88c00, 0x90307868b818d000, 0xd0e06040e0d0a000,
    0x2060e0c06020a000, 0xc080408080c00000, 0x0080808080000000,
    0x0000000001000100, 0x0003000003030300, 0x0006000005060505,
    0x00000f0f030f030f, 0x00091a0b18020904, 0x003c0c0c3003303c,
    0x006b6d5e00066635, 0xff0c3ff33f00f30f, 0xaa9af45e7a082e74,
    0xfcc0fccc3c3c0cfc, 0xe8e00060d8380000, 0xf0c0c0c03000f030,
    0x2040c0408060a060, 0x0000c00000c0c000, 0x0080008000008080,

    0x0101000100010000, 0x0102000100020000, 0x0706050205060500,
    0x090b0a0c050b0500, 0x1f0d0b050b0d1a00, 0x26090236013a2300,
    0x6e5f061e521b6100, 0xb4560b2b53debdff, 0xdcae0c3ca426c200,
    0xa83408e804f88c00, 0xb81808685818d000, 0xe0d0f040a0d0a000,
    0x602000c0a020a000, 0x80c0008000c00000, 0x8000008000000000,
    0x0001000100000101, 0x0002000203000201, 0x0006050300050603,
    0x00080502030a070e, 0x001c1b13051e1913, 0x001b1e1e36271122,
    0x006d66360b686366, 0xff49b7e73d73be78, 0x44da88284684929c,
    0xb860f0004434d028, 0xd8b05000d8586038, 0x90d090005090b0d0,
    0xa060a000a0a08060, 0x00400000c000c040, 0x0080000000000080,

    0x0001010101010000, 0x0001010102020000, 0x0002020206060500,
    0x0f0c030c0b0b0500, 0x000514051c0d1a00, 0x03051736183a2300,
    0x015a791e281b6100, 0x0d5c62d4cf2142ff, 0x02b4f23c4026c200,
    0x0c246ce870f88c00, 0x5068b0689018d000, 0x50401040d0d0a000,
    0xa0c060c02020a000, 0x00808080c0c00000, 0x0080808000000000,
    0x0000010001000100, 0x0000000300030300, 0x0005070202020500,
    0x0000000f0f00000f, 0x000b1e1e0b110f0f, 0x000f0f000c0c303f,
    0x005822785a7a7a75, 0xff00f00fff000f0f, 0xeeb4a0fe5ae4aaa0,
    0xfcfccccc0cf03c0c, 0x70d08820f8782808, 0x000000f0f000f0f0,
    0xa0e000a000a0e0e0, 0x000000c0000000c0, 0x0080008000008000,

    0x0101000101010000, 0x0201030101020000, 0x0607010207060500,
    0x0b090d0c090b0500, 0x0d0e12141f1c0b00, 0x3a371f27152b3200,
    0x1b19213c2a6c4300, 0xded232183cb871ff, 0x2632527854c88600,
    0xf8ec5cac64bcc800, 0x1830f0e0b8905800, 0xd0e06040e0d0a000,
    0x2060e0c06020a000, 0xc080408080c00000, 0x0080808080000000,
    0x0000000001000100, 0x0003000001030100, 0x0004000003040305,
    0x00040f0f0d0b0d05, 0x000911001609071b, 0x000d1133170d3522,
    0x000636413c561e72, 0xfff7d8bedb581793, 0x100c6c9278bc2ce4,
    0x103474dc5c24c488, 0x6018c860e02808d8, 0x80e0b08070300050,
    0xc02080c0c04000a0, 0x40c0c04040800000, 0x8000008080800000,

    0x0101010100010000, 0x0202020103020000, 0x0603060204060500,
    0x040e040c070b0500, 0x0d060d14081c0b00, 0x393b0a270c2b3200,
    0x1a495e3c056c4300, 0x2c8da4e70a478eff, 0x2482ac781ac88600,
    0xf4fc38ac10bcc800, 0x484048e070905800, 0x8070804090d0a000,
    0x808080c0e020a000, 0xc0c0c08040c00000, 0x0000008080000000,
    0x0000010100010101, 0x0003000003000000, 0x0003030303060603,
    0x0000030c0003030c, 0x0007010b161e1e0b, 0x003f0f030c0f3c03,
    0x0065085030630505, 0xfffcfcfccf3fc003, 0xba22bc5caaecce08,
    0xfc0cfcfc0cc0c030, 0x8808805008580860, 0x30f0c03000f0f000,
    0x60a0c0800040a080, 0x00c0c00000c0c0c0, 0x8080000000008080,

    0x0001010101010000, 0x0001010102020000, 0x0002020206060500,
    0x0f0c030c0b0b0500, 0x001405140d1c0b00, 0x30143527092b3200,
    0x102d1f690a391600, 0xd0c5264dfc1224ff, 0x205a3ed204622c00,
    0xc060e4ac34bcc800, 0x50e038e018905800, 0x50401040d0d0a000,
    0xa0c060c02020a000, 0x00808080c0c00000, 0x0080808000000000,
    0x0000010001000100, 0x0000020302030100, 0x0005030006000300,
    0x000a0203070c0e0f, 0x001f131519110204, 0x00262e26111d0008,
    0x006e666e33335508, 0xff7788771111aa00, 0x5488dc986676fe00,
    0x9830982088a85400, 0xb850e860d8e8e850, 0x1090407050804050,
    0x60a0c080a0c0c0a0, 0x80004000c08040c0, 0x8000800000808000,

    0x0101000100010000, 0x0102000100020000, 0x0706050205060500,
    0x090b0a0c050b0500, 0x1f1c1a141a1c0b00, 0x26182027102b3200,
    0x6e7d606925391600, 0x4b65b0b235eddbff, 0xdceac0d24a622c00,
    0xa87080ac40bcc800, 0xb89080e0d0905800, 0xe0d0f040a0d0a000,
    0x602000c0a020a000, 0x80c0008000c00000, 0x8000008000000000,
    0x0001000100000101, 0x0000000003000003, 0x0002050702050205,
    0x00000f000f000f00, 0x0005041e0e0a0b1e, 0x0033003f300c0c30,
    0x007d0d527d580a0d, 0xff000fff0f00f0ff, 0xfeae141ea4a0e4a4,
    0xfc0000c030c0f000, 0x500878a878807808, 0x00f0f00000f00000,
    0xe0e00040a0e0a000, 0x00c0000000c00000, 0x8000008000000000,

    0x0101000100010100, 0x0201000100010100, 0x0307050705070700,
    0x0e0605090a090900, 0x060e1a1f1a1f0e00, 0x0834231520260400,
    0x584d617f606e0800, 0xaf7542964f4b0fff, 0xa09ac2fec0dc1000,
    0x30e08c6480a82000, 0x4060d0b880b83000, 0x70b0a0e0f0e0e000,
    0x80c0a06000606000, 0xc080008000808000, 0x0080008000808000,
    0x0000010101000001, 0x0003010102000301, 0x0004030302050103,
    0x000b020d0c0a0102, 0x00091617051b0316, 0x000e242539213e17,
    0x00022d7b4e264269, 0xff0cc59d4738bc7e, 0x00145af68c4c94d2,
    0x0018a0a4f484d86c, 0x0038a0f8488838a0, 0x00d0306040f02030,
    0x006040e080006040, 0x00408080c0004080, 0x0080808000008080,

    0x0101000100010100, 0x0201000100010100, 0x0307050705070700,
    0x0e0605090a090900, 0x060e0b1f0b1f0e00, 0x0807321502260400,
    0x0d5c167f066e0800, 0xfa572469f4b4f0ff, 0x0ab82cfe0cdc1000,
    0x302cc86408a82000, 0x406058b808b83000, 0x70b0a0e0f0e0e000,
    0x80c0a06000606000, 0xc080008000808000, 0x0080008000808000,
    0x0000010101000001, 0x0003030300000303, 0x0006050506050305,
    0x000f0c030c000f0c, 0x00121309041f1c13, 0x00303c003330330f,
    0x00000e036e5e5e68, 0xff303c03f0c33fc3, 0xaa706400283e9246,
    0xcc30000c0ccc0030, 0x88d0880808e030e8, 0xf030f0f000c03000,
    0xa080a0a000400080, 0xc000c0c00000c0c0, 0x8000808000808080,

    0x0000000101010100, 0x0300000101010100, 0x0100050702070700,
    0x020f050903090900, 0x03000b1f141f0e00, 0x3e30011517260400,
    0x4645072a2c3b5d00, 0x7b7a06c337e15aff, 0x9c8a0e545876ba00,
    0xd8c004646ca82000, 0x285058b8b0b83000, 0x3050a0e010e0e000,
    0x40a0a06060606000, 0x4000008080808000, 0x8000008080808000,
    0x0000000100000000, 0x0003030200000300, 0x0005000300050505,
    0x00090c0d0f05060a, 0x001b1006050b0f1f, 0x00222c073a0e3a25,
    0x006365080e530b6e, 0xff8d850337a2cd7b, 0x44d6da1448e21698,
    0x88a49c24707ce42c, 0xd8e8b06880d03830, 0x5080e070c090d020,
    0xa0c0208000a06020, 0xc0800000c00040c0, 0x0080000000008000,

    0x0000000101010100, 0x0300000101010100, 0x0100050702070700,
    0x020f050903090900, 0x12001a1f051f0e00, 0x2f03101535260400,
    0x6454702a4a3b5d00, 0xb7a7603c731ea5ff, 0xd8a8e0549476ba00,
    0x9c0c4064e4a82000, 0xa050d0b838b83000, 0x3050a0e010e0e000,
    0x40a0a06060606000, 0x4000008080808000, 0x8000008080808000,
    0x0000000100000000, 0x0003030000000300, 0x0007020700050705,
    0x000f000f0f0f0000, 0x000410101e140b1b, 0x000f0f030f00003c,
    0x00577a277778025a, 0xff00f000f0f00f00, 0xeeaa005a1a000af4,
    0xccf03c3000000c30, 0x50a0288020505888, 0x00f000f00000f0f0,
    0xa0e000a040a040a0, 0xc000c00000c00000, 0x8080800080808000,

    0x0101010101010100, 0x0202010102010100, 0x0303020706070700,
    0x0e010c0904090900, 0x1717050e0d0e1f00, 0x2a1a36040a371500,
    0x6b2e1e085e4c7f00, 0x41c4d4f05b8796ff, 0xc64c3c10ac98fe00,
    0xb878e82038ec6400, 0xc89868304830b800, 0x702040e080e0e000,
    0x8020c06080606000, 0xc0c08080c0808000, 0x0000808000808000,
    0x0001000000010000, 0x0002000303020000, 0x0002050404020005,
    0x000c05040b030f05, 0x00151a080815111a, 0x0019100c3c1a1223,
    0x003e3000106a6721, 0xffd7df0fe0837631, 0x106c700030c4ce42,
    0x20446030d078788c, 0x2088f04030c8c880, 0xc0f06040d0404000,
    0x4000e08060808000, 0x800080c040c0c000, 0x8000800080000000,

    0x0101010101010100, 0x0202010102010100, 0x0303020706070700,
    0x0e010c0904090900, 0x1717140e1c0e1f00, 0x2a29270428371500,
    0x3e6a69086d4c7f00, 0x144c4d0fb57869ff, 0x6cc4d210ca98fe00,
    0xb8b4ac20b0ec6400, 0xc898e030c030b800, 0x702040e080e0e000,
    0x8020c06080606000, 0xc0c08080c0808000, 0x0000808000808000,
    0x0001000000010000, 0x0000000303000000, 0x0006050606060005,
    0x000c0f000f030f0f, 0x00140508130f0a05, 0x00333c0f000f0f0f,
    0x005e335b36555e00, 0xffc003f03cf3ff03, 0xba28604614485216,
    0xccfcfcccf0c0c000, 0xe8b8380088006038, 0x30000000c0f0c0c0,
    0xe0606000c0a040a0, 0xc0c0c000c0c00000, 0x0000000000808000,

    0x0100010100010100, 0x0203010103010100, 0x0604020701070700,
    0x0b080c090d090900, 0x1c08140e120e1f00, 0x180f14042c371500,
    0x7d512d5d30192a00, 0x6552c5a5102dc3ff, 0xeab25aba70325400,
    0x701c602090ec6400, 0x9020e030f030b800, 0xd0c040e060e0e000,
    0x2040c060e0606000, 0xc040808040808000, 0x0080808080808000,
    0x0000010100010001, 0x0000010203010302, 0x0000030305030506,
    0x000f010d090e0607, 0x001517160a020e19, 0x001a1a2433000b22,
    0x006e3e3855055d36, 0xffb7e72096faa928, 0x54883820be4eea3c,
    0xa8f010f028b440e8, 0xb850305068888068, 0xd090e06070c0f080,
    0x60a020e0800040c0, 0x4000008000c08080, 0x8000008000008080,

    0x0100010100010100, 0x0203010103010100, 0x0604020701070700,
    0x0b080c090d090900, 0x0d08050e030e1f00, 0x093c05040e371500,
    0x5f155a5d03192a00, 0x56255c5a01d23cff, 0xae3ab4ba16325400,
    0x34d0242018ec6400, 0x182068307830b800, 0xd0c040e060e0e000,
    0x2040c060e0606000, 0xc040808040808000, 0x0080808080808000,
    0x0000010100010001, 0x0000030003030300, 0x0000050707050702,
    0x000f0f0f0f00000f, 0x000e0100150f0a0b, 0x000f3f003c30333f,
    0x00572855072a722d, 0xfff0ff0fff0f0ff0, 0xfe4afaa4b00abeee,
    0xcc0000c030fc0000, 0x70d0a0d800a82888, 0x0000f0f00000f0f0,
    0xe0a0a0404000a0e0, 0xc0c0c000c0c0c0c0, 0x0080808000808000,

    0x0000010100010100, 0x0003020100010100, 0x0501060700070700,
    0x050d0b090f090900, 0x1a120d0e001f1f00, 0x102c093730152600,
    0x25300a19452a3b00, 0x3510fc2d7ac3e1ff, 0x4a7004328a547600,
    0x409034ecc064a800, 0xd0f0183050b8b800, 0xa060d0e050e0e000,
    0xa0e02060a0606000, 0x0040c08000808000, 0x0080008000808000,
    0x0000000001000101, 0x0003000301030202, 0x0004000103040707,
    0x00040f0e0d0b0906, 0x0018011317191e0e, 0x002c021e262e283b,
    0x002552677a22281c, 0xff35a38963c3301b, 0x004aa4cef4544038,
    0x30800878a898b0dc, 0x40800898a8e89060, 0x4000f010c070e080,
    0x8000002040c020c0, 0xc00000c08040c040, 0x0000000080800080,

    0x0000010100010100, 0x0003020100010100, 0x0501060700070700,
    0x050d0b090f090900, 0x0b031c0e001f1f00, 0x010e183703152600,
    0x52032819542a3b00, 0x5301cfd2a73c1eff, 0xa4164032a8547600,
    0x041870ec0c64a800, 0x5878903050b8b800, 0xa060d0e050e0e000,
    0xa0e02060a0606000, 0x0040c08000808000, 0x0080008000808000,
    0x0000000001000101, 0x0003000303030000, 0x0006000305060303,
    0x00000f00030f030c, 0x00181a170902000b, 0x000f3f0c03300c00,
    0x003e0b6600600d06, 0xffc0c0c3f3fffff3, 0xaaa8c64eb63ab4be,
    0xfc3ccc3cc00cccfc, 0xe86800b0e838e0d0, 0xf0f00000c0c030c0,
    0x2020006040a0e020, 0x000000c00000c0c0, 0x0000000080000080,

    0x0001010101010100, 0x0302020101010100, 0x0406060707070700,
    0x07040b0906090900, 0x191c1c0e0e1f1f00, 0x1d282b3707152600,
    0x276d394c5c7f6e00, 0x39b512785769b4ff, 0x5eca6298b8fedc00,
    0x54b0bcec2c64a800, 0xf8c0903060b8b800, 0x9080d0e0b0e0e000,
    0xe0802060c0606000, 0x40c0c08080808000, 0x8000008080808000,
    0x0001010000010001, 0x0001020300020302, 0x0003060505030006,
    0x000e080905020c08, 0x00131c0a1b13000d, 0x00221b331e1e0f0a,
    0x006638503336055e, 0xff781c931d180658, 0x449c60b4766c0eac,
    0xb828bc2494b838f8, 0xd8388068b8d80858, 0x90d03080e090c060,
    0xa06040c020a000e0, 0x004040800000c080, 0x0080808000000080,

    0x0001010101010100, 0x0302020101010100, 0x0406060707070700,
    0x07040b0906090900, 0x190d0d0e0e1f1f00, 0x1d0a3a3734152600,
    0x725e1b4c4d7f6e00, 0x935b218775964bff, 0xf4ac26989afedc00,
    0x5438f8ece064a800, 0xf848183060b8b800, 0x9080d0e0b0e0e000,
    0xe0802060c0606000, 0x40c0c08080808000, 0x8000008080808000,
    0x0001010000010001, 0x0003000300000300, 0x0005020705070202,
    0x0000000f0f000000, 0x001e1515041e0004, 0x0030333c300f0c00,
    0x000d580278225858, 0xff0f0ff00ff0ff0f, 0xee44faa4aea05eae,
    0xfcf030303ccc0ccc, 0x702880282088f0d0, 0x0000f00000000000,
    0xa000a0000000e0a0, 0x00c000c0c000c0c0, 0x0080008080000080,

    0x0000000101010100, 0x0300030102010100, 0x0405010703070700,
    0x070a020901090900, 0x191a121f170e0e00, 0x2e201c2629043700,
    0x6360756e6a084c00, 0xb14f6a4b4c0f78ff, 0xd6c0fadcc4109800,
    0x988050a8b420ec00, 0xf880a0b898303000, 0x90f030e020e0e000,
    0xe000406020606000, 0x40004080c0808000, 0x8000808000808000,
    0x0000000001010100, 0x0000030001010103, 0x0005040003060304,
    0x00050b0f02080d0b, 0x001b0900161c0718, 0x00223e332424352f,
    0x002712147d284b21, 0xff391ceb653fbd3e, 0x104e2428ea408642,
    0x10b8c8fc80b0f48c, 0x6098584080c04880, 0x8010a040f0404000,
    0xc020a08000808000, 0x40c000c000c0c000, 0x8000000000000000,

    0x0000000101010100, 0x0300030102010100, 0x0405010703070700,
    0x070a020901090900, 0x190b031f170e0e00, 0x2e020d261a043700,
    0x3606576e2e084c00, 0x1bf4a6b4c4f087ff, 0x7c0cbedc4c109800,
    0x980814a87820ec00, 0xf80828b898303000, 0x90f030e020e0e000,
    0xe000406020606000, 0x40004080c0808000, 0x8000808000808000,
    0x0000000001010100, 0x0000030003030303, 0x0005060005000506,
    0x000f0f0f0c0c030f, 0x0004121b131d1903, 0x000c000c3c0f3033,
    0x0000306b5e355365, 0xff0fc0cc3c33c30c, 0xba1ab04a94182082,
    0xfc3c300030c0fccc, 0x8858508008e0e8d8, 0x30303000c03000f0,
    0x60808000c0e08040, 0x00000000c0c0c0c0, 0x8000000000008000,

    0x0101000100010100, 0x0101030103010100, 0x0202010704070700,
    0x0c03020908090900, 0x0505031f080e0e00, 0x05353e260f043700,
    0x0f4a133b515d1900, 0x0973d11e52a52dff, 0x1e943676b2ba3200,
    0x24e4d8a81c20ec00, 0x683828b820303000, 0x401030e0c0e0e000,
    0xc060406040606000, 0x8080408040808000, 0x8080808080808000,
    0x0001000000010101, 0x0001030303020201, 0x0003050500060306,
    0x000109060c080d04, 0x00170a0e001d061d, 0x002a333b3f193715,
    0x006e555d006e5d3b, 0xff776699cc4466ee, 0x5498feaa10dcee22,
    0x98109800ec64b800, 0xb860e80030b88850, 0x10404000d020c050,
    0x60c0c000602000a0, 0x8040400040c0c0c0, 0x8080800080000000,

    0x0101000100010100, 0x0101030103010100, 0x0202010704070700,
    0x0c03020908090900, 0x1414121f080e0e00, 0x14172f263c043700,
    0x782c313b155d1900, 0x90371de1255ad2ff, 0xf05872763aba3200,
    0x606c9ca8d020ec00, 0xe0b0a0b820303000, 0x401030e0c0e0e000,
    0xc060406040606000, 0x8080408040808000, 0x8080808080808000,
    0x0001000000010101, 0x0003030303000003, 0x0005070702020700,
    0x000f0f0000000f00, 0x0001150a00141014, 0x000f3c033c33333c,
    0x005807527d0a5200, 0xff0f0fffffff0f00, 0xfeaa404e44befe50,
    0xfcf0f000f00000c0, 0x50f070882828f820, 0x00000000f0f0f000,
    0xe0a0a000e0a00040, 0x0000000000c00000, 0x8000000080800080,

    0x0101000101000000, 0x0202000101030300, 0x0606050207040100,
    0x04040a0306080d00, 0x0d0d0b141f080300, 0x39393117163c0e00,
    0x4f1a422c7e150300, 0x79d383379b2501ff, 0x8e248458fc3a1600,
    0xf4f4c46c68d01800, 0x484808b0e8207800, 0x8080f010b0c06000,
    0x80800060c040e000, 0xc0c0008080404000, 0x0000008080808000,
    0x0001000001000101, 0x0002030002000101, 0x0007010007000306,
    0x00090e0f090f0d07, 0x000e02100e01060c, 0x00083f103b323404,
    0x000d14301c121d5d, 0xff051b2feb1ceaa5, 0x000a386028243aba,
    0x0030dc40fcc8e020, 0x001060d010587070, 0x00e07050e0506090,
    0x0020c0a020a0e0e0, 0x00c04000c0008080, 0x0000800000008080,

    0x0000010101000000, 0x0000020101030300, 0x0500060202040100,
    0x0a0f040303080d00, 0x0b111c1414080300, 0x02122817243c0e00,
    0x53236d2c68150300, 0x5e3e4ac840dafeff, 0xa646ca58d03a1600,
    0x0848b06ca0d01800, 0x08d8c0b0b0207800, 0xf050801010c06000,
    0x00a080606040e000, 0x0000c08080404000, 0x0000008080808000,
    0x0001010100010101, 0x0000030300000000, 0x0006000505060603,
    0x00030c0c00030c03, 0x000f1d021f1e1501, 0x003c3f3c303c333f,
    0x006350680b505d3d, 0xfffc33f03ccfc30c, 0xaa3a86307a2a3872,
    0xcc30300000fcc0cc, 0x88006860b0b8b068, 0xf030f030300030c0,
    0xa06020e000600040, 0xc00000c0c0c0c000, 0x8080000080008080,

    0x0000000101000000, 0x0300030102030300, 0x0405010203040100,
    0x080a0d0301080d00, 0x191a121406080300, 0x1e131f170b3c0e00,
    0x2624217959405600, 0xcb3832625d8f54ff, 0x5c4852f2a290bc00,
    0x584c5c6c3cd01800, 0xa880f0b010207800, 0xc0f0601020c06000,
    0x4000e0602040e000, 0x40004080c0404000, 0x8000808000808000,
    0x0001000000000001, 0x0001030303030001, 0x0003050000000003,
    0x0001090c0c030f0e, 0x00160a1001151402, 0x002b001f0e252b33,
    0x006d0530563e3d50, 0xff7905e358d4d993, 0x448a1a24bc6c7aa4,
    0x88301c04e8745034, 0xd800605868d8e058, 0x50c040508090b060,
    0xa000c0a0c0a080e0, 0xc0c040c08000c080, 0x0000800080000080,

    0x0001010101000000, 0x0302010102030300, 0x0403020206040100,
    0x0801030304080d00, 0x080605140d080300, 0x3c380617393c0e00,
    0x151d0e794f405600, 0xda2afb9d7970abff, 0x3a2a1cf28e90bc00,
    0xd0f0286cf4d01800, 0x201038b048207800, 0xc020101080c06000,
    0x402060608040e000, 0x40c08080c0404000, 0x8000808000808000,
    0x0000000100010101, 0x0003030300000303, 0x0007020000020000,
    0x000f000f0f000f00, 0x0015100a0f151b05, 0x003c3c303c30033f,
    0x00025825775f7070, 0xfffff00f0ff0f0ff, 0xeeaa1014b01e145a,
    0xcc0cf0c030cc3cf0, 0x500880f850f05050, 0x0000000000f0f000,
    0xa00040e0e00000e0, 0xc000c0c00000c000, 0x8000000080008080,

    0x0000010101000000, 0x0303010102030300, 0x0104020203040100,
    0x020703030e080d00, 0x0308140506191200, 0x0d3f17063b2d1f00,
    0x0214795b1c377400, 0x0cd76251d8e998ff, 0x1438f2b6287ef800,
    0x14dc6c28fc945c00, 0x2870b03840a8f000, 0x3090101070c06000,
    0x40e060608040e000, 0x40408080c0404000, 0x8080808000808000,
    0x0000010100000100, 0x0003020203030103, 0x0001070201040601,
    0x000e09030e040801, 0x00031e0412191d03, 0x000e180b1f2e260d,
    0x0057680c31227a56, 0xffa67ff42e3c9ca7, 0x10bed0086244e4bc,
    0x2028500c7cb88824, 0x2078b0009098d878, 0xc06020f010105090,
    0x40e060002020a0e0, 0x80804000c0c00080, 0x8080800000000080,

    0x0101000101000000, 0x0201030102030300, 0x0302010206040100,
    0x0e0c0d030b080d00, 0x171403050d191200, 0x2a140e06092d1f00,
    0x6b78565b5f377400, 0xbe9054ae561667ff, 0xc6f0bcb6ae7ef800,
    0xb860182834945c00, 0xc8e0783818a8f000, 0x70406010d0c06000,
    0x80c0e0602040e000, 0xc0804080c0404000, 0x0080808000808000,
    0x0000010101010100, 0x0000000000030303, 0x0005030606050006,
    0x00000c0303030c00, 0x001e1b0f1e081c19, 0x0033330f3c333c0f,
    0x000b005555635068, 0xffcfc30c3fff303c, 0xbaccd6f2843c90fc,
    0xccf0f00c0c3000fc, 0xe86808e800586000, 0x300030c00030c030,
    0xe080604000804060, 0xc0c0000000000000, 0x0080808000008080,

    0x0101010101000000, 0x0201020101030300, 0x0607060207040100,
    0x0409040309080d00, 0x0d0e0d050e191200, 0x39043906372d1f00,
    0x1a5d4f0e19622100, 0xd3a586042d43cdff, 0x24ba8e1c32d45200,
    0xf420f428ec945c00, 0x4830483830a8f000, 0x80e08010e0c06000,
    0x806080606040e000, 0xc080c08080404000, 0x0080008080808000,
    0x0000000101000001, 0x0000030101030301, 0x0005000303050503,
    0x000503010e090901, 0x001a1417131b0a06, 0x001c241a22223338,
    0x00353d3e6333550d, 0xffeadae78dd2963a, 0x543e6e38c672be4e,
    0xa8144410845c2874, 0xb838d83088e068d8, 0xd010a0e000407090,
    0x6060e02000c080a0, 0x4080400000400000, 0x8080800000800000,

    0x0100000101000000, 0x0103000101030300, 0x0701050202040100,
    0x06020a030c080d00, 0x0e121a0505191200, 0x072f2006052d1f00,
    0x5c31600e5a622100, 0xa81db0fb5cbc32ff, 0xb872c01cb4d45200,
    0x2c9c802824945c00, 0x60a0803868a8f000, 0xb030f01040c06000,
    0xc0400060c040e000, 0x8040008080404000, 0x8080008080808000,
    0x0000010101000101, 0x0003030300000000, 0x0002050502050207,
    0x000f000000000000, 0x000f0f0f051a141f, 0x00030330300c030f,
    0x00085d2a2f787a75, 0xff00f00f0000ff00, 0xfe045e0a1ee00eee,
    0xcc3c30fcfcc000c0, 0x7070d8a880000858, 0x0000f00000f000f0,
    0xe0a0000040e00040, 0xc000c0c0c0c00000, 0x0000808000000080,

    0x0000010101000000, 0x0000020101030300, 0x0500060202040100,
    0x0a0f040303080d00, 0x1a110d0505081200, 0x20210a35060f2c00,
    0x35325e4a0e513000, 0xe5e3a48c04adefff, 0x6a64ac941cb27000,
    0x808438e4281c9000, 0x80d848383820f000, 0xf050801010c06000,
    0x00a080606040e000, 0x0000c08080404000, 0x0000008080808000,
    0x0001010100010101, 0x0002010100020202, 0x0002060305020207,
    0x000308020a030c09, 0x00150c070b04140f, 0x00293406010b2b39,
    0x002e1d5f5359294e, 0xffc8e559ad513e47, 0x005c2aaea6a2429c,
    0x3094f008343c8ce4, 0x40e8405818108028, 0x40804050e0e0f030,
    0x80c080a020200040, 0xc040c000c0c00080, 0x0080000000000080,

    0x0101000101000000, 0x0202000101030300, 0x0606050207040100,
    0x04040a0306080d00, 0x1c1c1a051f081200, 0x1b1b1335250f2c00,
    0x7c29244a6f513000, 0x973d3873b95210ff, 0xe8424894deb27000,
    0x7c7c4ce4a41c9000, 0xc0c08038e820f000, 0x8080f010b0c06000,
    0x80800060c040e000, 0xc0c0008080404000, 0x0000008080808000,
    0x0001000001000101, 0x0000030000000303, 0x0003030003000500,
    0x0003000f030f0303, 0x0000060b001a1806, 0x000c3f3f3f3f0300,
    0x0058336d6b0b330d, 0xff000f0c003fc0f0, 0xaae07c92866cb6ae,
    0xfc30c0fcfc300cc0, 0xe8b038d8e0e86088, 0xf00030c0f0f030f0,
    0x206000202020e0a0, 0x00c0c0c00000c0c0, 0x0000808000000080,

    0x0001010101000000, 0x0302010102030300, 0x0403020206040100,
    0x0801030304080d00, 0x080614051c081200, 0x0f0b24351b0f2c00,
    0x5159681f7c046500, 0xada2bfd99707baff, 0xb2a2d03ee818da00,
    0x1c3ca0e47c1c9000, 0x2010b038c020f000, 0xc020101080c06000,
    0x402060608040e000, 0x40c08080c0404000, 0x8000808000808000,
    0x0000000100010101, 0x0003030100020101, 0x0005000600060606,
    0x00090c0b0f080b04, 0x000a0008141c191c, 0x00330f3c1b282d14,
    0x00500555686d663d, 0xff6cf99a4c858be5, 0x44f04aaec0dad82a,
    0xb89c80044cac9c3c, 0xd8b0d058d0b0b050, 0x901050a0a0201060,
    0xa060a0e0e02060e0, 0x0080c04040c08080, 0x0080008080008080,

    0x0000000101000000, 0x0300030102030300, 0x0405010203040100,
    0x080a0d0301080d00, 0x190b030506081200, 0x2d313d35380f2c00,
    0x6242121f1d046500, 0xbc832326d5f845ff, 0xd484343e2a18da00,
    0x94c4d4e4f01c9000, 0xa80878381020f000, 0xc0f0601020c06000,
    0x4000e0602040e000, 0x40004080c0404000, 0x8000808000808000,
    0x0001000000000001, 0x0003030303030003, 0x0005070202020005,
    0x000f0f00000f0f00, 0x00001500111e0f0f, 0x003c0f0c3f330c03,
    0x002d750d0d5a020d, 0xfffff000fff0f0f0, 0xeee41e0ab010f4fe,
    0xfc30003c3cccc0f0, 0x70f8787858f82808, 0x00f000f00000f0f0,
    0xa040e040e0e0a0a0, 0x00c0c0c000c0c000, 0x0000000080008000,

    0x0101000101000000, 0x0201030102030300, 0x0302010206040100,
    0x0e0c0d030b080d00, 0x170512141c190300, 0x2a052c24181e3d00,
    0x3e0f653d7d734700, 0xeb0945ea656176ff, 0x6c1eda7aeaf69e00,
    0xb82490a07058d400, 0xc868f0b090a87800, 0x70406010d0c06000,
    0x80c0e0602040e000, 0xc0804080c0404000, 0x0080808000808000,
    0x0000010101010100, 0x0000020202010103, 0x0005070202030604,
    0x000a0603030d0804, 0x000a0e1504160d09, 0x0000381a0b24353e,
    0x0055483a5c2d1b17, 0xff5a4fdcab35e219, 0x10aa9074a84a363e,
    0x1030e0680c80e4e8, 0x604020f800d07828, 0x80b0306000a06030,
    0xc08040e000a0e040, 0x40c0808000008080, 0x8000808000008080,

    0x0000010101000000, 0x0303010102030300, 0x0104020203040100,
    0x020703030e080d00, 0x1208051406190300, 0x1c3f35243b1e3d00,
    0x20411f3d49734700, 0xc07d26158d9e89ff, 0x50923e7a82f69e00,
    0x50dce4a0fc58d400, 0xa07038b040a87800, 0x3090101070c06000,
    0x40e060608040e000, 0x40408080c0404000, 0x8080808000808000,
    0x0000010100000100, 0x0003000003030303, 0x0003030603060003,
    0x0000030300000c0f, 0x0007101e16090c1c, 0x000c3c3c3f3f0f00,
    0x00565d05563d5368, 0xfffc30c030f30030, 0xba548ece88d8e6f0,
    0xfcc000c00c300cf0, 0x8868080858808050, 0x30c000f00030f0c0,
    0x604000a0e060a020, 0x000000c00000c0c0, 0x8080008080808080,

    0x0100000101000000, 0x0103000101030300, 0x0701050202040100,
    0x06020a030c080d00, 0x0e030b1414190300, 0x343e0224141e3d00,
    0x4d1306682d261200, 0x8ad10bbfc5cb23ff, 0x9a360cd05a5c3400,
    0xe0d808a06058d400, 0x602808b0e0a87800, 0xb030f01040c06000,
    0xc0400060c040e000, 0x8040008080404000, 0x8080008080808000,
    0x0000010101000101, 0x0003010102000202, 0x0000030306050603,
    0x00030e0e080a0802, 0x000402020c0e1d02, 0x003733000837190c,
    0x000800555d086e55, 0xffcc33aa553344aa, 0x541044feba54dcee,
    0x98ec4454dc646444, 0xb86088e830e8b888, 0x1080f040e0702000,
    0x60c040c020802000, 0x808080400000c000, 0x8080808000000000,

    0x0101010101000000, 0x0201020101030300, 0x0607060207040100,
    0x0409040309080d00, 0x1c0e1c140e190300, 0x1b041b24371e3d00,
    0x295d7c6819261200, 0x3d5a6840d234dcff, 0x42bae8d0325c3400,
    0x7c207ca0ec58d400, 0xc030c0b030a87800, 0x80e08010e0c06000,
    0x806080606040e000, 0xc080c08080404000, 0x0080008080808000,
    0x0000000101000001, 0x0000030303030303, 0x0005020505070705,
    0x000f0f0f000f0f0f, 0x00151f011e041510, 0x0000300f300f3c0f,
    0x007a5f585807072f, 0xfff0f00f000f0ff0, 0xfe041eaaf00440ba,
    0xfc00ccf0003cf0f0, 0x5058a0f0a02070d0, 0x00f0f000f0000000,
    0xe040a0a0a000a0e0, 0x0000c000c0c00000, 0x8080800080800080,

    0x0001000100000100, 0x0301000200030200, 0x0407000305040300,
    0x07060f0e0a070e00, 0x080e11171a190600, 0x0c34122a201d0800,
    0x054d233e60270d00, 0xf575c1eb4fc605ff, 0x1a9a466cc05e0a00,
    0x10e048b880543000, 0x7060d8c880f84000, 0x90b05070f0907000,
    0xe0c0a08000e08000, 0x408000c00040c000, 0x8080000000800000,
    0x0001000100000001, 0x0001030103000302, 0x0003010304050102,
    0x000d010d04050103, 0x00061217191a0315, 0x00071c251e133e29,
    0x000c607b6734427e, 0xff048f9d8924bc97, 0x0018d0f6de6894ec,
    0x002c50a4584cd8b4, 0x0070b0f8e8d03898, 0x0060206080a02010,
    0x00e060e0c0a06020, 0x00804080400040c0, 0x0080808080008000,

    0x0100000101000100, 0x0100000201030200, 0x0200000302040300,
    0x030f0f0e03070e00, 0x0500001705190600, 0x3503302a351d0800,
    0x1f54103e4a270d00, 0xd9a7d0147339faff, 0x3ea8206c945e0a00,
    0xe40cc0b8e4543000, 0x385050c838f84000, 0x1050507010907000,
    0x60a0a08060e08000, 0x800000c08040c000, 0x8000000080800000,
    0x0001010100000000, 0x0003000000000300, 0x0005060305000300,
    0x000c0c030f0f000f, 0x00131510051a171a, 0x000f003f3f3c3c0f,
    0x00686e5b6058063e, 0xffc33cc003c033c0, 0xaa46f42696206ea8,
    0xcc30f0ccf0c03c3c, 0x88e80880d8d0e038, 0xf000c00030f000f0,
    0xa080c000804080c0, 0xc0c0c00000c0c000, 0x8080000000008080,

    0x0001000100000100, 0x0301000200030200, 0x0407000305040300,
    0x07060f0e0a070e00, 0x080e11170b190600, 0x0c07212a021d0800,
    0x505c326b06725800, 0x5f571cbef46c50ff, 0xb0b864c60cf4a000,
    0x102c84b808543000, 0x7060d8c808f84000, 0x90b05070f0907000,
    0xe0c0a08000e08000, 0x408000c00040c000, 0x8080000000800000,
    0x0001000100000001, 0x0001030103000302, 0x0003050300050506,
    0x000109010c050907, 0x00161b07010b0a19, 0x0018113a3d3d3322,
    0x0038360b56535033, 0xffe0143d946e632d, 0x44306c56acf2e426,
    0x8820b45434a084c4, 0xd830d8e808b08808, 0x50206040c0d0f0f0,
    0xa020e0c000604040, 0xc0c08040c0408080, 0x0000808000808080,

    0x0100000101000100, 0x0100000201030200, 0x0200000302040300,
    0x030f0f0e03070e00, 0x1400001714190600, 0x1730032a171d0800,
    0x7945016b2c725800, 0x9d7a0d413793afff, 0xf28a02c658f4a000,
    0x6cc00cb86c543000, 0xb05050c8b0f84000, 0x1050507010907000,
    0x60a0a08060e08000, 0x800000c08040c000, 0x8000000080800000,
    0x0001010100000000, 0x0003000000000300, 0x0005020705000700,
    0x0000000f0f0f000f, 0x001e0410140f0b0f, 0x00033003330f003c,
    0x007f28720f555777, 0xff000fff0f0f0f0f, 0xeeea0e1e54a0a0b0,
    0xccc0fc30ccfcc030, 0x5050f00870f88050, 0x00000000f0000000,
    0xa0a0a04000a000e0, 0xc0c000c000000000, 0x8080000000000080,

    0x0100010101000100, 0x0100020202030200, 0x0705030303040300,
    0x090a010e01070e00, 0x0e1a060617081700, 0x3720383b290c1900,
    0x19601d496a057a00, 0xd24fd58d4c0a9cff, 0x32c02a82c41ae400,
    0xec80f0fcb4107400, 0x308010409870c800, 0xe0f0207020907000,
    0x6000208020e08000, 0x8000c0c0c040c000, 0x8000000000800000,
    0x0000010001000101, 0x0000020002030101, 0x0005070002040303,
    0x000a060f03040d0d, 0x001a0f0004080707, 0x00133903380c0505,
    0x00311e541d555b0e, 0xffde18ab1a5aad07, 0x10723cb83aaaa61c,
    0x206ce41ce0000414, 0x20f0286070005838, 0xc090c070900050d0,
    0x40e040c0e000a060, 0x8080804080000040, 0x8080808080000080,

    0x0101010100000100, 0x0201020203030200, 0x0602030304040300,
    0x0403010e08070e00, 0x1c14170608081700, 0x28171a3b3c0c1900,
    0x382c2e4915057a00, 0xe0373b7225f563ff, 0x60584c823a1ae400,
    0xb06c78fcd0107400, 0xc0b098402070c800, 0x80102070c0907000,
    0x8060208040e08000, 0xc080c0c04040c000, 0x0080000080800000,
    0x0001010001010101, 0x0000000303030000, 0x0003060300000306,
    0x000c03000c0c030c, 0x001b0f161c0d0014, 0x00000f0f3c3c0f00,
    0x0033003605635e38, 0xffc3f33f30fc0fc0, 0xbaa0b6026e2af2a0,
    0xcc0cf0f030303030, 0xe808d8b0b8608060, 0x30f0300000f03000,
    0xe0a0806060206080, 0xc0c000c0c00000c0, 0x0080000000008080,

    0x0100010101000100, 0x0100020202030200, 0x0705030303040300,
    0x090a010e01070e00, 0x0e0b060617081700, 0x37020b3b1a0c1900,
    0x1906591c2e502f00, 0x2df45dd8c4a0c9ff, 0x320ca2284cb04e00,
    0xec083cfc78107400, 0x300810409870c800, 0xe0f0207020907000,
    0x6000208020e08000, 0x8000c0c0c040c000, 0x8000000000800000,
    0x0000010001000101, 0x0000020002030101, 0x0005030006000303,
    0x000a020f070c0101, 0x001e121508101717, 0x00241c1a332f1a1a,
    0x003d303b50606b3e, 0xffd5e0e26c834de7, 0x546a2022f0d4c638,
    0xa87c300c9c944410, 0xb8d00000e0e8d830, 0xd09030f0b0b050e0,
    0x60a040408080a020, 0x40004080c0c0c000, 0x8000808000000000,

    0x0101010100000100, 0x0201020203030200, 0x0602030304040300,
    0x0403010e08070e00, 0x0d05170608081700, 0x0a35293b0f0c1900,
    0x0b4a6a1c51502f00, 0x0e73b327525f36ff, 0x0694c428b2b04e00,
    0x38e4b4fc1c107400, 0x483898402070c800, 0x80102070c0907000,
    0x8060208040e08000, 0xc080c0c04040c000, 0x0080000080800000,
    0x0001010001010101, 0x0000000303030000, 0x0007020700000702,
    0x00000f0000000f00, 0x000e0b0a15040005, 0x000f0c330f0f3330,
    0x00570f277052777a, 0xffff0f0ff0f0f0ff, 0xfe54000404404a5a,
    0xcc3c30fc0c3cf0cc, 0x70d020f000f87028, 0x0000f000f000f0f0,
    0xe0e0e0a0e0a040a0, 0xc0000000c000c0c0, 0x0080800000000080,

    0x0001000101000100, 0x0302030202030200, 0x0403040306040300,
    0x0701080e04070e00, 0x081719060d191700, 0x3f1a2d080a2e2a00,
    0x412e62585e633e00, 0x82c4bc505b4eebff, 0x924cd4a0acd66c00,
    0xdc7894303898b800, 0x7098a84048f8c800, 0x9020c07080907000,
    0xe020408080e08000, 0x40c040c0c040c000, 0x8000800000800000,
    0x0000000001010000, 0x0003000301010000, 0x0004000403030005,
    0x00040f040d020f0a, 0x000910180607010b, 0x000e202c04350201,
    0x00072570581b0753, 0xfff93a9f50e2f652, 0x000e5af0b0361ea6,
    0x3038a0a020e41804, 0x4018f0a070786858, 0x40e090c0606070a0,
    0x8020e040e0e0c0a0, 0xc0c0808080804000, 0x0000808080808000,

    0x0000000100000100, 0x0303030203030200, 0x0104040301040300,
    0x0d08080e0d070e00, 0x0308080603191700, 0x0e3c0f080e2e2a00,
    0x5615045803633e00, 0xab25f8af01b114ff, 0xbc3a18a016d66c00,
    0x18d01c301898b800, 0x7820204078f8c800, 0x60c0c07060907000,
    0xe0404080e0e08000, 0x404040c04040c000, 0x8080800080800000,
    0x0000000101000000, 0x0000030003030303, 0x0005060305030303,
    0x000f0f030c0f000f, 0x00150200020d060d, 0x000f030c0f333f00,
    0x0060530d0b6d665e, 0xffc300ff00fc0f03, 0xaa46f6b4162282ee,
    0xfc003ccc0c0cc03c, 0xe88880e0305880e0, 0xf000c030c0f0f0f0,
    0x2000c0e0a040a020, 0x0000c0c000c0c000, 0x0000000000008000,

    0x0001000101000100, 0x0302030202030200, 0x0403040306040300,
    0x0701080e04070e00, 0x081719061c191700, 0x3f291e08282e2a00,
    0x146a260d6d366b00, 0x284ccb05b5e4beff, 0x38c45c0aca7cc600,
    0xdcb45830b098b800, 0x7098a840c0f8c800, 0x9020c07080907000,
    0xe020408080e08000, 0x40c040c0c040c000, 0x8000800000800000,
    0x0000000001010000, 0x0003000301010000, 0x0000000003030005,
    0x000c0f0c010e0f0a, 0x001105001602140f, 0x002d390f1b331b36,
    0x00360e056800685b, 0xff243b06bcc3b39d, 0x443c480e901484b6,
    0xb8d47c38ecd4f414, 0xd838d00830380868, 0x901090c0d01030b0,
    0xa060a00060604080, 0x008000c0408040c0, 0x0080000080808000,

    0x0000000100000100, 0x0303030203030200, 0x0104040301040300,
    0x0d08080e0d070e00, 0x1208080612191700, 0x2c0f3c082c2e2a00,
    0x6551400d30366b00, 0xba528ffa101b41ff, 0xdab2900a707cc600,
    0x901cd0309098b800, 0xf0202040f0f8c800, 0x60c0c07060907000,
    0xe0404080e0e08000, 0x404040c04040c000, 0x8080800080800000,
    0x0000000101000000, 0x0000030003030303, 0x0005020705070707,
    0x000f0f0f000f000f, 0x00040f000f041a04, 0x00033330033c030f,
    0x000f2d2058757702, 0xff0ff0000f0ffff0, 0xee14fe00aaa404f0,
    0xfc0c00f0c0003ccc, 0x7070f8f080582078, 0x0000f00000f0f0f0,
    0xa0e000a00040e000, 0x00c0000000000000, 0x0000000000808000,

    0x0000010100000100, 0x0003010200030200, 0x0501070300040300,
    0x0a0d060e0f070e00, 0x1a120e1700080600, 0x202c0719303f3b00,
    0x35305c2f45414900, 0x1a10a8367a8272ff, 0x6a70b84e8a928200,
    0x80902c74c0dcfc00, 0x80f060c850704000, 0xf060b07050907000,
    0x00e0c080a0e08000, 0x004080c00040c000, 0x0080800000800000,
    0x0001000001010100, 0x0001000302020203, 0x0006050107070704,
    0x00080a0e0606090b, 0x001c1b030e1f0e09, 0x0024113e0b29380d,
    0x007d3317597b1803, 0xff6ad2e9a192e00d, 0x10fa663ea2e62006,
    0x109044e83cb4f004, 0x60e0d82810981008, 0x808050c0e010e0f0,
    0xc0c0a04020202000, 0x40400080c0c0c000, 0x8080008000000000,

    0x0101010101000100, 0x0102010201030200, 0x0706070307040300,
    0x0904060e06070e00, 0x1f0d1f170e080600, 0x260a2519343f3b00,
    0x3b5e3a2f4d414900, 0xe15b13c9757d8dff, 0x76ac744e9a928200,
    0xa838a474e0dcfc00, 0xb848e8c860704000, 0xe080b070b0907000,
    0x6080c080c0e08000, 0x80c080c08040c000, 0x8000800080800000,
    0x0001010000010000, 0x0000030300030303, 0x0006000305050606,
    0x00030c0f00030000, 0x001e0c0d0e191818, 0x003c0f0000300c0c,
    0x0005530e0d06683d, 0xffc000fc0f3c3f3f, 0xbacee6b41474ea04,
    0xfcc00cc00c30ccfc, 0x880880b830d808b0, 0x30f0f030c030f0f0,
    0x60a0a000a080a0c0, 0x00c0c0c00000c000, 0x8080808000008080,

    0x0000010100000100, 0x0003010200030200, 0x0501070300040300,
    0x0a0d060e0f070e00, 0x0b030e1700080600, 0x020e3419033f3b00,
    0x53034d7a54141c00, 0xa1018a63a72827ff, 0xa6169ae4a8382800,
    0x0818e0740cdcfc00, 0x087860c850704000, 0xf060b07050907000,
    0x00e0c080a0e08000, 0x004080c00040c000, 0x0080800000800000,
    0x0001000001010100, 0x0001000302020203, 0x0006050503030300,
    0x00040a0602020d03, 0x001d1f1f13020604, 0x0015262a2e0c0437,
    0x006e3b6e33555d5d, 0xff44dd77ddaa5599, 0x54cc669866eebaaa,
    0x987444207444dc00, 0xb8d8d830d8886050, 0x1060a0d0600040a0,
    0x60e0e060e000c0e0, 0x8080404080004040, 0x8080808080008080,

    0x0101010101000100, 0x0102010201030200, 0x0706070307040300,
    0x0904060e06070e00, 0x1f1c1f170e080600, 0x26281619073f3b00,
    0x3b6d2b7a5c141c00, 0x1eb5319c57d7d8ff, 0x76ca56e4b8382800,
    0xa8b068742cdcfc00, 0xb8c0e8c860704000, 0xe080b070b0907000,
    0x6080c080c0e08000, 0x80c080c08040c000, 0x8000800080800000,
    0x0001010000010000, 0x0000030300030303, 0x0002000705050202,
    0x000f000f000f0000, 0x001a05040a010000, 0x003f3c0f3f0f0f0f,
    0x000a22522f585f0a, 0xfff0000f00f00000, 0xfea014ae0a54ba10,
    0xfc3cc0c0f00cc03c, 0x5028a8d8a0a0a058, 0x0000f0f0f00000f0,
    0xe000a040e0404000, 0x00c0c000000000c0, 0x8080808080808080,

    0x0101000101010000, 0x0202000202010000, 0x0603050606070500,
    0x0b01050404060a00, 0x1c061a1c1c0e0b00, 0x2b0b23281b070200,
    0x3959616d7c5c0600, 0x125d424a68a80bff, 0x62a2c2cae8b80c00,
    0xbc3c8cb07c2c0800, 0x9010d0c0c0600800, 0xd020a08080b0f000,
    0x2020a08080c00000, 0xc0c000c0c0800000, 0x0000000000800000,
    0x0000010001000001, 0x0000020302000302, 0x0005070102050407,
    0x000a0601030a0406, 0x000a0f12041b080f, 0x0003092f38210f3a,
    0x00045b711826544a, 0xff0ba2611f38ab4c, 0x0008a6f2204cb884,
    0x000c349cf0841cf8, 0x000048b010886048, 0x00f0b02010f080b0,
    0x000080602000c080, 0x0000c040c00040c0, 0x0000008000008000,

    0x0101010100010000, 0x0101020203010000, 0x0202060604070500,
    0x03030b0408060a00, 0x05140d1c190e0b00, 0x352409281e070200,
    0x4a680a6d265c0600, 0x7340fcb53457f4ff, 0x94d004ca5cb80c00,
    0xe4a034b0582c0800, 0x38b018c0a8600800, 0x1010d080c0b0f000,
    0x6060208040c00000, 0x8080c0c040800000, 0x8080000080800000,
    0x0001000000000101, 0x0003030303030300, 0x0005030606060503,
    0x00030f0f000f0c03, 0x00091c0308030210, 0x000033303f303c3f,
    0x00035e336b66685b, 0xff033ffcf003f0c0, 0xaa0092ca368e3026,
    0xcc0c00300cfc00cc, 0x880830e030b06080, 0xf0f030f0c0003000,
    0xa0a00020a060e000, 0xc0c0c00000c0c000, 0x8080800000000000,

    0x0001000100010000, 0x0301030200010000, 0x0107010605070500,
    0x0d0602040a060a00, 0x031f121c1a0e0b00, 0x3d161c2813070200,
    0x477e753871095300, 0x899b6a1f6d025eff, 0x9efcfa60e212a600,
    0xd46850b04c2c0800, 0x78e8a0c080600800, 0x60b03080f0b0f000,
    0xe0c0408000c00000, 0x408040c000800000, 0x8080800000800000,
    0x0001000001010000, 0x0002030302010003, 0x0003050003060005,
    0x000d060c0d040f06, 0x00171e01170c140f, 0x0025180e1634183a,
    0x003b6d563b58685e, 0xffdebaa7129fbf98, 0x44729ef862b484bc,
    0x8850d4608c28c828, 0xd8b068b0d0380868, 0x501040d050d00070,
    0xa060c060a0600080, 0xc0804040c0400000, 0x0080808000800000,

    0x0101010101010000, 0x0202010201010000, 0x0606020607070500,
    0x0b040c0406060a00, 0x0d0d051c1f0e0b00, 0x0939362816070200,
    0x5f4f1e382b095300, 0xa979d4e0cefda1ff, 0xae8e3c605612a600,
    0x34f4e8b0682c0800, 0x184868c0e8600800, 0xd0804080b0b0f000,
    0x2080c080c0c00000, 0xc0c080c080800000, 0x0000800080800000,
    0x0000010101010101, 0x0003030300000303, 0x0002050002020005,
    0x000f000f000f0f00, 0x000e1e0a040b0a0f, 0x00330303300c3003,
    0x002f7f52280a255d, 0xfffffff0f0ff0fff, 0xeee40440e0fa1450,
    0xcc3c0c0c30ccc03c, 0x50f000d8a028f888, 0x000000f000f00000,
    0xa0a0004000a0e040, 0xc0000000c0c0c0c0, 0x8000008080800000,

    0x0001010101010000, 0x0301020201010000, 0x0107060607070500,
    0x0d090b0409060a00, 0x120e0d0d1f1f1a00, 0x1f373a3915161300,
    0x74191b1a2a7e7100, 0x67d2212c3c6492ff, 0xf832262454fce200,
    0x5cecf8f464684c00, 0xf0301848b8e88000, 0x60e0d080e0b0f000,
    0xe060208060c00000, 0x4080c0c080800000, 0x8080000080800000,
    0x0001000001010100, 0x0001000002020100, 0x0006050007070305,
    0x00080a0f06060d0a, 0x001d1a000f1e071a, 0x00261303391b0513,
    0x002f64014b3c0e31, 0xffc974fe4dd40721, 0x104ec81296681c62,
    0x20b87c2cd44c144c, 0x2098902068d038d0, 0xc01010308050d050,
    0x40202040c0a060a0, 0x80c0c08040004000, 0x8000008080008000,

    0x0101000100010000, 0x0202000200010000, 0x0306050605070500,
    0x0e0b050405060a00, 0x061c1a0d1a1f1a00, 0x3b18103910161300,
    0x497d701a257e7100, 0x8d6560d3359b6dff, 0x82eae0244afce200,
    0xfc7040f440684c00, 0x4090d048d0e88000, 0x70d0a080a0b0f000,
    0x8020a080a0c00000, 0xc0c000c000800000, 0x0000000000800000,
    0x0000000101000101, 0x0003000003000000, 0x0006000305050606,
    0x00000f0c030f0303, 0x00190a0a08140f1e, 0x003c3c33003c3c3c,
    0x000e386605006655, 0xffc3ff0f00300cc0, 0xbaceda920e60843e,
    0xccfc0cf03000f0c0, 0xe830b8d068d0e8e8, 0x3000c0c000000030,
    0xe060a02080e080e0, 0xc0c000c0c000c0c0, 0x0000008080808000,

    0x0001010100010000, 0x0302010203010000, 0x0403020604070500,
    0x080e0c0407060a00, 0x1906050d081f1a00, 0x1e3b05390c161300,
    0x26495a4f052b2400, 0x348d5c790acec7ff, 0x5c82b48e1a564800,
    0x58fc24f410684c00, 0xa840684870e88000, 0xc070408090b0f000,
    0x4080c080e0c00000, 0x40c080c040800000, 0x8000800080800000,
    0x0001010101010100, 0x0001010201010203, 0x0006060306030600,
    0x000b0b020b0e0703, 0x0009180318130805, 0x003e2f0d1c220006,
    0x005630566536055b, 0xff67dca445270a52, 0x54f860ecda381eb2,
    0xa8904c445cd024dc, 0xb8b08088e0603860, 0xd010f000b0b020b0,
    0x6060400080802080, 0x40808000c0c0c0c0, 0x8080800000000000,

    0x0001000101010000, 0x0001030202010000, 0x0502010606070500,
    0x050c02040b060a00, 0x1a14120d0d1f1a00, 0x10142f3909161300,
    0x702d314f0a2b2400, 0x60c51d86fc3138ff, 0xe05a728e04564800,
    0x40609cf434684c00, 0xd0e0a04818e88000, 0xa0403080d0b0f000,
    0xa0c0408020c00000, 0x008040c0c0800000, 0x0080800000800000,
    0x0000010000010100, 0x0000030303000300, 0x0000050207020505,
    0x000f0f0f0f00000f, 0x000e010f15141e14, 0x000f3f303c033030,
    0x0057282a077a5d58, 0xff0f00ff00fff0f0, 0xfeb404ea4e0e0a00,
    0xcccccc0cfc00fcc0, 0x70a0d0d87008f8d0, 0x0000f00000000000,
    0xe04040a0a000a0a0, 0xc00000c0000000c0, 0x0080808000000080,

    0x0001000100010000, 0x0301030200010000, 0x0107010605070500,
    0x0d0602040a060a00, 0x121f030d0b0e1a00, 0x1f250d0a31342000,
    0x746f570b17183500, 0x98b9a6f1d620e5ff, 0xf8debe062e306a00,
    0x5ca41438c4e08000, 0xf0e8284808608000, 0x60b03080f0b0f000,
    0xe0c0408000c00000, 0x408040c000800000, 0x8080800000800000,
    0x0001000001010000, 0x0002030302010003, 0x0007010407060001,
    0x00090e0409080f0e, 0x000f02090f1d0113, 0x00393c3d0a25311e,
    0x004e10430a7b4367, 0xff471042036db276, 0x009c309604f686ce,
    0x30e4d0d43894c448, 0x4028603848b808d8, 0x403070d040d00050,
    0x8040c060806000a0, 0xc0804040c0400000, 0x0080808000800000,

    0x0101010101010000, 0x0202010201010000, 0x0606020607070500,
    0x0b040c0406060a00, 0x1c1c140d1f0e1a00, 0x181b270a25342000,
    0x7d7c690b3a183500, 0x9a974d0eecdf1aff, 0xeae8d20674306a00,
    0x707cac38a4e08000, 0x90c0e048e8608000, 0xd0804080b0b0f000,
    0x2080c080c0c00000, 0xc0c080c080800000, 0x0000800080800000,
    0x0000010101010101, 0x0003030300000303, 0x0006050006060005,
    0x000f0c030c03030c, 0x00131306150f0602, 0x00030f33300f000f,
    0x0035383e5e550d5e, 0xff33cc0fc303f000, 0xaa08bc623ef8aee8,
    0xfcf03cf0fc30c00c, 0xe8b05030d0d08888, 0xf0f0c0f03030f000,
    0x20c020c08080a000, 0x0000c0000000c000, 0x0080808000008000,

    0x0101000101010000, 0x0202000202010000, 0x0603050606070500,
    0x0b01050404060a00, 0x0d060b0d0d0e1a00, 0x3a38320a39342000,
    0x1b1d165e4f4d6000, 0x21d524a4868ab0ff, 0x262a2cac8e9ac000,
    0xf8f0c838f4e08000, 0x1810584848608000, 0xd020a08080b0f000,
    0x2020a08080c00000, 0xc0c000c0c0800000, 0x0000000000800000,
    0x0000010001000001, 0x0000020302000302, 0x0005030506050003,
    0x000a0209070a0c02, 0x001e021b080f0002, 0x00143c2233363c0f,
    0x00680563050e0550, 0xff403a82c937ca5c, 0x44c05ec21a480ea0,
    0xb84054bce070f4fc, 0xd880e88060800800, 0x90f0403080c030c0,
    0xa040c040c0004000, 0x0080404080c040c0, 0x0080808080008000,

    0x0101010100010000, 0x0101020203010000, 0x0202060604070500,
    0x03030b0408060a00, 0x14051c0d190e1a00, 0x1706180a2d342000,
    0x2c0e285e624d6000, 0x3704cf5b43754fff, 0x581c40acd49ac000,
    0x6c28703894e08000, 0xb0389048a8608000, 0x1010d080c0b0f000,
    0x6060208040c00000, 0x8080c0c040800000, 0x8080000080800000,
    0x0001000000000101, 0x0003030303030300, 0x0005070202020507,
    0x000f0f0f000f000f, 0x0011151e001e0f00, 0x000f3c000c003003,
    0x002d022d58782f02, 0xfffff0f0ff0f0fff, 0xeeb0a4aa5efe10ee,
    0xfccc30fc0cccf0f0, 0x70a828a8f020d028, 0x0000000000f000f0,
    0xa0400000e0a0e0e0, 0x0000c0c0c0c00000, 0x0080808000808080,

    0x0001010100010000, 0x0302010203010000, 0x0403020604070500,
    0x080e0c0407060a00, 0x1906141c081f0b00, 0x2d3b141b0c253100,
    0x621c2d7c503a4200, 0x43d8c597a0ec7cff, 0xd4285ae8b0748400,
    0x94fc607c10a4c400, 0xa840e0c070e80800, 0xc070408090b0f000,
    0x4080c080e0c00000, 0x40c080c040800000, 0x8000800080800000,
    0x0001010101010100, 0x0001010201010203, 0x0006060706030204,
    0x000707060702030b, 0x000d1c0e1c160418, 0x0006173824240b1c,
    0x005a3c482d7d5c65, 0xff5c2bb03a9a547a, 0x10a478805afab8da,
    0x10385cf090901c60, 0x6018e040b0e060f0, 0x80e080b0d0708090,
    0xc020c08060c0c0e0, 0x40c040c040404080, 0x8000800080808080,

    0x0001000101010000, 0x0001030202010000, 0x0502010606070500,
    0x050c02040b060a00, 0x0b05031c1c1f0b00, 0x01053e1b18253100,
    0x075a137c283a4200, 0x065cd168cf1383ff, 0x0eb436e840748400,
    0x0424d87c70a4c400, 0x586828c090e80800, 0xa0403080d0b0f000,
    0xa0c0408020c00000, 0x008040c0c0800000, 0x0080800000800000,
    0x0000010000010100, 0x0000030303000300, 0x0000050603060505,
    0x000f030f0f0c0c0f, 0x001b19121c051315, 0x000c300033033c0c,
    0x003e06305b085e33, 0xffcc3c3fcf0cc33c, 0xbaa4740a3c1c2e0a,
    0xfc3030ccc03cccc0, 0x8838d8d8b8508080, 0x30003000c0c0f0f0,
    0x606080e0a020a0a0, 0x00c0000000c0c0c0, 0x8000008000808080,

    0x0001010101010000, 0x0301020201010000, 0x0107060607070500,
    0x0d090b0409060a00, 0x030e1c1c1f1f0b00, 0x3d372b1b15253100,
    0x471939292a6f1700, 0x762d12c2c34629ff, 0x9e32624254de2e00,
    0xd4ecbc7c64a4c400, 0x783090c0b8e80800, 0x60e0d080e0b0f000,
    0xe060208060c00000, 0x4080c0c080800000, 0x8080000080800000,
    0x0001000001010100, 0x0001000002020100, 0x0006050003030305,
    0x00040a0f0202010a, 0x000c0e150213170e, 0x0037042a0c2e2a04,
    0x0008086e55666e5d, 0xff33ff77558877aa, 0x54445488badc98ee,
    0x98449830dc981074, 0xb888b80030e86088, 0x1000e030104040c0,
    0x6000204060c0c000, 0x80000040804040c0, 0x8000008080808000,

    0x0101000100010000, 0x0202000200010000, 0x0306050605070500,
    0x0e0b050405060a00, 0x060d0b1c0b1f0b00, 0x3b09011b01253100,
    0x1c5f0729526f1700, 0xd856063d53b9d6ff, 0x28ae0e42a4de2e00,
    0xfc34047c04a4c400, 0x401858c058e80800, 0x70d0a080a0b0f000,
    0x8020a080a0c00000, 0xc0c000c000800000, 0x0000000000800000,
    0x0000000101000101, 0x0003000003000000, 0x0002000705050202,
    0x00000f000f0f0f0f, 0x00111f0f10150b1a, 0x000f3f0c0f003f3f,
    0x007d55522f2f7d0a, 0xff00f0fff0f0f0f0, 0xfefe0e5abaae4ea0,
    0xfcc0f00cf0fcc03c, 0x5028f8f8d0a05828, 0x00f0000000000000,
    0xe0a0a0e0e000a000, 0x00c000c000c0c0c0, 0x8080000080808080,

    0x0001000001000000, 0x0302000302030000, 0x0103000406010000,
    0x0d010f08040d0f00, 0x030611081c030000, 0x3d0b123c1b0e0300,
    0x125923407c560100, 0x235dc18f68540dff, 0x34a24690e8bc0200,
    0xd43c48d07c180c00, 0x7810d820c0785000, 0x602050c080605000,
    0xe020a04080e0a000, 0x40c00040c0400000, 0x8000008000800000,
    0x0000010000000000, 0x0000010303000303, 0x0000030101050404,
    0x000f0d010105040b, 0x00010612121a0818, 0x0001072f1c130f1f,
    0x0003597135345464, 0xff0d51612524ab84, 0x0006b2f27a68b8d8,
    0x00042c9c504c1c5c, 0x005870b0b0d060b0, 0x0050602020a080d0,
    0x00a0e06060a0c060, 0x0000804040004040, 0x0000808080008080,

    0x0001000001000000, 0x0302030301030000, 0x0106040407010000,
    0x0d040808060d0f00, 0x030d19081f030000, 0x0e392d3c160e0300,
    0x034f62402b560100, 0xfe79bc70ceabf2ff, 0x168ed49056bc0200,
    0x18f494d068180c00, 0x7848a820e8785000, 0x6080c0c0b0605000,
    0xe0804040c0e0a000, 0x40c0404080400000, 0x8000808080800000,
    0x0001000100010101, 0x0003030303030300, 0x0005030006050006,
    0x00030f03000c0303, 0x00090d160813160f, 0x003300030c0f303c,
    0x00655e6e583d5d63, 0xfffcf3c0f03c3ffc, 0xaa224e585002943a,
    0xcc3cfc3cf0fc0c30, 0x886830d800b86000, 0xf000f030c0f0c030,
    0xa080c080c0c04060, 0xc0c00000c0000000, 0x8080800000808080,

    0x0101010000000000, 0x0201010303030000, 0x0302070404010000,
    0x01030608080d0f00, 0x17140e0819030000, 0x1a24073c1e0e0300,
    0x7b685c1526035400, 0x9140a8da34fe58ff, 0xe6d0b83a5c16a800,
    0x78a02cd058180c00, 0x98b06020a8785000, 0x2010b0c0c0605000,
    0x2060c04040e0a000, 0xc080804040400000, 0x0080808080800000,
    0x0001010001010100, 0x0002020301020103, 0x0003060006030305,
    0x0002070304020e06, 0x001219151d03020f, 0x001f2216253d0009,
    0x0035336b3e53505e, 0xff16d2b2db9ea0ab, 0x447e629268b2f0e8,
    0x88a84cec4c10607c, 0xd8e8d030d060e0d0, 0x5080a02050407060,
    0xa0c0e020a0c080e0, 0xc08040c0c0400080, 0x0080800000800080,

    0x0101010000000000, 0x0101020300030000, 0x0707030405010000,
    0x060601080a0d0f00, 0x1f1f06081a030000, 0x1616383c130e0300,
    0x2b7e1d1571035400, 0xce9bd5256d01a7ff, 0x56fc2a3ae216a800,
    0x6868f0d04c180c00, 0xe8e8102080785000, 0xb0b020c0f0605000,
    0xc0c0204000e0a000, 0x8080c04000400000, 0x8080008000800000,
    0x0000010000000001, 0x0003000303030003, 0x0007070207020000,
    0x00000f0000000f0f, 0x000b10011a101e0a, 0x0000303c333c3c03,
    0x0002057a020d0052, 0xff0fff0f0ff00ff0, 0xee0aa4aa4eba4e40,
    0xcc0c300cf03ccc0c, 0x50587858785800d8, 0x00f0f000f0f0f0f0,
    0xa04040a04000e040, 0xc000c0c0c0c0c000, 0x8080008000800080,

    0x0101000000000000, 0x0102030303030000, 0x0203040404010000,
    0x0c0e0808070d0f00, 0x0506081908121100, 0x363b3c2d0c1f1200,
    0x4b1c403750747600, 0x81d88fe9a09894ff, 0x9628907eb0f8ec00,
    0xe8fcd094105c4800, 0x684020a870f0d800, 0x4070c0c090605000,
    0xc0804040e0e0a000, 0x80c0404040400000, 0x8000808080800000,
    0x0001000101000101, 0x0002030202030201, 0x0007010707010203,
    0x00090e060901030d, 0x001e031e1e120416, 0x002b0e28181c0b14,
    0x002c577868650c68, 0xffc4a6907f85f48f, 0x1048bee0d0da08c0,
    0x208c28b050600c40, 0x208078c0b0f000d0, 0xc00060b02060f0a0,
    0x4000e08060e000a0, 0x800080c040800000, 0x8000800080800000,

    0x0001000000000000, 0x0302000300030000, 0x0406000405010000,
    0x070b0f08050d0f00, 0x190d00190b121100, 0x1d09032d011f1200,
    0x725f013752747600, 0x6c560d1653676bff, 0xf4ae027ea4f8ec00,
    0x54340c94045c4800, 0xf81850a858f0d800, 0x90d050c0a0605000,
    0xe020a040a0e0a000, 0x40c0004000400000, 0x8000008000800000,
    0x0001000101000100, 0x0003000000000003, 0x0000050303000603,
    0x000c000c0c0f030f, 0x000d1e1b1b1b0f0d, 0x003c3300330f0f33,
    0x00360b66006d5568, 0xff03cfc3c3330c0c, 0xba6ecc5ed6e8f29c,
    0xccccf03cf0f00cfc, 0xe85068d00860e8d0, 0x3000003030f0c030,
    0xe0e0808060204080, 0xc000c00000000000, 0x0080800080008000,

    0x0001010001000000, 0x0001020302030000, 0x0502030406010000,
    0x0a0c01080b0d0f00, 0x0b0517191c121100, 0x0205292d181f1200,
    0x065a6a6228212300, 0x0b5cb3bccf32c1ff, 0x0cb4c4d440524600,
    0x0824b494705c4800, 0x086898a890f0d800, 0xf04020c0d0605000,
    0x00c0204020e0a000, 0x0080c040c0400000, 0x0080008000800000,
    0x0000000001010100, 0x0000030301010100, 0x0005000003060305,
    0x000503030e040e0a, 0x001a0514131c131e, 0x002f352411172217,
    0x00600e6863383668, 0xff8c348fbe1c27b3, 0x54d05cc482603884,
    0xa8ac64b8c08cd0c4, 0xb8e0b88800d06008, 0xd08020c0f0a0b000,
    0x60c0200040e08000, 0x4080c0c08040c000, 0x8080000080800000,

    0x0101010001000000, 0x0101010301030000, 0x0707070407010000,
    0x06090608090d0f00, 0x1f0e1f191f121100, 0x1637162d151f1200,
    0x7e192b622a212300, 0x9b2d3143c3cd3eff, 0xfc3256d454524600,
    0x68ec6894645c4800, 0xe830e8a8b8f0d800, 0xb0e0b0c0e0605000,
    0xc060c04060e0a000, 0x8080804080400000, 0x8080808080800000,
    0x0001000000010100, 0x0000000003030300, 0x0002050002050500,
    0x00000f0f0f0f0f0f, 0x0005141f1e01010e, 0x0003303c303f0c3c,
    0x000d0d025d280a20, 0xfffff00f0000ff0f, 0xfef0ba5aea04ea1e,
    0xcccc3cfc0cccfccc, 0x7028085888d078a0, 0x0000f00000f0f0f0,
    0xe040a0e0004040a0, 0xc00000000000c0c0, 0x0080008000800080,

    0x0101010001000000, 0x0101010301030000, 0x0707070407010000,
    0x06090608090d0f00, 0x1f0e1f191f031100, 0x2537251e153d2100,
    0x6f193a262a123200, 0xb9d213343cdce3ff, 0xde32745c54346400,
    0xa4eca45864d48400, 0xe830e8a8b878d800, 0xb0e0b0c0e0605000,
    0xc060c04060e0a000, 0x8080804080400000, 0x8080808080800000,
    0x0001000000010100, 0x0002000003010100, 0x0002050004030300,
    0x000c050f0b0d0d0f, 0x00141b1019171701, 0x002b12132e261531,
    0x00293261777a3e43, 0xff3e2c7e969c27b2, 0x004264c2eef46c86,
    0x308c787c889874c4, 0x4080c89088e8c808, 0x40f040e0f080b000,
    0x8000802000c08000, 0xc000c0c00040c000, 0x0000000000800000,

    0x0001010001000000, 0x0001020302030000, 0x0502030406010000,
    0x0a0c01080b0d0f00, 0x1a1417190d031100, 0x20141a1e093d2100,
    0x602d2e260a123200, 0xb0c53bcbfc231cff, 0xc05a4c5c04346400,
    0x8060785834d48400, 0x80e098a81878d800, 0xf04020c0d0605000,
    0x00c0204020e0a000, 0x0080c040c0400000, 0x0080008000800000,
    0x0000000001010100, 0x0000030303030300, 0x0005060605000505,
    0x000f0f0f0c0c0c00, 0x00150213020d021e, 0x000f03300f0c3c30,
    0x003506065e536d58, 0xff3c0033fffc0030, 0xaa12086e425a8e80,
    0xfcfc3c3cf0f0c000, 0xe8d838e06000d800, 0xf0300000f0c0f0f0,
    0x2080608020c040a0, 0x0000c0c000c0c0c0, 0x0000008000000080,

    0x0001000000000000, 0x0302000300030000, 0x0406000405010000,
    0x070b0f08050d0f00, 0x191c00191a031100, 0x1d18301e103d2100,
    0x277d107325476700, 0xc665d0613576b6ff, 0x5eea20f64a9ece00,
    0x5470c05840d48400, 0xf89050a8d078d800, 0x90d050c0a0605000,
    0xe020a040a0e0a000, 0x40c0004000400000, 0x8000008000800000,
    0x0001000101000100, 0x0001000202000203, 0x0006050303000605,
    0x00040a02020f0709, 0x001c1e020214190a, 0x0027140f3c282200,
    0x003d3d5050683650, 0xff29eaa36f80d85f, 0x442a3ee4e4c06cb4,
    0xb8f02444888078e8, 0xd85068d8d8d08868, 0x90908050a0503070,
    0xa0a0c0a0e0a04080, 0x000080c040c04000, 0x0000800080008000,

    0x0101000000000000, 0x0102030303030000, 0x0203040404010000,
    0x0c0e0808070d0f00, 0x1406081908031100, 0x273b0f1e0c3d2100,
    0x3c49047305476700, 0x188df89e0a8949ff, 0x788218f61a9ece00,
    0xacfc1c5810d48400, 0xe04020a87078d800, 0x4070c0c090605000,
    0xc0804040e0e0a000, 0x80c0404040400000, 0x8000808080800000,
    0x0001000101000101, 0x0000030000030003, 0x0007070707070205,
    0x000f00000f0f0f0f, 0x00000b0f00151a00, 0x0003300f300f0c0f,
    0x0057220075752d5a, 0xffff00f000f000ff, 0xee5404f4ba1e5a5e,
    0xfc3cf0cc3c003c00, 0x70d0f870087888a8, 0x0000f000f00000f0,
    0xa0e040e0a0e040a0, 0x0000c0c000c0c0c0, 0x0080000000000080,

    0x0101010000000000, 0x0101020300030000, 0x0707030405010000,
    0x060601080a0d0f00, 0x1f1f06080b120000, 0x25250b0f312c3000,
    0x3a6f595117304500, 0xecb95d52d6107aff, 0x74dea2b22e708a00,
    0xa4a43c1cc490c000, 0xe8e8102008f05000, 0xb0b020c0f0605000,
    0xc0c0204000e0a000, 0x8080c04000400000, 0x8080008000800000,
    0x0000010000000001, 0x0003020303030001, 0x0001070401040006,
    0x000e09040e040f07, 0x00030e091218111c, 0x003e380d2f2f1117,
    0x001718537124633c, 0xffe9e0a2613b722b, 0x103e20b6f258c678,
    0x10e8f0149cac445c, 0x60281038b0f088e0, 0x80c0e0202090f080,
    0xc040206060e000c0, 0x4080c04040800040, 0x8080008080800080,

    0x0101010000000000, 0x0201010303030000, 0x0302070404010000,
    0x01030608080d0f00, 0x17050e0819120000, 0x2906340f2d2c3000,
    0x3f0e4d5162304500, 0x19048aad43ef85ff, 0x6e1c9ab2d4708a00,
    0xb428e01c9490c000, 0x98386020a8f05000, 0x2010b0c0c0605000,
    0x2060c04040e0a000, 0xc080804040400000, 0x0080808080800000,
    0x0001010001010100, 0x0000000303000303, 0x0003060600030503,
    0x000c030f0c0c0c00, 0x000b0f120c1a1307, 0x00300f003c303c3f,
    0x0063506535050b65, 0xfffc0cc0ff30c303, 0xba2afc5ec46ec098,
    0xfc303c000c00fcf0, 0x883080e8d0d83880, 0x30003030f0f0f0c0,
    0x606060e04040c0c0, 0x00c000c0c0c000c0, 0x8000800000008000,

    0x0001000001000000, 0x0302030301030000, 0x0106040407010000,
    0x0d040808060d0f00, 0x121c19081f120000, 0x2c1b1e0f252c3000,
    0x307c26043a651000, 0xef97cb07ecba2fff, 0x70e85c1874da2000,
    0x907c581ca490c000, 0xf0c0a820e8f05000, 0x6080c0c0b0605000,
    0xe0804040c0e0a000, 0x40c0404080400000, 0x8000808080800000,
    0x0001000100010101, 0x0001030103010102, 0x0003050600030606,
    0x0001090b0c0e0b07, 0x00170a0800020819, 0x002a333f3f330c11,
    0x003b000055005566, 0xff22cc339933aa44, 0x54221044aa44fedc,
    0x98fcec4400445464, 0xb85060d80088b8e8, 0x10607050f0f0e070,
    0x60e080a040402080, 0x808000c080800000, 0x8080000080800000,

    0x0001000001000000, 0x0302000302030000, 0x0103000406010000,
    0x0d010f08040d0f00, 0x120611080d120000, 0x1f38210f392c3000,
    0x211d32044f651000, 0x32d51cf88645d0ff, 0x522a64188eda2000,
    0x5cf0841cf490c000, 0xf010d82048f05000, 0x602050c080605000,
    0xe020a04080e0a000, 0x40c00040c0400000, 0x8000008000800000,
    0x0000010000000000, 0x0000030303000303, 0x0000050707050202,
    0x000f0f0f0f0f000f, 0x000e10151515001f, 0x000c3c3c0f333c03,
    0x00000d07250d7d28, 0xfff00ff0f0f000f0, 0xfee044bebeaebab4,
    0xfcc0c00cc0300cfc, 0x50505820f8787880, 0x00f0f000f0f0f0f0,
    0xe0404040004000a0, 0x0000000000c00000, 0x8080808000000000,

    0x0101000001010100, 0x0102000301010200, 0x0206000107020600,
    0x0c040f02060c0b00, 0x140d11031f140d00, 0x2739123e16140900,
    0x3c1a23137e2d0a00, 0xe7d3c12e9b3a03ff, 0x78244636fc5a0400,
    0xacf448d868603400, 0xe048d828e8e01800, 0x40805030b040d000,
    0xc080a040c0c02000, 0x80c000408080c000, 0x8000008080800000,
    0x0001010001000100, 0x0001010001000103, 0x0006060006050301,
    0x0007070f07050d0e, 0x000c1d101d1a0602, 0x000415102613340c,
    0x00083b307f341d50, 0xff0f2d2f9624ea5f, 0x00107660fe683ab0,
    0x00206440a84ce010, 0x0070f8d0f8d07060, 0x0090905090a06070,
    0x00e0e0a0e0a0e0c0, 0x0080800080008040, 0x0080800080008080,

    0x0100010001010100, 0x0200010302010200, 0x0605070103020600,
    0x040a0602010c0b00, 0x0d1a1f0306140d00, 0x3913253e0b140900,
    0x4f243a13592d0a00, 0x863813d15dc5fcff, 0x8e487436a25a0400,
    0xf44ca4d83c603400, 0x4880e82810e01800, 0x80f0b0302040d000,
    0x8000c04020c02000, 0xc0008040c080c000, 0x0000808000800000,
    0x0000010001010000, 0x0003030300030003, 0x0006050606050003,
    0x000f0c000c030f0f, 0x0003020815091a0d, 0x00303c3f33000f00,
    0x00663d3e08566b0b, 0xff03f00f3cfc3f0c, 0xaa8ede727c44ec0a,
    0xccfc00c00cc0f030, 0x88b0b860e0586860, 0xf0003030c0000000,
    0xa06000e040e08080, 0xc0c0c0c00000c0c0, 0x8000800080808080,

    0x0101010001010100, 0x0202020302010200, 0x0603030106020600,
    0x04010102040c0b00, 0x1c0606030d140d00, 0x28380b3e39140900,
    0x6d1d59464f785f00, 0xb52a5d7b799056ff, 0xca2aa29c8ef0ae00,
    0xb0f03cd8f4603400, 0xc010102848e01800, 0x802020308040d000,
    0x8020204080c02000, 0xc0c0c040c080c000, 0x0000008000800000,
    0x0001010100000100, 0x0002010100030103, 0x0006060605000600,
    0x0007040b0a0c0b0c, 0x00190c181f100910, 0x0011342c251f3d1f,
    0x003358656e305665, 0xff1e60757be364b6, 0x4472f09a9824ec8e,
    0x8890a02c2c0484c8, 0xd8b0e0603058d808, 0x50e08070205050f0,
    0xa020c08020a0a040, 0xc0008000c0c0c080, 0x0000800000000080,

    0x0000000001010100, 0x0000030301010200, 0x0500040102020600,
    0x050f0802030c0b00, 0x0b11080314140d00, 0x01123c3e24140900,
    0x0723404668785f00, 0xf93e8f84406fa9ff, 0x0e46909cd0f0ae00,
    0x0448d0d8a0603400, 0x58d82028b0e01800, 0xa050c0301040d000,
    0xa0a0404060c02000, 0x000040408080c000, 0x0000808080800000,
    0x0001010100000101, 0x0003000300030003, 0x0005020505070200,
    0x000000000f0f000f, 0x000f151e0504150a, 0x00033030333c0303,
    0x005d5f082d757d07, 0xffff0f000fff0f0f, 0xee50f0500054e004,
    0xcc3c00c0fcf0cc0c, 0x5088a020f8580850, 0x0000f0f0f0f0f000,
    0xa040a0a04000e0a0, 0xc0c0c0c0c0c0c0c0, 0x8000808000800080,

    0x0000000001010100, 0x0000030301010200, 0x0500040102020600,
    0x050f0802030c0b00, 0x1a11081205051c00, 0x10210f2f06051800,
    0x703204640e0f7d00, 0x9fe3f84804f69aff, 0xe06418d81c1eea00,
    0x40841c9c28247000, 0xd0d820a038689000, 0xa050c0301040d000,
    0xa0a0404060c02000, 0x000040408080c000, 0x0000808080800000,
    0x0001010100000101, 0x0001020100030201, 0x0003020305010206,
    0x00020c0205010c07, 0x001604071a03040c, 0x00170806230d3b07,
    0x003c0d0f74034959, 0xff240af99bf24eae, 0x10781a0ef81692a2,
    0x205c20389c14dc0c, 0x20b02018e0383000, 0xc0d0c0e080d020f0,
    0x40604020c0606000, 0x804080c040404000, 0x8080800080808000,

    0x0101010001010100, 0x0202020302010200, 0x0603030106020600,
    0x04010102040c0b00, 0x0d0606121c051c00, 0x0a0b382f1b051800,
    0x5e591d647c0f7d00, 0x5ba2d5b7970965ff, 0xaca22ad8e81eea00,
    0x383cf09c7c247000, 0x481010a0c0689000, 0x802020308040d000,
    0x8020204080c02000, 0xc0c0c040c080c000, 0x0000008000800000,
    0x0001010100000100, 0x0000030300030303, 0x0006000005060006,
    0x00030c0300000300, 0x000f0d160f080708, 0x003c0f00003c333c,
    0x0066053d5e3d6868, 0xff0cfc30fcf0030f, 0xba84a20e44ce868a,
    0xccf0fcf0c000c0fc, 0xe8e8b8e858d8d8e8, 0x3000f0f00000f0f0,
    0xe080c020e0e04020, 0xc0c000000000c000, 0x0080800080800000,

    0x0100010001010100, 0x0200010302010200, 0x0605070103020600,
    0x040a0602010c0b00, 0x1c0b1f1206051c00, 0x1b31162f38051800,
    0x7c422b311d5a2800, 0x6883311dd55ccfff, 0xe88456722ab44000,
    0x7cc4689cf0247000, 0xc008e8a010689000, 0x80f0b0302040d000,
    0x8000c04020c02000, 0xc0008040c080c000, 0x0000808000800000,
    0x0000010001010000, 0x0003010302010003, 0x0000030006030005,
    0x00030e0c08010f09, 0x001413100c17150a, 0x0024221c0b291a33,
    0x00683635583e6e55, 0xff8f271a53d44869, 0x54c4386ea47cdcea,
    0xa8b8d084f4545880, 0xb888608808b8e8d0, 0xd0c0b0f0301040a0,
    0x600080404060c0e0, 0x40c0c08040804040, 0x8000008080808080,

    0x0101000001010100, 0x0102000301010200, 0x0206000107020600,
    0x0c040f02060c0b00, 0x051c11121f051c00, 0x361b212f25051800,
    0x4b2932316f5a2800, 0x7e3d1ce2b9a330ff, 0x96426472deb44000,
    0xe87c849ca4247000, 0x68c0d8a0e8689000, 0x40805030b040d000,
    0xc080a040c0c02000, 0x80c000408080c000, 0x8000008080800000,
    0x0001010001000100, 0x0003030003000303, 0x0000000000050507,
    0x000f0f0f0f0f0f00, 0x000a1b1f1b05100a, 0x0000330f00033f00,
    0x00500575270d5f05, 0xff0000f0fff0000f, 0xfeb05e0eb0eefa14,
    0xccc0f030c0f00000, 0x70f00828a028f028, 0x00f0f0f0f000f000,
    0xe000a0e0a0000040, 0xc0000000c0c00000, 0x0000008080800080,

    0x0101010001010100, 0x0101010302010200, 0x0702070106020600,
    0x090c06020b0c0b00, 0x1f050e121c141c00, 0x1505341c18272b00,
    0x7f0f4d757d693900, 0x96098a9565b2edff, 0xfe1e9afaead26200,
    0x6424e05070acbc00, 0xb86860a090e09000, 0xe040b030d040d000,
    0x60c0c04020c02000, 0x80808040c080c000, 0x8080808000800000,
    0x0000000101010101, 0x0000030201020102, 0x0005040203070602,
    0x00050b030206080c, 0x000a0815070e1d05, 0x00300c1a06082509,
    0x0045556a5f0d7b5e, 0xffb5a58ca60a92a7, 0x009aaac4ae1af6bc,
    0x30d000483810a424, 0x403050881860f878, 0x402050f010709090,
    0x8060a00020c0e0e0, 0xc0400000c0408080, 0x0080000000808080,

    0x0000000001010100, 0x0303000301010200, 0x0101000102020600,
    0x0d020f020c0c0b00, 0x1203001214141c00, 0x2c3e031c14272b00,
    0x651301752d693900, 0x45d10d6ac54d12ff, 0xda3602fa5ad26200,
    0x90d80c5060acbc00, 0xf02850a0e0e09000, 0x603050304040d000,
    0xe040a040c0c02000, 0x404000408080c000, 0x8080008080800000,
    0x0001010101000101, 0x0000000303000003, 0x0003060500000605,
    0x000c030c0c0f0c03, 0x000b0f021c0b1518, 0x00000f3c0c3f0330,
    0x0006556d606d3855, 0xff0c0300cff33c3f, 0xaa14f88e5a380c84,
    0xfc0030c03c00cc3c, 0xe838d0d88830d060, 0xf03030f03030f0f0,
    0x2000804060004020, 0x00c000c000c0c000, 0x0080000080800000,

    0x0101000001010100, 0x0101030301010200, 0x0207040107020600,
    0x0c090802090c0b00, 0x050e19120e141c00, 0x36042d1c37272b00,
    0x1e5d6220193c6c00, 0x2b5abcc0d218b8ff, 0x3cbad4503278c800,
    0xe8209450ecacbc00, 0x6830a8a030e09000, 0x40e0c030e040d000,
    0xc060404060c02000, 0x808040408080c000, 0x8080808080800000,
    0x0000010100010000, 0x0000010103010303, 0x0000030305030500,
    0x000f0101090e0903, 0x000516070a131b05, 0x00391b3900112236,
    0x000e680e5033630b, 0xffc443cba01e7d3d, 0x440cd418f0628646,
    0xb8c454dc50800444, 0xd808e830b0d058d8, 0x900040e0e050a050,
    0xa000c02020a0e0a0, 0x0000400000c040c0, 0x0000800000008000,

    0x0100010001010100, 0x0203020302010200, 0x0304030103020600,
    0x010701020e0c0b00, 0x0608171206141c00, 0x383f1a1c3b272b00,
    0x48412e20493c6c00, 0x807d3b3f8de747ff, 0x80924c508278c800,
    0xf0dc7850fcacbc00, 0x107098a040e09000, 0x209020307040d000,
    0x20e0204080c02000, 0xc040c040c080c000, 0x0080008000800000,
    0x0001000101010101, 0x0000030000030300, 0x0007070207000002,
    0x000f000f0f00000f, 0x00111a1a1115041a, 0x0003300c300c3f0c,
    0x0020002d02777778, 0xff00ff0000f0f000, 0xee54be5a541e4ae0,
    0xfc0c0c3cf00cf0f0, 0x70a0708808207070, 0x00f0f00000f000f0,
    0xa0a0004040a0a040, 0x00c000c0c0c000c0, 0x0080000000800000,

    0x0100010001010100, 0x0203020302010200, 0x0304030103020600,
    0x010701020e0c0b00, 0x0608170306050d00, 0x0b3f290d3b363a00,
    0x0c146a021c4b4e00, 0x08d7b3f3d87e74ff, 0x0838c41428968c00,
    0x3cdcb414fce8f800, 0x1070982840681800, 0x209020307040d000,
    0x20e0204080c02000, 0xc040c040c080c000, 0x0080008000800000,
    0x0001000101010101, 0x0002030202010102, 0x0007010207060602,
    0x00090e0309080803, 0x001f12041f1c0d04, 0x00291c0b1a17060b,
    0x002b355c6f6c0a09, 0xff3d255479840cfe, 0x10566ab8cec80412,
    0x10a4701c484c382c, 0x60a8c060d8d04820, 0x80c0b0805050b0c0,
    0xc04080c0a0a08040, 0x4080c0400000c080, 0x8080008000000080,

    0x0101000001010100, 0x0101030301010200, 0x0207040107020600,
    0x0c090802090c0b00, 0x140e19030e050d00, 0x27041e0d37363a00,
    0x695d2602194b4e00, 0xb2a5cb0c2d818bff, 0xd2ba5c1432968c00,
    0xac205814ece8f800, 0xe030a82830681800, 0x40e0c030e040d000,
    0xc060404060c02000, 0x808040408080c000, 0x8080808080800000,
    0x0000010100010000, 0x0000030303030303, 0x0000050503050306,
    0x000f03030f0c0f0f, 0x000a08190d021c12, 0x000c3030330f3300,
    0x000d6006685e5b65, 0xffff0fc3030f303f, 0xbab48ace96f286e4,
    0xfcccfcccc0003cfc, 0x88e0b850e8b03060, 0x30c0f0003030f000,
    0x6040c0e0e000c080, 0x00000000c0c000c0, 0x8080808000808080,

    0x0000000001010100, 0x0303000301010200, 0x0101000102020600,
    0x0d020f020c0c0b00, 0x0312000305050d00, 0x0e2f300d05363a00,
    0x563110575a1e1b00, 0x541dd0a65cd421ff, 0xbc7220beb43c2600,
    0x189cc01424e8f800, 0x78a0502868681800, 0x603050304040d000,
    0xe040a040c0c02000, 0x404000408080c000, 0x8080008080800000,
    0x0001010101000101, 0x0002020101000201, 0x0003060306000603,
    0x0002070e040f0801, 0x000219131d040c06, 0x003f222215083b3b,
    0x000066663b08085d, 0xffcc777711003399, 0x54008898760054aa,
    0x98cc001098005430, 0xb8500030e850e850, 0x10a0f01040504090,
    0x60e04060c0a0c0a0, 0x8040808040c04000, 0x8080808080008000,

    0x0101010001010100, 0x0101010302010200, 0x0702070106020600,
    0x090c06020b0c0b00, 0x1f140e030d050d00, 0x1514070d09363a00,
    0x7f785c575f1e1b00, 0x6990a859562bdeff, 0xfef0b8beae3c2600,
    0x64602c1434e8f800, 0xb8e0602818681800, 0xe040b030d040d000,
    0x60c0c04020c02000, 0x80808040c080c000, 0x8080808000800000,
    0x0000000101010101, 0x0000030003000300, 0x0005020205070002,
    0x000f0f0f00000000, 0x00151f0b1e0f1414, 0x0000303f303f3c33,
    0x007a5f7d5825000a, 0xff0f0ff0ff000000, 0xfefae04e0e0e5040,
    0xfcfc30c0fcc0c0fc, 0x5008f058f0882078, 0x00f0f000f00000f0,
    0xe0a040a040004040, 0x0000c0c0c00000c0, 0x8000008000008000,

    0x0100000001010000, 0x0100000002010300, 0x0205000003020400,
    0x030a0f0f01030800, 0x051a110006050800, 0x351312030b350f00,
    0x4a242301591f0400, 0x8cc7c1f2a2d907ff, 0x94484602a23e1800,
    0xe44c480c3ce41c00, 0x3880d85010382000, 0x10f050502010c000,
    0x6000a0a020604000, 0x80000000c0804000, 0x8000000000808000,
    0x0000000101000100, 0x0003000101000100, 0x0004000603050605,
    0x00040f070d05070a, 0x0008101d171a1d1b, 0x000f231525132621,
    0x0001746e7b342a73, 0xff0194876224c36d, 0x0012e8dcf66854e6,
    0x001c8c64a44ca884, 0x0060d0f8f8d0f888, 0x0080509060a090f0,
    0x00c0a0e0e0a0e000, 0x0040008080008000, 0x0080008080008000,

    0x0101000000010000, 0x0101030000010300, 0x0207040005020400,
    0x0306080f0a030800, 0x051f19000b050800, 0x06251e0331350f00,
    0x0e3a2601421f0400, 0xfb13cb0d8326f8ff, 0x1c745c02843e1800,
    0x28a4580cc4e41c00, 0x38e8a85008382000, 0x10b0c050f010c000,
    0x60c040a000604000, 0x8080400000804000, 0x8080800000808000,
    0x0000000000010101, 0x0003030000030300, 0x0003060000050506,
    0x000f000f0f0c030c, 0x000d190b0b020915, 0x00333f3c0f0f0000,
    0x006d0d3e0d0e563b, 0xff0cc30cf30ffc3c, 0xaa82c874b812441a,
    0xccccc0c0f030c0f0, 0x88885038800058d0, 0xf000f030c0c000c0,
    0xa0004000c0c0e020, 0xc000c0c0c0c000c0, 0x8000008000008080,

    0x0101010001010000, 0x0202010002010300, 0x0303070006020400,
    0x0101060f04030800, 0x06061f001c050800, 0x0b0b16031b350f00,
    0x590c2b54294a5100, 0xa2f731a73d7352ff, 0xa20856a84294b200,
    0x3c3c680c7ce41c00, 0x1010e850c0382000, 0x2020b0508010c000,
    0x2020c0a080604000, 0xc0c08000c0804000, 0x0000800000808000,
    0x0000010100010001, 0x0003020103010301, 0x0005030305030506,
    0x00060d010601090b, 0x001e06160f070a09, 0x002b072b3a09003d,
    0x006d5d6d5e5e0556, 0xff89568667a4fa9b, 0x44cabecef8ec5ea8,
    0x8880e8b8a044940c, 0xd8d038d8b0d8b800, 0x5050d09020a01000,
    0xa0a060a020e06000, 0xc0c04000c0408000, 0x0000800000808000,

    0x0100010000010000, 0x0103020000010300, 0x0701030000020400,
    0x060d010f0f030800, 0x0e03170011050800, 0x343d1a0321350f00,
    0x18122e54324a5100, 0x20dc3b58e38cadff, 0x30344ca86494b200,
    0xe0d4780c84e41c00, 0x60789850d8382000, 0xb06020505010c000,
    0xc0e020a0a0604000, 0x8040c00000804000, 0x8080000000808000,
    0x0001000101010000, 0x0003000000030003, 0x0000050207000507,
    0x0000000000000f00, 0x00141b040e05051a, 0x000c0f033f0c0000,
    0x00252d5f27075a20, 0xfffffff0f000f0f0, 0xeeb4a05afa0e54b0,
    0xccc0fc30303c30f0, 0x50a8a8d0d070d880, 0x00f000f000f000f0,
    0xa0a00000e040e0a0, 0xc0c0c0c000c00000, 0x8080808080008000,

    0x0001000000010000, 0x0002000003010300, 0x0503000004020400,
    0x050e0f0f07030800, 0x1a17001108141900, 0x231903123f241e00,
    0x342f0176413d7300, 0x17c90d947d159eff, 0x684e02ec927af600,
    0x8c740c48dca05800, 0xd0c850d870b0a800, 0xa07050509010c000,
    0xa080a0a0e0604000, 0x00c0000040804000, 0x0000000080808000,
    0x0001000101000000, 0x0002030102000003, 0x0007010607000504,
    0x00090e08090f0a04, 0x001e120c1e111a19, 0x00181f372b21202e,
    0x003d64492c237577, 0xff2a84bec4cd6596, 0x107ad8824856eafe,
    0x20606ccc8ca4b0a8, 0x20f0f05080f8c0f8, 0xc06090a00060b090,
    0x40e0e0a000e080e0, 0x808080000080c080, 0x8080800000800080,

    0x0000000001010000, 0x0303030001010300, 0x0401040002020400,
    0x0702080f0c030800, 0x1912081105141900, 0x2e2f0f1205241e00,
    0x636404760f3d7300, 0x4eb7f86b09ea61ff, 0xd6d818ec1e7af600,
    0x989c1c4824a05800, 0xf8a020d868b0a800, 0x9030c0504010c000,
    0xe04040a0c0604000, 0x4040400080804000, 0x8080800080808000,
    0x0001010101000000, 0x0000000303030000, 0x0003060000030500,
    0x000c030c0c0f000f, 0x000a1e0d0d0d0f0a, 0x00000f0f3c33003c,
    0x00006605363d5e6d, 0xff0f3ffc030cfc00, 0xba1af2a26e62449e,
    0xcc3cf0fcccccc0f0, 0xe80800b850085888, 0x30c0c0f000f00030,
    0xe0c0c0c0e0a0e060, 0xc0c0c00000c00000, 0x0000008080808080,

    0x0100010000010000, 0x0200010003010300, 0x0605070001020400,
    0x0405060f02030800, 0x0d1a0e1103141900, 0x0a1007123e241e00,
    0x5e705c2313682600, 0xa460a8c1d1bfcbff, 0xace0b84636d05c00,
    0x38402c48d8a05800, 0x48d060d828b0a800, 0x80a0b0503010c000,
    0x80a0c0a040604000, 0xc000800040804000, 0x0000800080808000,
    0x0001010100010001, 0x0001020200020002, 0x0003060605030506,
    0x000e080805020507, 0x00020c1d1a031a08, 0x003338292f0d1c33,
    0x00500d3e60036005, 0xff6335248c0e4039, 0x54f44a2cd012c05a,
    0xa8a44cc4ac104060, 0xb8e8d008e060d0b0, 0xd080a0f080b0a0d0,
    0x60c0e040c080e060, 0x4080408080c04040, 0x8080808080008080,

    0x0101010001010000, 0x0201020001010300, 0x0307030007020400,
    0x0109010f09030800, 0x061f06110e141900, 0x0b260b1204241e00,
    0x0c3b59235d682600, 0xf7e15d3e5a4034ff, 0x0876a246bad05c00,
    0x3ca83c4820a05800, 0x10b810d830b0a800, 0x20e02050e010c000,
    0x206020a060604000, 0xc080c00080804000, 0x0080000080808000,
    0x0000010001000000, 0x0003030300030303, 0x0002050702020207,
    0x000f000f0000000f, 0x000f1e1505101004, 0x0030303c033f0c3c,
    0x007f08070d0a7d25, 0xff00f0ffff0f0f00, 0xfeaeb0b0f05ef40a,
    0xcc3c0030ccc0c0cc, 0x7070200028282888, 0x00f0f0000000f0f0,
    0xe040a0404040a0e0, 0xc0c0c0c00000c0c0, 0x0000800080808000,

    0x0001000000010000, 0x0002000003010300, 0x0503000004020400,
    0x050e0f0f07030800, 0x0b17001108051900, 0x321930213f062d00,
    0x437a1067145b3700, 0x719cd049d751e9ff, 0x86e420ce38b67e00,
    0xc874c084dc289400, 0x58c850d87038a800, 0xa07050509010c000,
    0xa080a0a0e0604000, 0x00c0000040804000, 0x0000000080808000,
    0x0001000101000000, 0x0002030102000003, 0x0007010607000504,
    0x00090e08090f0a04, 0x001e021d1e101a09, 0x00280f161b20233d,
    0x0028016a39707116, 0xffcffe7c21909e17, 0x004012d462e0e22c,
    0x30802c587c80bcc4, 0x40d020b890d0c058, 0x40a0c02010504050,
    0x80a0406020a080a0, 0xc0008040c000c000, 0x0000808000000000,

    0x0000000001010000, 0x0303030001010300, 0x0401040002020400,
    0x0702080f0c030800, 0x1903081114051900, 0x2e3e3c2114062d00,
    0x36464067785b3700, 0xe47b8fb690ae16ff, 0x7c9c90cef0b67e00,
    0x98d8d08460289400, 0xf82820d8e038a800, 0x9030c0504010c000,
    0xe04040a0c0604000, 0x4040400080804000, 0x8080800080808000,
    0x0001010101000000, 0x0000000303030000, 0x0003060000030500,
    0x000c030c0c0f000f, 0x000b1e1c1c1c0f0b, 0x00333c0c3f00033f,
    0x00605560536d5838, 0xfff3cf30cfcf03f3, 0xaa2634f03c44e6c6,
    0xfc30ccc0f00c0000, 0xe838e060d880d888, 0xf0f0c0c0c0f0f0f0,
    0x20c0404020a040a0, 0x00000000c0c0c0c0, 0x0080808080800080,

    0x0100010000010000, 0x0200010003010300, 0x0605070001020400,
    0x0405060f02030800, 0x1c0b0e1112051900, 0x280134212f062d00,
    0x6d074d32310e6200, 0x4a068a1c1dfbbcff, 0xca0e9a64721cd400,
    0xb004e0849c289400, 0xc05860d8a038a800, 0x80a0b0503010c000,
    0x80a0c0a040604000, 0xc000800040804000, 0x0000800080808000,
    0x0001010100010001, 0x0001020200020002, 0x0003060605030506,
    0x000e080805020507, 0x00130d1c1b021b08, 0x00110a1b2d3c1e00,
    0x00330b3833053350, 0xff1ef2e32e3ae2af, 0x44625224325e32e4,
    0xb8809c04e0542c48, 0xd8d0b05860e86088, 0x905010a080407000,
    0xa0a060e0c0c08000, 0x00c0804080400000, 0x0000808080800000,

    0x0101010001010000, 0x0201020001010300, 0x0307030007020400,
    0x0109010f09030800, 0x061f06110e051900, 0x3826382104062d00,
    0x483b1d325d0e6200, 0x7f1ed5e3a50443ff, 0x80762a64ba1cd400,
    0xf0a8f08420289400, 0x10b810d83038a800, 0x20e02050e010c000,
    0x206020a060604000, 0xc080c00080804000, 0x0080000080808000,
    0x0000010001000000, 0x0003030300030303, 0x0002050702020207,
    0x000f000f0000000f, 0x001e0f0404000015, 0x0000300f330c3f0f,
    0x002d2f572f0d7a75, 0xfff00ff0f000000f, 0xeeaa104afa0ab0f0,
    0xfcfcf000003c0cfc, 0x70a8d080f0782808, 0x0000000000f0f000,
    0xa000e000e040a040, 0x00c00000c0c0c0c0, 0x0080800000008000,

    0x0100000001010000, 0x0100000002010300, 0x0205000003020400,
    0x030a0f0f01030800, 0x140b110006140800, 0x1731213038173c00,
    0x2c4232101d794000, 0xc87c1c2f2a9d70ff, 0x588464202af29000,
    0x6cc484c0f06cd000, 0xb008d85010b02000, 0x10f050502010c000,
    0x6000a0a020604000, 0x80000000c0804000, 0x8000000000808000,
    0x0000000101000100, 0x0003000101000100, 0x0004000603050605,
    0x00040f070d05070a, 0x0018110d071b0d1b, 0x001c223506110622,
    0x0060271e0f635a77, 0xff80c91806825c96, 0x10d04e3c0ec6a4fe,
    0x1050b8d4084438a8, 0x60e09868588818a8, 0x8080e0705000e0c0,
    0xc0c020c0a0002040, 0x4040c0400000c080, 0x8080008000000080,

    0x0101000000010000, 0x0101030000010300, 0x0207040005020400,
    0x0306080f0a030800, 0x141f19001a140800, 0x24162d3013173c00,
    0x682b621024794000, 0xbf31bcd038628fff, 0xd056d42048f29000,
    0xa06894c04c6cd000, 0xb0e8a85080b02000, 0x10b0c050f010c000,
    0x60c040a000604000, 0x8080400000804000, 0x8080800000808000,
    0x0000000000010101, 0x0003030000030300, 0x0003060000050506,
    0x000f000f0f0c030c, 0x001c090a0a131914, 0x00000c3f0c0f0330,
    0x003d0e6b586d605d, 0xffcf0cff003c3c3f, 0xbaa4142ce0e2ec94,
    0xfc3c003000fccc3c, 0x88606838d0680050, 0x30f030f0f0f00030,
    0x6020e0c040200080, 0x0000c000c0000000, 0x8000008000000000,

    0x0101010001010000, 0x0202010002010300, 0x0303070006020400,
    0x0101060f04030800, 0x06061f000d140800, 0x3838253039173c00,
    0x1d483a451a2c1500, 0x2a7f137ad33725ff, 0x2a80748a24583a00,
    0xf0f0a4c0f46cd000, 0x1010e85048b02000, 0x2020b0508010c000,
    0x2020c0a080604000, 0xc0c08000c0804000, 0x0000800000808000,
    0x0000010100010001, 0x0003020103010301, 0x0005030305030506,
    0x00060d010601090b, 0x000e06061f171b19, 0x003b37082a2a111d,
    0x0008085d3b6e3366, 0xff3333aadd881144, 0x544454fe76cc76cc,
    0x987454545488a874, 0xb888b8b8b8d8b888, 0x1030e010e0502030,
    0x6040206020a02040, 0x8040008000c0c040, 0x8080008000000080,

    0x0100010000010000, 0x0103020000010300, 0x0701030000020400,
    0x060d010f0f030800, 0x0e12170011140800, 0x071f293012173c00,
    0x09216a45232c1500, 0x02cdb3853ec8daff, 0x1252c48a46583a00,
    0x2c5cb4c0486cd000, 0x60f09850d8b02000, 0xb06020505010c000,
    0xc0e020a0a0604000, 0x8040c00000804000, 0x8080000000808000,
    0x0001000101010000, 0x0003000000030003, 0x0000050207000507,
    0x0000000000000f00, 0x00051b050f14040a, 0x000f0c330c0f0030,
    0x00002f7d07220d25, 0xffff00ff0000f000, 0xfeea4e500e50ea1a,
    0xfcf03cfc0c0cfccc, 0x5020f05850f828f8, 0x0000f0f0f0f0f000,
    0xe00040004000e0e0, 0x00c0c0c0000000c0, 0x8080008080008000,

    0x0100000001000100, 0x0200000002030100, 0x0305050503010200,
    0x010a0a0501020c00, 0x171a0b0b06120500, 0x1a1331010b2f0500,
    0x2e24425259640f00, 0xc4c78353a2b709ff, 0x4c4884a4a2d81e00,
    0x784cc4043c9c2400, 0x9880085810a06800, 0x20f0f0a020304000,
    0x200000a02040c000, 0xc0000000c0408000, 0x0000000000808000,
    0x0001000101000100, 0x0001000102000100, 0x0006050607000600,
    0x00080a07060f070f, 0x000d1b1d0f011d01, 0x000512153a322632,
    0x000b626e4a122a47, 0xff027c87b31cc3b6, 0x0016c4dc8424548e,
    0x00244864f8c8a8c8, 0x002888f84858f858, 0x00c0f090b0509050,
    0x004000e080a0e0a0, 0x00800080c0008000, 0x0080008000008000,

    0x0100010000000100, 0x0203010000030100, 0x0601020500010200,
    0x0b0d03050f020c00, 0x1c03050b11120500, 0x183d3501212f0500,
    0x28121f5232640f00, 0x30dc26ace348f6ff, 0x40343ea464d81e00,
    0x70d4e404849c2400, 0x90783858d8a06800, 0xd06010a050304000,
    0x20e060a0a040c000, 0xc040800000408000, 0x0080800000808000,
    0x0001000100000001, 0x0000000003030003, 0x0006050606060500,
    0x000c0f0c0f000f03, 0x0004140403190516, 0x00003f33033f0c30,
    0x005d063b000d0608, 0xfff0cff003c3fcc0, 0xaa4ec2c606c8b4d0,
    0xccf0f00c00c0c0c0, 0x883830d05850b830, 0xf000f00000f0c030,
    0xa060c0e0e040a000, 0xc0c0000000c000c0, 0x8000808080000080,

    0x0101010000000100, 0x0201020000030100, 0x0307060505010200,
    0x010604050a020c00, 0x061f0d0b0b120500, 0x0b253901312f0500,
    0x593a4f0742315a00, 0x5d138606831d5cff, 0xa2748e0e8472b400,
    0x3ca4f404c49c2400, 0x10e8485808a06800, 0x20b080a0f0304000,
    0x20c080a00040c000, 0xc080c00000408000, 0x0080000000808000,
    0x0001010000000100, 0x0001020000030103, 0x0003060005050300,
    0x000e080f0509010c, 0x00131c050b1b0710, 0x00222b3a0e223a1f,
    0x0036680e53635e30, 0xffd783c8a27268e3, 0x4478d40ce292fc24,
    0x8850a4f87c2c9804, 0xd8b0b858d030b858, 0x50e0d09090d0e050,
    0xa02060a0a06020a0, 0xc0004000004000c0, 0x0000800000800000,

    0x0001000001000100, 0x0302030002030100, 0x0103010506010200,
    0x02010d0504020c00, 0x0306030b1c120500, 0x0d0b3d011b2f0500,
    0x020c120729315a00, 0xf3f723f93de2a3ff, 0x1408340e4272b400,
    0x143cd4047c9c2400, 0x28107858c0a06800, 0x302060a080304000,
    0x4020e0a08040c000, 0x40c04000c0408000, 0x8000800000808000,
    0x0001010101000001, 0x0003030303030300, 0x0000000500020707,
    0x000f0f0f0f0f0f0f, 0x001b1b000a0e0401, 0x0003303f03333c30,
    0x0025077f077a7527, 0xfff00ff00f0000ff, 0xeebe404a04a0baf0,
    0xccf0f0c00c3c3c00, 0x50887000507808f0, 0x000000f000f0f0f0,
    0xa040a0e0a040a000, 0xc0c000c0c0c00000, 0x8000000080000000,

    0x0100000001000100, 0x0200000002030100, 0x0305050503010200,
    0x010a0a0501020c00, 0x170b1a1a06031400, 0x29311310383e1400,
    0x6a4224251d467800, 0x4c7c38352a7b90ff, 0xc484484a2a9cf000,
    0xb4c44c40f0d86000, 0x980880d01028e000, 0x20f0f0a020304000,
    0x200000a02040c000, 0xc0000000c0408000, 0x0000000000808000,
    0x0001000101000100, 0x0001000102000100, 0x0006050607000600,
    0x00080a07060f070f, 0x000c0b1d1e001d00, 0x000431251b031603,
    0x0058462e3c016a54, 0xff5047c82b018cab, 0x10b08c4c7802c4b8,
    0x2020f4b46c0c481c, 0x20204898f0008860, 0xc0c040e090f00070,
    0x40408020e00000c0, 0x8080c0c080000040, 0x8080000080000080,

    0x0100010000000100, 0x0203010000030100, 0x0601020500010200,
    0x0b0d03050f020c00, 0x0d12141a11031400, 0x091f1710123e1400,
    0x0a21792523467800, 0x03cd62ca3e846fff, 0x0452f24a469cf000,
    0x345c6c4048d86000, 0x18f0b0d0d828e000, 0xd06010a050304000,
    0x20e060a0a040c000, 0xc040800000408000, 0x0080800000808000,
    0x0001000100000001, 0x0000000003030003, 0x0006050606060500,
    0x000c0f0c0f000f03, 0x0005050502191416, 0x00000f33333c3c00,
    0x000b556d360e5568, 0xfff303f30f3c30cf, 0xbaa0e82862749e4a,
    0xcccc3000f030300c, 0xe888e05060d808d8, 0x300000000030c000,
    0xe00080e08080c0e0, 0xc000c000c000c000, 0x0000808080000080,

    0x0101010000000100, 0x0201020000030100, 0x0307060505010200,
    0x010604050a020c00, 0x061f1c1a1a031400, 0x38161b10133e1400,
    0x1d2b7c7024132d00, 0xd531686038d1c5ff, 0x2a56e8e048365a00,
    0xf0687c404cd86000, 0x10e8c0d08028e000, 0x20b080a0f0304000,
    0x20c080a00040c000, 0xc080c00000408000, 0x0080000000808000,
    0x0001010000000100, 0x0001020000030103, 0x0003060005050300,
    0x000e080f0509010c, 0x00021d041a0a1710, 0x0000290b1c33291c,
    0x00053e5d60553e35, 0xfffa24594069d41a, 0x544e2cbac0ea7c6e,
    0xa8b4c4d040805484, 0xb8880830d0d0b888, 0xd0c0f010a0a010f0,
    0x60004060e0e06040, 0x40c0808040408080, 0x8000808080808080,

    0x0001000001000100, 0x0302030002030100, 0x0103010506010200,
    0x02010d0504020c00, 0x1206121a0d031400, 0x1c381f10393e1400,
    0x204821701a132d00, 0x3f7f329fd32e3aff, 0x508052e024365a00,
    0x50f05c40f4d86000, 0xa010f0d04828e000, 0x302060a080304000,
    0x4020e0a08040c000, 0x40c04000c0408000, 0x8000800000808000,
    0x0001010101000001, 0x0003030303030300, 0x0000000500020707,
    0x000f0f0f0f0f0f0f, 0x001b1b100a0f1511, 0x0033000c33030f00,
    0x0005277d27082522, 0xffff00000000fff0, 0xfea04eea1a04a0a4,
    0xcc3c0cfcc03cccc0, 0x7078d028f070d888, 0x00f0f0f0000000f0,
    0xe04040e0e0a0a0e0, 0xc0c00000c000c0c0, 0x0000808000008000,

    0x0001000000000100, 0x0002000003030100, 0x0503050504010200,
    0x0a0e0a0507020c00, 0x0b170b1a08121400, 0x311902233f1c2700,
    0x172f063441203c00, 0x29c90be87d3fe7ff, 0x2e4e0c6892507800,
    0xc474088cdc50ac00, 0x08c808d070a0e000, 0xf070f0a090304000,
    0x008000a0e040c000, 0x00c0000040408000, 0x0000000080808000,
    0x0000010100000001, 0x0003020103000001, 0x0001070601050506,
    0x000e09080e0a0a08, 0x00020f0c131a1a0c, 0x003c0a072d231007,
    0x00100a597624350c, 0xffeffc5e98cb250b, 0x003004b2ec587a08,
    0x30e0081cb4ac500c, 0x4020086098a0e000, 0x40300070e0c070f0,
    0x804000c02040c000, 0xc0800040c0804000, 0x0080008000808000,

    0x0001010001000100, 0x0301010001030100, 0x0107020507010200,
    0x0209030509020c00, 0x031f051a0e121400, 0x0d260623041c2700,
    0x573b0e345d203c00, 0x59e1fb175ac018ff, 0xbe761c68ba507800,
    0x14a8288c2050ac00, 0x28b838d030a0e000, 0x30e010a0e0304000,
    0x406060a06040c000, 0x4080800080408000, 0x8080800080808000,
    0x0001000000010001, 0x0003030303000303, 0x0005030306060605,
    0x00030f0f000c000c, 0x00181c0d09151802, 0x000300003c303c3c,
    0x0066380b6b0b0d38, 0xff3f30030c3c3fff, 0xaae210109a6a64da,
    0xfcf0f03cc0000c3c, 0xe830d058e080d088, 0xf000c030c000f0c0,
    0x20602080400040c0, 0x00c0c0000000c0c0, 0x0000800080000000,

    0x0100010001000100, 0x0103020001030100, 0x0701060502010200,
    0x090204050c020c00, 0x0e120d1a05121400, 0x372f0a23051c2700,
    0x4c645e610f756900, 0x87b7a4bd0995b2ff, 0x98d8acc21efad200,
    0xec9c388c2450ac00, 0x30a048d068a0e000, 0xe03080a040304000,
    0x604080a0c040c000, 0x8040c00080408000, 0x8080000080808000,
    0x0000010101010000, 0x0003010102020000, 0x0000030606060505,
    0x00030e0408070a05, 0x0014130d1c080f0a, 0x001422051b33363c,
    0x006d335b6d050e00, 0xffb5d25e49c9c83f, 0x448a62a2da1a0c44,
    0xb8cc4cc060e0c878, 0xd800d050b0605888, 0x90f0a0a0d0805030,
    0xa040e0e060c0a040, 0x008040404080c040, 0x0080808080800080,

    0x0000000000000100, 0x0300030003030100, 0x0405010501010200,
    0x08050d0502020c00, 0x081a031a03121400, 0x0f100e233e1c2700,
    0x0470566113756900, 0xf8605442d16a4dff, 0x18e0bcc236fad200,
    0x1c40188cd850ac00, 0x20d078d028a0e000, 0xc0a060a030304000,
    0x40a0e0a04040c000, 0x4000400040408000, 0x8000800080808000,
    0x0001010100010000, 0x0000030000030003, 0x0002000205050507,
    0x000f0000000f0f0f, 0x000b04150b000415, 0x003f0c330f0f300f,
    0x002d0058580f7875, 0xffff0ff000fff0f0, 0xeee01e14b4e4401e,
    0xfc3c3cccfcccc000, 0x70a850f0d0505078, 0x00f000f000000000,
    0xa0e0e000e0a0a0e0, 0x0000000000c0c0c0, 0x0080800080808000,

    0x0001000000000100, 0x0002000003030100, 0x0503050504010200,
    0x0a0e0a0507020c00, 0x1a171a0b08030500, 0x131920323f0d3600,
    0x717a604314024b00, 0x929cb08ed7f37eff, 0xe2e4c08638149600,
    0x4c7480c8dc14e800, 0x80c8805870286800, 0xf070f0a090304000,
    0x008000a0e040c000, 0x00c0000040408000, 0x0000000080808000,
    0x0000010100000001, 0x0003020103000001, 0x0001070601050506,
    0x000e09080e0a0a08, 0x00121f0d030a0a0d, 0x001c1a060d003306,
    0x00356f0a5300115f, 0xff25790c52f01e59, 0x106ace04b60032be,
    0x107048381400dc18, 0x60c0d84838003068, 0x80b050b0d0f02070,
    0xc080a080600060c0, 0x40c000c040004040, 0x8000000080008080,

    0x0001010001000100, 0x0301010001030100, 0x0107020507010200,
    0x0209030509020c00, 0x121f140b0e030500, 0x1c262432040d3600,
    0x753b68435d024b00, 0x951ebf71a50c81ff, 0xfa76d086ba149600,
    0x50a8a0c82014e800, 0xa0b8b05830286800, 0x30e010a0e0304000,
    0x406060a06040c000, 0x4080800080408000, 0x8080800080808000,
    0x0001000000010001, 0x0003030303000303, 0x0005030306060605,
    0x00030f0f000c000c, 0x00080d1c09141813, 0x003033333f303f3c,
    0x0060685b685d0e0b, 0xff0f0330f33fc03c, 0xba8a96863694c87a,
    0xfcfcc03c003ccc00, 0x88b8e830385058b0, 0x30f030f03030f0c0,
    0x60c0e0c0008040a0, 0x0000c000c000c000, 0x8080008080000000,

    0x0100010001000100, 0x0103020001030100, 0x0701060502010200,
    0x090204050c020c00, 0x0e031c0b14030500, 0x373e2832140d3600,
    0x4c466d1678571e00, 0x787b4adb90592bff, 0x989cca2cf0be3c00,
    0xecd8b0c86014e800, 0x3028c058e0286800, 0xe03080a040304000,
    0x604080a0c040c000, 0x8040c00080408000, 0x8080000080808000,
    0x0000010101010000, 0x0003010102020000, 0x0000030606060505,
    0x00030e0408070a05, 0x0015020c1d081f1b, 0x002600041900152e,
    0x003b00083b006e33, 0xffddff00eeffbbdd, 0x5476441032548866,
    0x9854b82010a8cc44, 0xb8e8d86030e80088, 0x10406080108000f0,
    0x60c0e0c060c00040, 0x8040808080800080, 0x8080808080800080,

    0x0000000000000100, 0x0300030003030100, 0x0405010501010200,
    0x08050d0502020c00, 0x080b120b12030500, 0x3c012c322f0d3600,
    0x4007651631571e00, 0x8f0645241da6d4ff, 0x900eda2c72be3c00,
    0xd00490c89c14e800, 0x2058f058a0286800, 0xc0a060a030304000,
    0x40a0e0a04040c000, 0x4000400040408000, 0x8000800080808000,
    0x0001010100010000, 0x0000030000030003, 0x0002000205050507,
    0x000f0000000f0f0f, 0x000b05141b101504, 0x000c0f330c3c003c,
    0x000a550a7a0d2f25, 0xff0fffffff0ff00f, 0xfe1a40be1a44ae04,
    0xfc0c0c003cc0fcf0, 0x5028d8285858a0f8, 0x0000f0f000f000f0,
    0xe04040a0e0400040, 0x000000c00000c0c0, 0x8080808080808000
};



} // namespace pbrt


