/*
 * Compute a second octave of a 16D SZ sequence using an alpha.
 * We use the alphabet of the teaser figure; whose primitives are:
 *
 *     ..1. 1.1. .11. 111. 1..1 11.1 ..11 1111
 *     ...1 .1.1 11.1 1..1 .111 1.11 ..1. 1.1.
 *     .11. .1.. .111 .1.1 1111 111. 1.11 1...
 *     11.1 11.. 111. 1111 1.1. 1..1 .11. .1..
 *
 */

#include <stdio.h>

const int alpha = 0x13A5;

inline int MxV(int M, int V) {
    return (
        ( V &       1) * ( M        & 0xf) ^
        ((V >> 1) & 1) * ((M >>  4) & 0xf) ^
        ((V >> 2) & 1) * ((M >>  8) & 0xf) ^
        ((V >> 3) & 1) * ((M >> 12) & 0xf)
    );
}

inline int I(int i) { return MxV(0x1248, i); }

void sz16(int alpha, int i, int *p) {
    p[0] = (I(i & 0xf) << 4) | I(i >> 4);
    for (int d = 1, x = I(i >> 4); d < 16; d++) {
        p[d] = p[0] ^ (x << 4);
        x = MxV(alpha, x);
    }
}

int main(int argc,char **argv) {
    int p[16];
    for (int i = 0; i < 256; i++) {
        sz16(alpha, i, p);
        for (int d = 0; d < 16; d++) {
            printf("%3d ", p[d]);
        }
        printf("\n");
    }
}
