/*
 * Miscellaneous tests on sz sequences
 */

#include "sz.h"
#include <vector>
#include <string>
#include <getopt.h>

// =============================================================================
// Reverse Engineer an SZ sequence, if it is
// =============================================================================

Alphabet getAlphabet(const Sequence &seq) {
    TupleR C = seq;
    int dims = C.size();
    int q = __builtin_ctz(dims);
    TupleR x(dims);
    for (int dim = 0; dim < dims; dim++) {
        x[dim] = C[dim].getBlock(0, 0, q).inverse() * C[dim].getBlock(0, q, q);
    }
    return Alphabet{q, x};
}


// =============================================================================
// Main
// =============================================================================

const char *USAGE_MESSAGE = "Usage: %s <q> [options]\n"
"Options:\n"
" -R            Randomize the matrices; default no\n"
" -V            Verify the construction, default no\n"
" -E            Ensemble, default is nest only\n"
;

int main(int argc,char **argv) {
    clock_t t0 = clock();
    int opt;
    bool randomize = false;
    bool verify = false;
    bool ensemble = false;
    while ((opt = getopt(argc, argv, "RVE")) != -1) {
        switch (opt) {
            case 'R': randomize = true; break;
            case 'V': verify = true; break;
            case 'E': ensemble = true; break;
            default: fprintf(stderr, USAGE_MESSAGE, argv[0]); exit(1);
        }
    }
    if (optind > argc - 1) {
        fprintf(stderr, USAGE_MESSAGE, argv[0]);
        exit(1);
    }
    int q = atoi(argv[optind]);
//     //SZ sz(q, randomize, verify);
//     //SZ sz(q, true, true);
//     SZ sz = SZ::makeNested(1, 2, ensemble, randomize);
//     sz.scanEnsembles(1, stdout, true);
//     //sz.printf(stdout, "Here we go:");
//     sz.printf(stdout);
//     //sz.printC32();
    //Sequence(16, SobolColumnMatrices).printf(stdout, "Sobol\n");
    //Sequence(16, SZTeaserFigColMatrices).printf(stdout, "SZTeaser\n");

    SZ szTeaser(Sequence(16, SZTeaserFigColMatrices));
    //SZ szSobol(Sequence(16, SobolColumnMatrices));
    //fprintf(stderr, "szSobol dims = %d\n", szSobol.getDims());

    //Alphabet x = getAlphabet(Sequence(16, SZTeaserFigColMatrices));
    //MatrixR::printf(TupleR(x), stdout, "Alphabet extracted from matrices:");

    Alphabet a = szTeaser.getAlphabet();
    MatrixR::printf(TupleR(a), stdout, "alphabet from cast seq:");
    MatrixR::printf(a.primitives(), stdout, "Primitives:");
    //a.upsample();
    MatrixR alpha = a.primitives()[0];
    MatrixR x = MatrixR::I(4);
    TupleR t{ MatrixR::I(8) };
    for (int i = 0; i < 15; i++) {
        t.push_back(t[0].putBlock(0, 4, x));
        x = alpha * x;
    }
    MatrixR::printf(t);

//     SZ tz256 = szTeaser.upsample();
//     tz256.printf(stdout);
//     tz256.scanEnsembles(1, stderr, true);


    //szTeaser.scanEnsembles(1, stdout, true);
    //MatrixR::printf(a4.upsample().generators(32), stdout);


//     printf("sz is%s a (0, 256)-sequence\n", MatrixR::seqMatch(sz, 8) ? "" : " NOT");
//     printf(
//         "sz[20, 21] is%s a (0, 1)-sequence\n",
//         MatrixR::seqMatch({sz[20], sz[21]}, 1, false, stdout) ? "" : " NOT"
//     );
//     printf(
//         "sz[0, 1, 2, 3] is%s a (0, 4)-sequence\n",
//            MatrixR::seqMatch({sz[0], sz[1], sz[2], sz[3]}, 2, false, stdout) ? "" : " NOT"
//     );

//     Alphabet a1{1};
//     MatrixR::printf(a1, stdout, "\na1:");
//
//     Alphabet a2 = a1.upsample();
//     MatrixR::printf(a2, stdout, "\na2 complete:");
//
//     Alphabet a4 = a2.upsample();
//     //MatrixR::printf(a4, stdout, "\na4 complete:");
//
//     Alphabet a8 = a4.upsample();
//     //MatrixR::printf(a8, stdout, "\na8 complete:");

//     Alphabet a16 = a8.upsample();
//     MatrixR::printf(a16, stdout, "\na16 complete:");

    //Sequence sobol = Sequence::Sobol();
    //sobol.printf(stdout);
    //sobol.netMatches(true);

//     int N = 4096;
//     Points p(N);
//     for (int i = 0; i < N; i++) {
//         p[i] = {sz(i, 0), sz(i, 1)};
//     }
//     owenScramble(p);
//     printTxt(p, "test.txt");

    clock_t t1 = clock();
    double totalTime = (double)(t1 - t0) / CLOCKS_PER_SEC;
    fprintf(stderr, "totalTime = %10.2f\n", totalTime);
}
