/*
 * Enumerate alphabets via direct upsampling
 */

#include <vector>
#include <string>
#include <getopt.h>
#include "alphabet.h"

std::vector<Alphabet> upsample(Alphabet nested) {
    clock_t t0 = clock();
    int m = nested.getm();
    MatrixR::printf(nested, stdout, "Nested:");
    TupleR t = nested;
    std::vector<Alphabet> alphabets;
    std::vector<MatrixR> alpha;
    int nTested(0), nPassed(0), nDistinct(0);
    MatrixR::printf(nested.upsample(false), stdout, "Base:");
    for (int i = 0; i < (1 << (3 * m)); i++) {
        int tl(i & msk(m)), tr((i >> m) & msk(m)), bl((i >> (2*m)) & msk(m));
        if (tl * tr * bl == 0) continue;
        nTested++;
        Alphabet alphabet = nested.upsample(false);
        MatrixR topLeft    = t[tl];
        MatrixR topRight   = t[tr];
        MatrixR bottomLeft = t[bl];
        MatrixR cnddt = (
            MatrixR(2 * m)
            .putBlock(0, 0, topLeft)
            .putBlock(0, m, topRight)
            .putBlock(m, 0, bottomLeft)
        );
        alphabet += cnddt;
        if (alphabet) {
            nPassed++;
            int index = findOrInsert(alphabet.primitives()[0], alpha);
            if (index == nDistinct) {
                alphabets.push_back(alphabet);
                nDistinct++;
            }
            ///* TEST */ return alphabets;
        }
        fprintf(
            stderr, "\rtested: %d, passed: %d, distinct: %d%20s",
            nTested, nPassed, nDistinct, ""
        );
    }
    fprintf(stderr, "\n");
    clock_t t1 = clock();
    double totalTime = (double)(t1 - t0) / CLOCKS_PER_SEC;
    printf(
        "m = %d, nested alphabets count =  %d, totalTime = %10.2f\n",
        m, alphabets.size(), totalTime
    );
    for (int i = 0; i < alphabets.size(); i++) {
        MatrixR::printf(alphabets[i], stdout, "\n");
    }
    return alphabets;
}



// =============================================================================
// Main
// =============================================================================

const char *USAGE_MESSAGE = "Usage: %s <q> [options]\n"
"Options:\n"
;

int main(int argc,char **argv) {
    int opt;
    int N = 1024;
    int n = 1;
    while ((opt = getopt(argc, argv, "P:n:N:O")) != -1) {
        switch (opt) {
            default: fprintf(stderr, USAGE_MESSAGE, argv[0]); exit(1);
        }
    }
    if (optind > argc - 0) {
        fprintf(stderr, USAGE_MESSAGE, argv[0]);
        exit(1);
    }

    Alphabet a3(3);
    a3.complete();
    MatrixR::printf(a3, stdout, "a3:");

    //upsample(a3);

    Alphabet a6 = a3.upsample();
    MatrixR::printf(a6, stdout, "a6 Completed:");

//     Alphabet a2{2};
//     a2.complete();
// //     MatrixR::printf(a2, stdout, "a2:\n");
// //     MatrixR::printf(a2.generators(16), stdout, "a2 generators:\n");
//
//     std::vector<Alphabet> a4List = upsample(a2);
//
//     Alphabet a8 = upsample(a4List[0])[0];
//     a8.nestSort();
//     TupleR g = a8.generators(16);

}
