#include "huff_heap.hpp"

#include <queue>

int hheap_size(HHeap& h) {
  return h.size() ;
}

HArbre* hheap_min(HHeap& h) {
  return h[0] ;
}

static bool huff_comp(HArbre* a1, HArbre* a2) {
  return huff_poids(a1) > huff_poids(a2) ;
}

void hheap_pop(HHeap& h) {
  std::pop_heap(h.begin(), h.end(), huff_comp) ;
  h.pop_back() ;
}

void hheap_push(HHeap& h, HArbre* a) {
  h.push_back(a) ;
  std::push_heap(h.begin(), h.end(), huff_comp) ;
}
