#ifndef HUFFMAN_HPP
#define HUFFMAN_HPP

#include <string>
#include <vector>

struct HArbre {
  /* votre code ici */
} ;

/*** interface pour huff_heap ***/

/* Poids d'un arbre de huffman
 */
int huff_poids(HArbre* a) ;

/*** construction ***/

/* Construction a partir d'un caractere
 *  - c est le caractere
 *  - poids est le nombre d'apparitions du caractere
 *
 * Rq : l'arbre retourne est alloue sur la pile et devra etre detruit a l'aide
 * de la fonction huff_delete.
 */
HArbre* huff_new_char(char c, int poids) ;

/* Construction a partir des deux enfants
 *   - gauche et droite sont les enfants du nouveau noeud
 *
 * Rq : l'arbre retourne est alloue sur le tas et devra etre detruit a l'aide
 * de la fonction huff_delete.
 */
HArbre* huff_new_children(HArbre* gauche, HArbre* droite) ;


/* Construction a partir d'une chaine de caracteres
 *   - s est la chaine de caracteres
 *
 * Rq : l'arbre retourne est alloue sur le tas et devra etre detruit a l'aide
 * de la fonction huff_delete.
 */
HArbre* huff_new_string(const std::string& s) ;

/*** destruction ***/

/* Destruction d'un arbre de huffman. Après destruction, l'arbre fourni en
 * parametre n'est plus valide, et la memoire qui avait ete allouee pour lui
 * a ete integralement liberee.
 *   - a est l'arbre a detruire
 * */

void huff_delete(HArbre* a) ;

/*** encodage / decodage ***/

/* Encodage d'une chaine de caracteres
 *   - a est l'arbre a utiliser
 *   - s est la chaine de caracteres
 *   - out est le tableau de bits (fourni vide) a remplir via push_back
 */
void huff_encode(HArbre* a, const std::string& s, std::vector<bool>& out) ;


/* Decodage d'une chaine de caracteres
 *   - a est l'arbre a utiliser
 *   - code est le tableau de bits a decoder
 *   - s est la chaine de caracteres a remplir via push_back
 */
void huff_decode(HArbre* a, const std::vector<bool>& code, std::string& s) ;

#endif
