#include "huffman.hpp"

#include <iostream>

int main() {
  //chaine de caracteres exemple
  const char* s = "abccdddeeeffffggggghhhhhhhiiiiiiiii" ;

  //creation de l'arbre.
  HArbre* a = huff_new_string(s) ;

  //encodage
  std::vector<bool> code ;
  huff_encode(a, s, code) ;

  //affichage du code
  for(const bool& b : code) {
    std::cout << b ;
  }
  std::cout << std::endl ;

  //devrait afficher : 01110011110110011011111111111111101110111001001001001011011011011011000000000000000101010101010101010
  std::vector<bool> test 
  { 
    0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 
    0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
    0
  } ;

  if(code == test) {
    std::cout << "votre encodage semble correct par rapport a l'exemple abccdddeeeffffggggghhhhhhhiiiiiiiii" << std::endl ;
  } else {
    std::cout << "ATTENTION : votre encodage semble incorrect par rapport a l'exemple abccdddeeeffffggggghhhhhhhiiiiiiiii" << std::endl ;
  }

  //decodage pour verification
  std::string decode ;
  huff_decode(a, code, decode) ;
  std::cout << decode << std::endl ;

  if(decode == s) {
    std::cout << "votre decodage semble correct." << std::endl ;
  } else {
    std::cout << "ATTENTION : votre decodage semble incorrect." << std::endl ;
  }

  //menage
  huff_delete(a) ;
}
