#ifndef LIFAP6_PHEAP_HPP
#define LIFAP6_PHEAP_HPP

#include "noeud.hpp"

typedef int Element ;

class PHeap {

  public :

    /* Construction et destruction */

    PHeap() ;

    ~PHeap() ;

    /* Fusion */

    /* fusion de deux pairing heaps
     *
     * rhs est l'arbre a fusionner. 
     *
     * Apres cette fonction rhs doit etre vide et ses noeuds recuperes et
     * fusionnes avec cet arbre.
     * */
    void fusion(PHeap& rhs) ;

    /* Insertion */

    /* insertion dans un pairing heap
     * cle est la priorite
     * valeur est la valeur associee a cette priorite
     * la valeur de retour est l'adresse du noeud cree
     *
     * l'adresse du noeud cree est renvoyee pour fournir un moyen a
     * l'utilisateur de remodifier l'entree par la suite via le retrait d'un
     * noeud ou le changement de priorite*/
    Noeud* inserer(int cle, int valeur) ;

    /* Gestion du minimum */

    /* adresse du noeud racine
     * a partir de cette adresse il est possible de recuperer la cle et la
     * valeur du noeud*/
    Noeud* min() ;

    /* retrait du minimum
     *
     * cette operation retire le minimum de l'arbre, et declenche la fusion par
     * paires pour determiner le nouveau minimum*/
    void retirer_min() ;

    /* Reorganisation de l'arbre */

    /* Ces fonctions ne sont a coder qu'en dernier et seulement apres avoir
     * pris le temps de copier vos fichiers pour les conserver avant de gerer le
     * double chainage qui est necessaire pour les coder.
     * */

    /* retrait de n'importe quel noeud de l'arbre
     * adresse est l'adresse du noeud a retirer 
     * 
     * l'adresse fournie doit avoir ete recuperee comme valeur de retour de la
     * fonction inserer au prealable.*/
    void retirer(Noeud* noeud) ;

    /* changement de cle d'un noeud
     * noeud est l'adresse du noeud a modifier
     * cle est la nouvelle cle a utiliser pour ce noeud
     */
    void changer_cle(Noeud* noeud, int cle) ;

    /* Informations */

    /* taille de l'arbre
     * retourne le nombre de noeuds de l'arbre
     *
     * cette fonction est necessaire pour les tests afin de s'assurer que la
     * taille de l'arbre evolue comme elle le devrait au cours des tests
     */
    unsigned int taille() ;

    /* Utilitaire pour vous aider */

    /* Cette fonction est deja codee pour vous pour vous aider a valider les
     * noeuds en cas de double chainage. Dans le cpp, lorsque vous atteignez le
     * double chainage, decommentez la verification des liens pour l'activer et
     * detecter de potentielles erreurs au fur et a mesure des tests.
     * */

    void valider() ;

  private:

    /* ajouter les attributs et methodes de votre choix */

    /* methode utilitaire pour la validation, deja codee */
    void valider_noeud(Noeud* noeud) ;

} ;

#endif
