#include "pheap.hpp"

#include <iostream>
#include <cassert>
#include <random>

std::mt19937 alea ;

void melanger(int* tab, unsigned int size) {
  for(unsigned int i = 0; i < size - 1; ++i) {
    //selection d'un element restant
    std::uniform_int_distribution<int> d(0, size - i - 1) ;
    int index = d(alea) ;
    int tmp = tab[index] ;
    tab[index] = tab[size - i - 1] ;
    tab[size - i - 1] = tmp ;
  }
}

int main() {
  PHeap ph ;
  int cles[20] ;

  for(unsigned int i = 0; i < 20; ++i) {
    cles[i] = i ;
  }

  //test de l'ordre et de la suppression de minimum
  for(unsigned int i = 0; i < 10; ++i) {
    melanger(cles, 20) ;

    for(unsigned int i = 0; i < 20 ; ++i) {
      ph.inserer(cles[i], 1000 + cles[i]) ;
      ph.valider() ;
      assert(ph.taille() == i+1) ;
    }

    for(unsigned int i = 0; i < 20; ++i) {
      assert(ph.min()->cle == (int) i);
      assert(ph.min()->valeur == 1000 + (int) i);
      ph.retirer_min() ;
      ph.valider() ;
      assert(ph.taille() == 20 - i - 1) ;
    }
  }
  //verification que la structure est vide
  assert(!ph.min()) ;

  std::cout << "ordre et suppression minimum ... OK" << std::endl ;

  //test de la fusion
  PHeap petit_plat ;
  melanger(cles, 20) ;
  for(unsigned int i = 0; i < 20 ; ++i) {
    ph.inserer(cles[i], 1000 + cles[i]) ;
    ph.valider() ;
  }
  melanger(cles, 20) ;
  for(unsigned int i = 0; i < 20 ; ++i) {
    petit_plat.inserer(cles[i], 1000 + cles[i]) ;
    petit_plat.valider() ;
  }
  ph.fusion(petit_plat) ;
  ph.valider() ;
  assert(ph.taille() == 40) ;
  assert(!petit_plat.min()) ;
  for(unsigned int i = 0; i < 20; ++i) {
    assert(ph.min()->cle == (int) i);
    ph.retirer_min() ;
    ph.valider() ;
    assert(ph.min()->cle == (int) i);
    ph.retirer_min() ;
    ph.valider() ;
  }
  //verification que la structure est vide
  assert(!ph.min()) ;

  std::cout << "absorbtion d'un autre arbre ... OK" << std::endl ;

  Noeud* tabnoeud[20] ;

  //test de la suppression d'elements au milieu
  for(unsigned int i = 19; i < 20 ; --i) {
    tabnoeud[i] = ph.inserer(i, 1000 + i) ;
    ph.valider() ;
  }

  for(unsigned int i = 0; i < 20; i+=2) {
    ph.retirer(tabnoeud[i]) ;
    ph.valider() ;
    assert(ph.taille() == 20 - i/2 - 1) ;
  }

  for(unsigned int i = 1; i < 20; i += 2) {
    assert(ph.min()->cle == (int) i);
    ph.retirer(ph.min()) ;
    ph.valider() ;
    assert(ph.taille() == 10 - i/2 - 1) ;
  }
  //verification que la structure est vide
  assert(!ph.min()) ;

  std::cout << "suppression au milieu ... OK" << std::endl ;

  //test du changement de priorite
  melanger(cles, 20) ;
  for(unsigned int i = 0; i < 20 ; ++i) {
    tabnoeud[i] = ph.inserer(cles[i], 1000 + i) ;
    ph.valider() ;
  }
  melanger(cles, 20) ;
  for(unsigned int i = 0; i < 20 ; ++i) {
    ph.changer_cle(tabnoeud[cles[i]], 100 + i) ;
    ph.valider() ;
    assert(ph.taille() == 20) ;
  }

  for(unsigned int i = 0; i < 20; ++i) {
    assert(ph.min()->cle == 100 + (int) i);
    ph.retirer(ph.min()) ;
    ph.valider() ;
  }

  std::cout << "changement de priorite ... OK" << std::endl ;

  return 0 ;
}
